/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import sleep.engine.types.MyLinkedList;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.SleepUtils;

public class ListContainer
implements ScalarArray {
    protected List values;

    public ListContainer() {
        this.values = new MyLinkedList();
    }

    public ListContainer(List list) {
        this.values = list;
    }

    public ScalarArray sublist(int n, int n2) {
        return new ListContainer(this.values.subList(n, n2));
    }

    public ListContainer(Collection collection) {
        this();
        this.values.addAll(collection);
    }

    public Scalar pop() {
        return (Scalar)this.values.remove(this.values.size() - 1);
    }

    public Scalar push(Scalar scalar) {
        this.values.add(scalar);
        return scalar;
    }

    public int size() {
        return this.values.size();
    }

    public void sort(Comparator comparator) {
        Collections.sort(this.values, comparator);
    }

    public Scalar getAt(int n) {
        if (n >= this.size()) {
            Scalar scalar = SleepUtils.getEmptyScalar();
            this.values.add(scalar);
            return scalar;
        }
        return (Scalar)this.values.get(n);
    }

    public void remove(Scalar scalar) {
        SleepUtils.removeScalar(this.values.iterator(), scalar);
    }

    public Scalar remove(int n) {
        return (Scalar)this.values.remove(n);
    }

    public Iterator scalarIterator() {
        return this.values.iterator();
    }

    public Scalar add(Scalar scalar, int n) {
        this.values.add(n, scalar);
        return scalar;
    }

    public String toString() {
        return this.values.toString();
    }
}

