/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util.png;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class mxSimpleRenderedImage
implements RenderedImage {
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset = 0;
    protected int tileGridYOffset = 0;
    protected SampleModel sampleModel = null;
    protected ColorModel colorModel = null;
    protected List sources = new ArrayList();
    protected Map properties = new HashMap();

    @Override
    public int getMinX() {
        return this.minX;
    }

    public final int getMaxX() {
        return this.getMinX() + this.getWidth();
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    public final int getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    @Override
    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    @Override
    public int getMinTileX() {
        return this.XToTileX(this.getMinX());
    }

    public int getMaxTileX() {
        return this.XToTileX(this.getMaxX() - 1);
    }

    @Override
    public int getNumXTiles() {
        return this.getMaxTileX() - this.getMinTileX() + 1;
    }

    @Override
    public int getMinTileY() {
        return this.YToTileY(this.getMinY());
    }

    public int getMaxTileY() {
        return this.YToTileY(this.getMaxY() - 1);
    }

    @Override
    public int getNumYTiles() {
        return this.getMaxTileY() - this.getMinTileY() + 1;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Object getProperty(String string) {
        string = string.toLowerCase();
        return this.properties.get(string);
    }

    @Override
    public String[] getPropertyNames() {
        String[] stringArray = new String[this.properties.size()];
        this.properties.keySet().toArray(stringArray);
        return stringArray;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = this.getPropertyNames();
        if (stringArray == null) {
            return null;
        }
        string = string.toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            arrayList.add(stringArray[i]);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public static int XToTileX(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public static int YToTileY(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public int XToTileX(int n) {
        return mxSimpleRenderedImage.XToTileX(n, this.getTileGridXOffset(), this.getTileWidth());
    }

    public int YToTileY(int n) {
        return mxSimpleRenderedImage.YToTileY(n, this.getTileGridYOffset(), this.getTileHeight());
    }

    public static int tileXToX(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    public static int tileYToY(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    public int tileXToX(int n) {
        return n * this.tileWidth + this.tileGridXOffset;
    }

    public int tileYToY(int n) {
        return n * this.tileHeight + this.tileGridYOffset;
    }

    public Vector getSources() {
        return null;
    }

    @Override
    public Raster getData() {
        Rectangle rectangle = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
        return this.getData(rectangle);
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        if (n == n3 && n2 == n4) {
            Raster raster = this.getTile(n, n2);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, rectangle.getLocation());
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                Raster raster = this.getTile(j, i);
                Rectangle rectangle2 = rectangle.intersection(raster.getBounds());
                Raster raster2 = raster.createChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle2.x, rectangle2.y, null);
                writableRaster.setDataElements(0, 0, raster2);
            }
        }
        return writableRaster;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        Rectangle rectangle;
        if (writableRaster == null) {
            rectangle = this.getBounds();
            Point point = new Point(this.minX, this.minY);
            SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(this.width, this.height);
            writableRaster = Raster.createWritableRaster(sampleModel, point);
        } else {
            rectangle = writableRaster.getBounds();
        }
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                Raster raster = this.getTile(j, i);
                Rectangle rectangle2 = rectangle.intersection(raster.getBounds());
                Raster raster2 = raster.createChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle2.x, rectangle2.y, null);
                writableRaster.setDataElements(0, 0, raster2);
            }
        }
        return writableRaster;
    }
}

