/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.dex.writer.DexFileWriter;
import com.googlecode.d2j.smali.Smali;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@BaseCmd.Syntax(cmd="d2j-smali", syntax="[options] [--] [<smali-file>|folder]*", desc="assembles a set of smali files into a dex file", onlineHelp="https://sourceforge.net/p/dex2jar/wiki/Smali")
public class SmaliCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="x", longOpt="allow-odex-instructions", hasArg=false, description="[not impl] allow odex instructions to be compiled into the dex file. Only a few instructions are supported - the ones that can exist in a dead code path and not cause dalvik to reject the class")
    private boolean allowOdexInstructions;
    @BaseCmd.Opt(opt="a", longOpt="api-level", description="[not impl] The numeric api-level of the file to generate, e.g. 14 for ICS. If not specified, it defaults to 14 (ICS).", argName="API_LEVEL")
    private int apiLevel = 14;
    @BaseCmd.Opt(opt="v", longOpt="version", hasArg=false, description="prints the version then exits")
    private boolean showVersionThenExits;
    @BaseCmd.Opt(opt="o", longOpt="output", description="the name of the dex file that will be written. The default is out.dex", argName="FILE")
    private Path output;
    @BaseCmd.Opt(opt="-", hasArg=false, description="read smali from stdin")
    private boolean readSmaliFromStdin;

    public static void main(String[] args) {
        new SmaliCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        if (this.showVersionThenExits) {
            System.out.println("smali 1.4.2p (https://sourceforge.net/p/dex2jar)");
            System.out.println("Copyright (c) 2009-2013 Panxiaobo (pxb1988@gmail.com)");
            System.out.println("Apache license (http://www.apache.org/licenses/LICENSE-2.0)");
            return;
        }
        if (!this.readSmaliFromStdin && this.remainingArgs.length < 1) {
            System.err.println("ERRPR: no file to process");
            return;
        }
        if (this.output == null) {
            this.output = new File("out.dex").toPath();
        }
        Smali smali = new Smali();
        DexFileWriter fw = new DexFileWriter();
        DexFileVisitor fv = new DexFileVisitor((DexFileVisitor)fw){

            public void visitEnd() {
            }
        };
        if (this.readSmaliFromStdin) {
            Smali.smaliFile("<stdin>", System.in, fv);
            System.err.println("smali <stdin> -> " + this.output);
        }
        for (String s : this.remainingArgs) {
            Path file = new File(s).toPath();
            if (!Files.exists(file, new LinkOption[0])) {
                System.err.println("skip " + file + ", it is not a dir or a file");
                continue;
            }
            System.err.println("smali " + s + " -> " + this.output);
            Smali.smali(file, fv);
        }
        fw.visitEnd();
        byte[] data = fw.toByteArray();
        Files.write(this.output, data, new OpenOption[0]);
    }
}

