/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.HTMLElementTerminatingTagNameSets;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;

public final class StartTag
extends Tag {
    private final Attributes attributes;
    final StartTagType startTagType;

    StartTag(Source source, int n, int n2, StartTagType startTagType, String string, Attributes attributes) {
        super(source, n, n2, string);
        this.attributes = attributes;
        this.startTagType = startTagType;
    }

    StartTag() {
        this.attributes = null;
        this.startTagType = null;
    }

    public Element getElement() {
        if (this.element == Element.NOT_CACHED) {
            EndTag endTag = this.findEndTagInternal();
            this.element = new Element(this.source, this, endTag);
            if (endTag != null) {
                if (endTag.element != Element.NOT_CACHED && this.source.logger.isInfoEnabled() && !this.element.equals(endTag.element)) {
                    this.source.logger.info(this.source.getRowColumnVector(endTag.begin).appendTo(new StringBuffer(200).append("End tag ").append((Object)endTag).append(" at ")).append(" terminates more than one element").toString());
                }
                endTag.element = this.element;
            }
        }
        return this.element;
    }

    public boolean isEmptyElementTag() {
        return this.isSyntacticalEmptyElementTag() && !HTMLElements.isClosingSlashIgnored(this.name);
    }

    public boolean isSyntacticalEmptyElementTag() {
        return this.startTagType == StartTagType.NORMAL && this.source.charAt(this.end - 2) == '/';
    }

    public StartTagType getStartTagType() {
        return this.startTagType;
    }

    public TagType getTagType() {
        return this.startTagType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String string) {
        return this.attributes == null ? null : this.attributes.getValue(string);
    }

    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int n2 = this.end - this.startTagType.getClosingDelimiter().length();
        int n3 = this.begin + 1 + this.name.length();
        while (!StartTag.isXMLNameStartChar(this.source.charAt(n3))) {
            if (++n3 != n2) continue;
            return null;
        }
        return Attributes.construct(this.source, this.begin, n3, n2, this.startTagType, this.name, n);
    }

    public Segment getTagContent() {
        return new Segment(this.source, this.begin + 1 + this.name.length(), this.end - this.startTagType.getClosingDelimiter().length());
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public boolean isEndTagForbidden() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() == null;
        }
        if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return this.isSyntacticalEmptyElementTag();
    }

    public boolean isEndTagRequired() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() != null;
        }
        if (HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return !this.isSyntacticalEmptyElementTag();
    }

    public boolean isUnregistered() {
        return this.startTagType == StartTagType.UNREGISTERED;
    }

    public String tidy() {
        return this.tidy(false);
    }

    public String tidy(boolean bl) {
        if (this.attributes == null || this.attributes.containsServerTagOutsideOfAttributeValue) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        if (bl && this.startTagType == StartTagType.NORMAL) {
            stringBuffer.append(this.name);
        } else {
            int n;
            int n2 = n + this.name.length();
            for (n = this.begin + this.startTagType.startDelimiterPrefix.length(); n < n2; ++n) {
                stringBuffer.append(this.source.charAt(n));
            }
        }
        this.attributes.appendTidy(stringBuffer, this.findNextTag());
        if (this.startTagType == StartTagType.NORMAL && this.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(this.name)) {
            stringBuffer.append(" /");
        }
        stringBuffer.append(this.startTagType.getClosingDelimiter());
        return stringBuffer.toString();
    }

    public static String generateHTML(String string, Map map, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        stringBuffer.append('<').append(string);
        try {
            Attributes.appendHTML(stringWriter, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            stringBuffer.append(" />");
        } else {
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendDebugTag(stringBuffer);
        stringBuffer.append(' ');
        this.appendDebugTagType(stringBuffer);
        stringBuffer.append(super.getDebugInfo());
        return stringBuffer.toString();
    }

    StringBuffer appendDebugTag(StringBuffer stringBuffer) {
        if (this.startTagType == StartTagType.NORMAL && this.getAttributes().isEmpty()) {
            stringBuffer.append((Object)this);
        } else {
            stringBuffer.append('<').append((Object)this.getNameSegment()).append(' ');
            if (this.isSyntacticalEmptyElementTag()) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.startTagType.getClosingDelimiter());
        }
        return stringBuffer;
    }

    StringBuffer appendDebugTagType(StringBuffer stringBuffer) {
        if (this.startTagType != StartTagType.NORMAL) {
            stringBuffer.append('(').append(this.startTagType.getDescription()).append(") ");
        }
        return stringBuffer;
    }

    private EndTag findEndTagInternal() {
        Object object;
        boolean bl = true;
        EndTagType endTagType = this.startTagType.getCorrespondingEndTagType();
        if (this.startTagType == StartTagType.NORMAL) {
            object = HTMLElements.getTerminatingTagNameSets(this.name);
            if (object != null) {
                return this.findOptionalEndTag((HTMLElementTerminatingTagNameSets)object);
            }
            if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
                return null;
            }
            boolean bl2 = bl = !HTMLElements.getEndTagRequiredElementNames().contains(this.name);
            if (bl && this.isSyntacticalEmptyElementTag()) {
                return null;
            }
        } else if (endTagType == null) {
            return null;
        }
        if ((object = this.source.findNextEndTag(this.end, endTagType.getEndTagName(this.name), endTagType)) != null) {
            if (this.startTagType == StartTagType.NORMAL && HTMLElements.END_TAG_REQUIRED_NESTING_FORBIDDEN_SET.contains(this.name)) {
                StartTag startTag = this.source.findNextStartTag(this.end, this.name);
                if (startTag == null || startTag.begin > ((EndTag)object).begin) {
                    return object;
                }
                if (this.source.logger.isInfoEnabled()) {
                    this.source.logger.info(this.source.getRowColumnVector(this.begin).appendTo(new StringBuffer(200).append("StartTag at ")).append(" missing required end tag - invalid nested start tag encountered before end tag").toString());
                }
                return new EndTag(this.source, startTag.begin, startTag.begin, EndTagType.NORMAL, this.name);
            }
            Segment[] segmentArray = this.findEndTag((EndTag)object, bl, Tag.isXMLName(this.name));
            if (segmentArray != null) {
                return (EndTag)segmentArray[0];
            }
        }
        if (this.source.logger.isInfoEnabled()) {
            this.source.logger.info(this.source.getRowColumnVector(this.begin).appendTo(new StringBuffer(200).append("StartTag at ")).append(" missing required end tag").toString());
        }
        return null;
    }

    private EndTag findOptionalEndTag(HTMLElementTerminatingTagNameSets hTMLElementTerminatingTagNameSets) {
        Tag tag;
        int n = this.end;
        while (n < this.source.end && (tag = Tag.findNextTag(this.source, n)) != null) {
            Set set;
            if (tag instanceof EndTag) {
                if (tag.name == this.name) {
                    return (EndTag)tag;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingEndTagNameSet;
            } else {
                set = hTMLElementTerminatingTagNameSets.NonterminatingElementNameSet;
                if (set != null && set.contains(tag.name)) {
                    Element element = ((StartTag)tag).getElement();
                    n = element.end;
                    continue;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingStartTagNameSet;
            }
            if (set != null && set.contains(tag.name)) {
                return new EndTag(this.source, tag.begin, tag.begin, EndTagType.NORMAL, this.name);
            }
            n = tag.begin + 1;
        }
        return new EndTag(this.source, this.source.end, this.source.end, EndTagType.NORMAL, this.name);
    }

    static char[] getStartDelimiterCharArray(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        char[] cArray = Util.getConcatenatedCharArray("<", string);
        if (cArray["<".length()] == '/') {
            throw new IllegalArgumentException("searchName argument \"" + string + "\" must not start with '/'");
        }
        return cArray;
    }

    static StartTag findPrevious(Source source, int n, String string, StartTagType startTagType) {
        return StartTag.findPrevious(source, n, string, startTagType, startTagType == StartTagType.NORMAL ? Tag.isXMLName(string) : true);
    }

    static StartTag findPrevious(Source source, int n, String string, StartTagType startTagType, boolean bl) {
        if (string == null) {
            return (StartTag)source.findPreviousTag(n, startTagType);
        }
        char[] cArray = StartTag.getStartDelimiterCharArray(string);
        ParseText parseText = source.getParseText();
        int n2 = n;
        do {
            char c;
            if ((n2 = parseText.lastIndexOf(cArray, n2)) == -1) {
                return null;
            }
            StartTag startTag = (StartTag)Tag.getTagAt(source, n2, false);
            if (startTag == null || startTagType != startTag.getStartTagType() && (startTagType != StartTagType.NORMAL || bl || !startTag.isUnregistered()) || startTag.getStartTagType().isNameAfterPrefixRequired() && startTag.getName().length() > string.length() && (c = string.charAt(string.length() - 1)) != ':' && StartTag.isXMLNameChar(c)) continue;
            return startTag;
        } while ((n2 -= 2) >= 0);
        return null;
    }

    static StartTag findNext(Source source, int n, String string, StartTagType startTagType) {
        return StartTag.findNext(source, n, string, startTagType, startTagType == StartTagType.NORMAL ? Tag.isXMLName(string) : true);
    }

    static StartTag findNext(Source source, int n, String string, StartTagType startTagType, boolean bl) {
        if (string == null) {
            return (StartTag)source.findNextTag(n, startTagType);
        }
        char[] cArray = StartTag.getStartDelimiterCharArray(string);
        try {
            ParseText parseText = source.getParseText();
            int n2 = n;
            do {
                char c;
                if ((n2 = parseText.indexOf(cArray, n2)) == -1) {
                    return null;
                }
                StartTag startTag = (StartTag)Tag.getTagAt(source, n2, false);
                if (startTag == null || startTagType != startTag.getStartTagType() && (startTagType != StartTagType.NORMAL || bl || !startTag.isUnregistered()) || startTag.getStartTagType().isNameAfterPrefixRequired() && startTag.getName().length() > string.length() && (c = string.charAt(string.length() - 1)) != ':' && StartTag.isXMLNameChar(c)) continue;
                return startTag;
            } while (++n2 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static StartTag findPrevious(Source source, int n) {
        Tag tag;
        while ((tag = Tag.findPreviousTag(source, n)) != null) {
            if (tag instanceof StartTag) {
                return (StartTag)tag;
            }
            --n;
        }
        return null;
    }

    static StartTag findNext(Source source, int n) {
        Tag tag;
        while ((tag = Tag.findNextTag(source, n)) != null) {
            if (tag instanceof StartTag) {
                return (StartTag)tag;
            }
            ++n;
        }
        return null;
    }

    static StartTag findNext(Source source, int n, String string, String string2, boolean bl) {
        if (string2 == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        String string3 = string2.length() >= 3 || string2.length() > 0 && string.length() < 3 ? string2 : string;
        char[] cArray = string3.toLowerCase().toCharArray();
        ParseText parseText = source.getParseText();
        int n2 = n;
        while (n2 < source.end) {
            String string4;
            StartTag startTag;
            if ((n2 = parseText.indexOf(cArray, n2)) == -1) {
                return null;
            }
            Tag tag = source.findEnclosingTag(n2);
            if (tag == null || !(tag instanceof StartTag)) {
                ++n2;
                continue;
            }
            if (tag.begin >= n && (startTag = (StartTag)tag).getAttributes() != null && (string4 = startTag.getAttributes().getValue(string)) != null) {
                if (string2.equals(string4)) {
                    return startTag;
                }
                if (string2.equalsIgnoreCase(string4)) {
                    if (!bl) {
                        return startTag;
                    }
                    if (source.logger.isInfoEnabled()) {
                        source.logger.info(source.getRowColumnVector(n2).appendTo(new StringBuffer(200)).append(": StartTag with attribute ").append(string).append("=\"").append(string4).append("\" ignored during search because its case does not match search value \"").append(string2).append('\"').toString());
                    }
                }
            }
            n2 = tag.end + 5;
        }
        return null;
    }

    private Segment[] findEndTag(EndTag endTag, boolean bl, boolean bl2) {
        StartTag startTag = StartTag.findNext(this.source, this.end, this.name, this.startTagType, bl2);
        if (bl) {
            while (startTag != null && startTag.isSyntacticalEmptyElementTag()) {
                startTag = StartTag.findNext(this.source, startTag.end, this.name, this.startTagType, bl2);
            }
        }
        return this.findEndTag(this.end, startTag, endTag, bl, bl2);
    }

    private Segment[] findEndTag(int n, StartTag startTag, EndTag endTag, boolean bl, boolean bl2) {
        if (endTag == null) {
            return null;
        }
        Segment[] segmentArray = new Segment[]{endTag, startTag};
        if (startTag == null || startTag.begin > endTag.begin) {
            return segmentArray;
        }
        Segment[] segmentArray2 = startTag.findEndTag(endTag, bl, bl2);
        if (segmentArray2 == null) {
            return null;
        }
        EndTag endTag2 = (EndTag)segmentArray2[0];
        EndTag endTag3 = EndTag.findNext(this.source, endTag2.end, endTag.getName(), endTag.getEndTagType());
        return this.findEndTag(endTag2.end, (StartTag)segmentArray2[1], endTag3, bl, bl2);
    }
}

