/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;

final class StreamEncodingDetector {
    private final InputStream inputStream;
    private String encoding = null;
    private String encodingSpecificationInfo = null;
    private boolean definitive = true;
    private boolean documentSpecifiedEncodingPossible = true;
    private static final String UTF_16 = "UTF-16";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String EBCDIC = "Cp037";
    private static final String SCSU = "SCSU";
    private static final String UTF_7 = "UTF-7";
    private static final String UTF_EBCDIC = "UTF-EBCDIC";
    private static final String BOCU_1 = "BOCU-1";
    private static final String UTF_32 = "UTF-32";
    private static final String UTF_32BE = "UTF-32BE";
    private static final String UTF_32LE = "UTF-32LE";

    public StreamEncodingDetector(URLConnection uRLConnection) throws IOException {
        HttpURLConnection httpURLConnection = uRLConnection instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection : null;
        InputStream inputStream = uRLConnection.getInputStream();
        String string = uRLConnection.getContentType();
        if (string != null) {
            this.encoding = Source.getCharsetParameterFromHttpHeaderValue(string);
            if (this.encoding != null) {
                this.inputStream = inputStream;
                this.encodingSpecificationInfo = "HTTP header Content-Type: " + string;
                return;
            }
        }
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.init();
    }

    public StreamEncodingDetector(InputStream inputStream) throws IOException {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.init();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        return this.encodingSpecificationInfo;
    }

    public boolean isDifinitive() {
        return this.definitive;
    }

    public boolean isDocumentSpecifiedEncodingPossible() {
        return this.documentSpecifiedEncodingPossible;
    }

    public Reader openReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.inputStream, ISO_8859_1);
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new UnsupportedEncodingException(this.encoding + " - " + this.encodingSpecificationInfo);
        }
        return new InputStreamReader(this.inputStream, this.encoding);
    }

    private boolean setEncoding(String string, String string2) {
        this.encoding = string;
        this.encodingSpecificationInfo = string2;
        return true;
    }

    private boolean init() throws IOException {
        this.inputStream.mark(4);
        int n = this.inputStream.read();
        if (n == -1) {
            return this.setEncoding(null, "empty input stream");
        }
        int n2 = this.inputStream.read();
        int n3 = this.inputStream.read();
        int n4 = this.inputStream.read();
        this.inputStream.reset();
        if (n == 239) {
            if (n2 == 187 && n3 == 191) {
                return this.setEncoding(UTF_8, "UTF-8 Byte Order Mark (EF BB BF)");
            }
        } else if (n == 254) {
            if (n2 == 255) {
                return this.setEncoding(UTF_16, "UTF-16 big-endian Byte Order Mark (FE FF)");
            }
        } else if (n == 255) {
            if (n2 == 254) {
                if (n3 == 0 && n4 == 0) {
                    return this.setEncoding(UTF_32, "UTF-32 little-endian Byte Order Mark (FF EE 00 00)");
                }
                return this.setEncoding(UTF_16, "UTF-16 little-endian Byte Order Mark (FF EE)");
            }
        } else if (n == 0) {
            if (n2 == 0 && n3 == 254 && n4 == 255) {
                return this.setEncoding(UTF_32, "UTF-32 big-endian Byte Order Mark (00 00 FE FF)");
            }
        } else if (n == 14) {
            if (n2 == 254 && n3 == 255) {
                return this.setEncoding(SCSU, "SCSU Byte Order Mark (0E FE FF)");
            }
        } else if (n == 43) {
            if (n2 == 47 && n3 == 118) {
                return this.setEncoding(UTF_7, "UTF-7 Byte Order Mark (2B 2F 76)");
            }
        } else if (n == 221) {
            if (n2 == 115 && n3 == 102 && n4 == 115) {
                return this.setEncoding(UTF_EBCDIC, "UTF-EBCDIC Byte Order Mark (DD 73 66 73)");
            }
        } else if (n == 251 && n2 == 238 && n3 == 40) {
            return this.setEncoding(BOCU_1, "BOCU-1 Byte Order Mark (FB EE 28)");
        }
        this.definitive = false;
        if (n4 == -1) {
            this.documentSpecifiedEncodingPossible = false;
            if (n2 == -1 || n3 != -1) {
                return this.setEncoding(ISO_8859_1, "default 8-bit ASCII-compatible encoding (stream 3 bytes long)");
            }
            if (n == 0) {
                return this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with 00, stream 2 bytes long)");
            }
            if (n2 == 0) {
                return this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream pattern XX 00, stream 2 bytes long)");
            }
            return this.setEncoding(ISO_8859_1, "default 8-bit ASCII-compatible encoding (no 00 bytes present, stream 2 bytes long)");
        }
        if (n == 0) {
            if (n2 == 0) {
                return this.setEncoding(UTF_32BE, "default 32-bit BE encoding (byte stream starts with 00 00)");
            }
            return this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with 00)");
        }
        if (n4 == 0) {
            if (n3 == 0) {
                return this.setEncoding(UTF_32LE, "default 32-bit LE encoding (byte stream starts with pattern XX ?? 00 00)");
            }
            return this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream stars with pattern XX ?? XX 00)");
        }
        if (n2 == 0) {
            return this.setEncoding(UTF_16LE, "default 16-bit LE encoding (byte stream starts with pattern XX 00 ?? XX)");
        }
        if (n3 == 0) {
            return this.setEncoding(UTF_16BE, "default 16-bit BE encoding (byte stream starts with pattern XX XX 00 XX)");
        }
        if (n == 76) {
            if (n2 == 111 && n3 == 167 && n4 == 148) {
                return this.setEncoding(EBCDIC, "default EBCDIC encoding (<?xml...> detected)");
            }
            if (n2 == 90 && n3 == 196 && n4 == 214) {
                return this.setEncoding(EBCDIC, "default EBCDIC encoding (<!DOCTYPE...> detected)");
            }
            if ((n2 & n3 & n4 & 0x80) != 0) {
                return this.setEncoding(EBCDIC, "default EBCDIC-compatible encoding (HTML element detected)");
            }
        }
        return this.setEncoding(ISO_8859_1, "default 8-bit ASCII-compatible encoding (no 00 bytes present in first four bytes of stream)");
    }
}

