/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.GPTHeader;

public class MutableGPTHeader
extends GPTHeader {
    public MutableGPTHeader(int blockSize) {
        super(blockSize);
    }

    public MutableGPTHeader(GPTHeader source) {
        super(source);
    }

    public void setFields(GPTHeader source) {
        this.setFieldsInternal(source);
    }

    public void setSignature(byte[] data, int off) {
        MutableGPTHeader.copyData(data, off, this.signature);
    }

    public void setRevision(int i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.revision);
    }

    public void setHeaderSize(int i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.headerSize);
    }

    public void setCRC32Checksum(int i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.crc32Checksum);
    }

    public void setReserved1(int i) {
        Util.arrayCopy(Util.toByteArrayBE(i), this.reserved1);
    }

    public void setPrimaryLBA(long i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.primaryLBA);
    }

    public void setBackupLBA(long i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.backupLBA);
    }

    public void setFirstUsableLBA(long i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.firstUsableLBA);
    }

    public void setLastUsableLBA(long i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.lastUsableLBA);
    }

    public void setDiskGUID(byte[] data, int off) {
        MutableGPTHeader.copyData(data, off, this.diskGUID);
    }

    public void setPartitionEntryLBA(long i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.partitionEntryLBA);
    }

    public void setNumberOfPartitionEntries(int i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.numberOfPartitionEntries);
    }

    public void setSizeOfPartitionEntry(int i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.sizeOfPartitionEntry);
    }

    public void setPartitionEntryArrayCRC32(int i) {
        Util.arrayCopy(Util.toByteArrayLE(i), this.partitionEntryArrayCRC32);
    }

    public void setReserved2(byte[] data, int off) {
        MutableGPTHeader.copyData(data, off, this.reserved2);
    }

    private static void copyData(byte[] data, int off, byte[] dest) {
        MutableGPTHeader.copyData(data, off, dest, dest.length);
    }

    private static void copyData(byte[] data, int off, byte[] dest, int len) {
        if (off + len > data.length) {
            throw new IllegalArgumentException("Length of input data must be " + len + ".");
        }
        System.arraycopy(data, off, dest, 0, len);
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "MutableGPTHeader:");
        this.printFields(ps, prefix);
    }
}

