/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.condition;

import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.Condition;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.util.ModelUIUtil;
import com.aspect.snoop.util.ReflectionUtil;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class AddEditConditionView
extends JDialog {
    private int parameter;
    private String operand;
    private Condition.Operator operator;
    private JButton btnAddCondition;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox lstOperator;
    private JComboBox lstParameters;
    private JTextField txtOperand;

    public AddEditConditionView(Frame parent, boolean modal, Class[] parameterTypes) {
        this(parent, modal, parameterTypes, null);
    }

    public AddEditConditionView(Frame parent, boolean modal, Class[] parameterTypes, Condition condition) {
        super(parent, modal);
        this.initComponents();
        this.lstParameters.removeAllItems();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class type = parameterTypes[i];
            String simple = type.getSimpleName();
            if (!type.getName().startsWith("java.lang.") || type.getName().indexOf(".") != -1) {
                simple = ReflectionUtil.getSimpleClassName(type.getName());
            }
            this.lstParameters.insertItemAt("Parameter " + (i + 1) + ": " + simple, i);
        }
        if (condition != null) {
            this.setTitle("Editing condition");
            this.btnAddCondition.setText("Save condition");
            this.txtOperand.setText(condition.getOperand());
            this.lstOperator.setSelectedItem(ModelUIUtil.getDescriptionByOperator(condition.getOperator()));
            this.lstParameters.setSelectedIndex(condition.getParameter());
        }
        this.txtOperand.requestFocus();
        this.parameter = -1;
        this.operand = null;
        this.operator = null;
    }

    private void initComponents() {
        this.lstParameters = new JComboBox();
        this.lstOperator = new JComboBox();
        this.txtOperand = new JTextField();
        this.btnAddCondition = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(AddEditConditionView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.lstParameters.setModel(new DefaultComboBoxModel<String>(new String[]{"Parameter 1 (String)", "Parameter 2 (int)"}));
        this.lstParameters.setName("lstParameters");
        this.lstOperator.setModel(new DefaultComboBoxModel<String>(new String[]{"equals", "contains", "starts with", "ends with", "greater than", "less than"}));
        this.lstOperator.setName("lstOperator");
        this.txtOperand.setText(resourceMap.getString("txtOperand.text", new Object[0]));
        this.txtOperand.setName("txtOperand");
        this.txtOperand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddEditConditionView.this.txtOperandActionPerformed(evt);
            }
        });
        this.btnAddCondition.setFont(resourceMap.getFont("btnAddCondition.font"));
        this.btnAddCondition.setText(resourceMap.getString("btnAddCondition.text", new Object[0]));
        this.btnAddCondition.setToolTipText(resourceMap.getString("btnAddCondition.toolTipText", new Object[0]));
        this.btnAddCondition.setName("btnAddCondition");
        this.btnAddCondition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddEditConditionView.this.btnAddConditionActionPerformed(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnAddCondition, -1, 376, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lstParameters, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addComponent(this.lstOperator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtOperand, -1, 151, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lstParameters, -2, -1, -2).addComponent(this.lstOperator, -2, -1, -2).addComponent(this.txtOperand, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnAddCondition, -1, 39, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void btnAddConditionActionPerformed(ActionEvent evt) {
        if (this.lstParameters.getSelectedIndex() != -1 && !"".equals(this.txtOperand.getText())) {
            this.operator = ModelUIUtil.getOperatorByDescription((String)this.lstOperator.getSelectedItem());
            if (!(!this.operator.equals((Object)Condition.Operator.GreaterThan) && !this.operator.equals((Object)Condition.Operator.LessThan) || this.isInt(this.operand) || this.isFloat(this.operand) || this.isDouble(this.operand))) {
                return;
            }
            this.finalizeSelection();
            this.dispose();
        }
    }

    private void txtOperandActionPerformed(ActionEvent evt) {
        this.btnAddCondition.doClick();
    }

    private void finalizeSelection() {
        this.operator = ModelUIUtil.getOperatorByDescription((String)this.lstOperator.getSelectedItem());
        this.operand = this.txtOperand.getText();
        this.parameter = this.lstParameters.getSelectedIndex();
    }

    public int getParameter() {
        return this.parameter;
    }

    public String getOperand() {
        return this.operand;
    }

    public Condition.Operator getOperator() {
        return this.operator;
    }

    private boolean isInt(String operand) {
        try {
            Integer.parseInt(operand);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isFloat(String operand) {
        try {
            Float.parseFloat(operand);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isDouble(String operand) {
        try {
            Double.parseDouble(operand);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

