/*
 * Decompiled with CFR 0.152.
 */
package com.jsql;

import com.jsql.model.InjectionModel;
import com.jsql.util.GitUtil;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.JFrameView;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.AWTError;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainApplication {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final InjectionModel injectionModel;

    private MainApplication() {
    }

    public static void main(String[] args) {
        MediatorHelper.register(injectionModel);
        injectionModel.getMediatorUtils().getExceptionUtil().setUncaughtExceptionHandler();
        injectionModel.getMediatorUtils().getProxyUtil().initializeProxy();
        injectionModel.getMediatorUtils().getAuthenticationUtil().setKerberosCifs();
        try {
            JFrameView view = new JFrameView();
            MediatorHelper.register(view);
            injectionModel.subscribe(view.getSubscriber());
        }
        catch (HeadlessException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, String.format("HeadlessException, command line execution in jSQL not supported yet: %s", e.getMessage()), (Throwable)e);
            return;
        }
        catch (AWTError e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, String.format("Java Access Bridge missing or corrupt, check your access bridge definition in JDK_HOME/jre/lib/accessibility.properties: %s", e.getMessage()), (Throwable)e);
            return;
        }
        injectionModel.displayVersion();
        if (!injectionModel.getMediatorUtils().getProxyUtil().isLive(GitUtil.ShowOnConsole.YES)) {
            return;
        }
        if (injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingUpdate()) {
            injectionModel.getMediatorUtils().getGitUtil().checkUpdate(GitUtil.ShowOnConsole.NO);
        }
        I18nUtil.checkCurrentLanguage();
        injectionModel.getMediatorUtils().getGitUtil().showNews();
        MainApplication.check4K();
    }

    private static void apply4K() {
        if (injectionModel.getMediatorUtils().getPreferencesUtil().is4K()) {
            System.setProperty("sun.java2d.uiScale", "2.5");
        }
    }

    private static void check4K() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)screenSize.getWidth();
        if (width >= 3840 && !injectionModel.getMediatorUtils().getPreferencesUtil().is4K()) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Your screen seems compatible with 4K resolution, enable high-definition mode in Preferences");
        }
    }

    static {
        if (GraphicsEnvironment.isHeadless()) {
            LOGGER.log(Level.ERROR, "Headless runtime detected, please install or use default Java runtime instead of headless runtime");
            System.exit(1);
        }
        injectionModel = new InjectionModel();
        if (!"true".equals(System.getenv("FROM_CI_PIPELINE"))) {
            injectionModel.getMediatorUtils().getPreferencesUtil().loadSavedPreferences();
        }
        MainApplication.apply4K();
    }
}

