/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.suspendable.AbstractSuspendable;
import java.util.EnumMap;

public abstract class AbstractStrategy {
    protected static final String KEY_LOG_CHECKING_STRATEGY = "LOG_CHECKING_STRATEGY";
    protected static final String KEY_LOG_VULNERABLE = "LOG_VULNERABLE";
    protected String visibleIndex;
    protected String sourceIndexesFound = "";
    protected boolean isApplicable = false;
    protected final InjectionModel injectionModel;

    protected AbstractStrategy(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public abstract void checkApplicability() throws JSqlException;

    protected abstract void allow(int ... var1);

    protected abstract void unallow(int ... var1);

    public abstract String inject(String var1, String var2, AbstractSuspendable var3, String var4) throws StoppedByUserSlidingException;

    public abstract void activateStrategy();

    public abstract String getPerformanceLength();

    public abstract String getName();

    public void markVulnerability(Interaction message, int ... indexErrorStrategy) {
        Request request = new Request();
        request.setMessage(message);
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlByUser());
        if (indexErrorStrategy.length > 0) {
            msgHeader.put(Header.INDEX_ERROR_STRATEGY, Integer.valueOf(indexErrorStrategy[0]));
            msgHeader.put(Header.INJECTION_MODEL, this.injectionModel);
        }
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
    }

    public String toString() {
        return this.getName();
    }

    public boolean isApplicable() {
        return this.isApplicable;
    }

    public void setApplicable(boolean isApplicable) {
        this.isApplicable = isApplicable;
    }

    public String getVisibleIndex() {
        return this.visibleIndex;
    }

    public void setVisibleIndex(String visibleIndex) {
        this.visibleIndex = visibleIndex;
    }

    public String getSourceIndexesFound() {
        return this.sourceIndexesFound;
    }

    public void setSourceIndexesFound(String sourceIndexesFound) {
        this.sourceIndexesFound = sourceIndexesFound;
    }
}

