/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBoolean;
import com.jsql.model.injection.strategy.blind.InjectionMultibit;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategyInjectionMultibit
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private InjectionMultibit injectionMultibit;

    public StrategyInjectionMultibit(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() throws StoppedByUserSlidingException {
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isStrategyMultibitDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy Multibit disabled");
            return;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} Multibit...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"));
        this.injectionMultibit = new InjectionMultibit(this.injectionModel, AbstractInjectionBoolean.BooleanMode.STACKED);
        this.isApplicable = this.injectionMultibit.isInjectable();
        if (this.isApplicable) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} Multibit injection", () -> I18nUtil.valueByKey("LOG_VULNERABLE"));
            this.allow(new int[0]);
            Request requestMessageBinary = new Request();
            requestMessageBinary.setMessage(Interaction.MESSAGE_BINARY);
            requestMessageBinary.setParameters(this.injectionMultibit.getInfoMessage());
            this.injectionModel.sendToViews(requestMessageBinary);
        } else {
            this.unallow(new int[0]);
        }
    }

    @Override
    public void allow(int ... i) {
        this.markVulnerability(Interaction.MARK_MULTI_VULNERABLE, new int[0]);
    }

    @Override
    public void unallow(int ... i) {
        this.markVulnerability(Interaction.MARK_MULTI_INVULNERABLE, new int[0]);
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) throws StoppedByUserSlidingException {
        return this.injectionMultibit.inject(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBlind(sqlQuery, startPosition), stoppable);
    }

    @Override
    public void activateStrategy() {
        LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName);
        this.injectionModel.getMediatorStrategy().setStrategy(this.injectionModel.getMediatorStrategy().getMultibit());
        Request requestMarkBlindStrategy = new Request();
        requestMarkBlindStrategy.setMessage(Interaction.MARK_MULTI_STRATEGY);
        this.injectionModel.sendToViews(requestMarkBlindStrategy);
    }

    @Override
    public String getPerformanceLength() {
        return "65565";
    }

    @Override
    public String getName() {
        return "Multibit";
    }
}

