/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.vendor;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.injection.vendor.model.Vendor;
import com.jsql.model.injection.vendor.model.VendorYaml;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediatorVendor {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final String LOG_VENDOR = "{} [{}]";
    private Vendor vendor;
    private Vendor vendorByUser;
    private final Vendor auto;
    private final Vendor cubrid;
    private final Vendor db2;
    private final Vendor derby;
    private final Vendor h2;
    private final Vendor hsqldb;
    private final Vendor mySQL;
    private final Vendor neo4j;
    private final Vendor oracle;
    private final Vendor postgreSQL;
    private final Vendor sqlite;
    private final Vendor sqlServer;
    private final List<Vendor> vendors;
    private final InjectionModel injectionModel;

    public MediatorVendor(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        Vendor access = new Vendor(new VendorYaml("access.yml", injectionModel));
        Vendor altibase = new Vendor(new VendorYaml("altibase.yml", injectionModel));
        Vendor ctreeACE = new Vendor(new VendorYaml("ctreeace.yml", injectionModel));
        Vendor cockroachDB = new Vendor(new VendorYaml("cockroachdb.yml", injectionModel));
        Vendor exasol = new Vendor(new VendorYaml("exasol.yml", injectionModel));
        Vendor frontbase = new Vendor(new VendorYaml("frontbase.yml", injectionModel));
        Vendor firebird = new Vendor(new VendorYaml("firebird.yml", injectionModel));
        Vendor hana = new Vendor(new VendorYaml("hana.yml", injectionModel));
        Vendor informix = new Vendor(new VendorYaml("informix.yml", injectionModel));
        Vendor ingres = new Vendor(new VendorYaml("ingres.yml", injectionModel));
        Vendor iris = new Vendor(new VendorYaml("iris.yml", injectionModel));
        Vendor maxDB = new Vendor(new VendorYaml("maxdb.yml", injectionModel));
        Vendor mckoi = new Vendor(new VendorYaml("mckoi.yml", injectionModel));
        Vendor memSQL = new Vendor(new VendorYaml("memsql.yml", injectionModel));
        Vendor mimerSQL = new Vendor(new VendorYaml("mimersql.yml", injectionModel));
        Vendor monetDB = new Vendor(new VendorYaml("monetdb.yml", injectionModel));
        Vendor netezza = new Vendor(new VendorYaml("netezza.yml", injectionModel));
        Vendor nuoDB = new Vendor(new VendorYaml("nuodb.yml", injectionModel));
        Vendor presto = new Vendor(new VendorYaml("presto.yml", injectionModel));
        Vendor sybase = new Vendor(new VendorYaml("sybase.yml", injectionModel));
        Vendor teradata = new Vendor(new VendorYaml("teradata.yml", injectionModel));
        Vendor vertica = new Vendor(new VendorYaml("vertica.yml", injectionModel));
        this.auto = new Vendor();
        this.cubrid = new Vendor(new VendorYaml("cubrid.yml", injectionModel));
        this.db2 = new Vendor(new VendorYaml("db2.yml", injectionModel));
        this.derby = new Vendor(new VendorYaml("derby.yml", injectionModel));
        this.h2 = new Vendor(new VendorYaml("h2.yml", injectionModel));
        this.hsqldb = new Vendor(new VendorYaml("hsqldb.yml", injectionModel));
        this.mySQL = new Vendor(new VendorYaml("mysql.yml", injectionModel));
        this.neo4j = new Vendor(new VendorYaml("neo4j.yml", injectionModel));
        this.oracle = new Vendor(new VendorYaml("oracle.yml", injectionModel));
        this.postgreSQL = new Vendor(new VendorYaml("postgresql.yml", injectionModel));
        this.sqlite = new Vendor(new VendorYaml("sqlite.yml", injectionModel)){

            @Override
            public String transformSqlite(String resultToParse) {
                StringBuilder resultSqlite = new StringBuilder();
                String resultTmp = resultToParse.replaceFirst("[^(]+\\(", "").trim().replaceAll("\\)$", "");
                resultTmp = resultTmp.replaceAll("\\([^)]+\\)", "");
                for (String columnNameAndType : resultTmp.split(",")) {
                    if (columnNameAndType.trim().startsWith("primary key")) continue;
                    String columnName = columnNameAndType.trim().split("\\s")[0];
                    if ("CONSTRAINT".equals(columnName = StringUtils.strip(columnName, "`")) || "UNIQUE".equals(columnName)) continue;
                    resultSqlite.append('\u0004').append(columnName).append('\u0005').append("0").append('\u0004').append('\u0006');
                }
                return resultSqlite.toString();
            }
        };
        this.sqlServer = new Vendor(new VendorYaml("sqlserver.yml", injectionModel));
        this.vendors = Arrays.asList(this.auto, access, altibase, ctreeACE, cockroachDB, this.cubrid, this.db2, this.derby, exasol, firebird, frontbase, this.h2, hana, this.hsqldb, informix, ingres, iris, maxDB, mckoi, memSQL, mimerSQL, monetDB, this.mySQL, this.neo4j, netezza, nuoDB, this.oracle, this.postgreSQL, presto, this.sqlite, this.sqlServer, sybase, teradata, vertica);
        this.setVendor(this.mySQL);
        this.vendorByUser = this.auto;
    }

    public boolean isSqlite() {
        return this.getVendor() == this.getSqlite();
    }

    public Vendor fingerprintVendor() {
        Vendor vendorFound = null;
        if (this.injectionModel.getMediatorVendor().getVendorByUser() != this.injectionModel.getMediatorVendor().getAuto()) {
            vendorFound = this.injectionModel.getMediatorVendor().getVendorByUser();
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, LOG_VENDOR, () -> I18nUtil.valueByKey("LOG_DATABASE_TYPE_FORCED_BY_USER"), () -> this.injectionModel.getMediatorVendor().getVendorByUser());
        } else {
            Vendor[] vendorsWithoutAuto;
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Fingerprinting database...");
            String insertionCharacter = "'\"#-)'\"*";
            String pageSource = this.injectionModel.injectWithoutIndex(insertionCharacter, "test#vendor");
            MediatorVendor mediatorVendor = this.injectionModel.getMediatorVendor();
            for (Vendor vendorTest : vendorsWithoutAuto = (Vendor[])mediatorVendor.getVendors().stream().filter(v -> v != mediatorVendor.getAuto()).toArray(Vendor[]::new)) {
                if (!pageSource.matches("(?si)" + vendorTest.instance().fingerprintErrorsAsRegex())) continue;
                vendorFound = vendorTest;
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, LOG_VENDOR, () -> "Basic fingerprint matching vendor", () -> vendorTest);
                break;
            }
            vendorFound = this.initializeVendor(vendorFound);
        }
        Request requestSetVendor = new Request();
        requestSetVendor.setMessage(Interaction.SET_VENDOR);
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlByUser());
        msgHeader.put(Header.VENDOR, vendorFound);
        requestSetVendor.setParameters(msgHeader);
        this.injectionModel.sendToViews(requestSetVendor);
        return vendorFound;
    }

    public Vendor initializeVendor(Vendor vendor) {
        Vendor vendorFixed = vendor;
        if (vendorFixed == null) {
            vendorFixed = this.injectionModel.getMediatorVendor().getMySQL();
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, LOG_VENDOR, () -> I18nUtil.valueByKey("LOG_DATABASE_TYPE_NOT_FOUND"), () -> this.injectionModel.getMediatorVendor().getMySQL());
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, LOG_VENDOR, () -> I18nUtil.valueByKey("LOG_USING_DATABASE_TYPE"), () -> vendor);
            EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
            msgHeader.put(Header.URL, this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlByUser());
            msgHeader.put(Header.VENDOR, vendorFixed);
            Request requestDatabaseIdentified = new Request();
            requestDatabaseIdentified.setMessage(Interaction.DATABASE_IDENTIFIED);
            requestDatabaseIdentified.setParameters(msgHeader);
            this.injectionModel.sendToViews(requestDatabaseIdentified);
        }
        return vendorFixed;
    }

    public Vendor getAuto() {
        return this.auto;
    }

    public Vendor getCubrid() {
        return this.cubrid;
    }

    public Vendor getH2() {
        return this.h2;
    }

    public Vendor getPostgreSQL() {
        return this.postgreSQL;
    }

    public Vendor getMySQL() {
        return this.mySQL;
    }

    public Vendor getSqlite() {
        return this.sqlite;
    }

    public Vendor getSqlServer() {
        return this.sqlServer;
    }

    public Vendor getNeo4j() {
        return this.neo4j;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public Vendor getVendorByUser() {
        return this.vendorByUser;
    }

    public void setVendorByUser(Vendor vendorByUser) {
        this.vendorByUser = vendorByUser;
    }

    public List<Vendor> getVendors() {
        return this.vendors;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public Vendor getDb2() {
        return this.db2;
    }

    public Vendor getHsqldb() {
        return this.hsqldb;
    }

    public Vendor getDerby() {
        return this.derby;
    }

    public Vendor getOracle() {
        return this.oracle;
    }
}

