/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.model.suspendable.callable.ThreadFactoryCallable;
import com.jsql.util.LogLevelUtil;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ThreadUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final Map<AbstractElementDatabase, AbstractSuspendable> suspendables = new HashMap<AbstractElementDatabase, AbstractSuspendable>();
    private final InjectionModel injectionModel;

    public ThreadUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void put(AbstractElementDatabase elementDatabase, AbstractSuspendable suspendable) {
        this.suspendables.put(elementDatabase, suspendable);
    }

    public AbstractSuspendable get(AbstractElementDatabase elementDatabase) {
        return this.suspendables.get(elementDatabase);
    }

    public void remove(AbstractElementDatabase elementDatabase) {
        this.suspendables.remove(elementDatabase);
    }

    public void reset() {
        try {
            this.suspendables.values().forEach(AbstractSuspendable::stop);
            this.suspendables.clear();
        }
        catch (ConcurrentModificationException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public ExecutorService getExecutor(String nameThread) {
        ExecutorService taskExecutor;
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isLimitingThreads()) {
            int countThreads = this.injectionModel.getMediatorUtils().getPreferencesUtil().countLimitingThreads();
            taskExecutor = Executors.newFixedThreadPool(countThreads, new ThreadFactoryCallable(nameThread));
        } else {
            taskExecutor = Executors.newCachedThreadPool(new ThreadFactoryCallable(nameThread));
        }
        return taskExecutor;
    }

    public void shutdown(ExecutorService taskExecutor) {
        try {
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(0L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

