/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.combomenu;

import com.jsql.util.LogLevelUtil;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.plaf.basic.BasicArrowButton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArrowIcon
implements Icon,
SwingConstants {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final int DEFAULT_SIZE = 9;
    private final int size;
    private final int iconSize;
    private final int direction;
    private final boolean isEnabled;
    private final BasicArrowButton iconRenderer;

    public ArrowIcon(int direction, boolean isPressedView) {
        this(9, direction, isPressedView);
    }

    public ArrowIcon(int iconSize, int direction, boolean isEnabled) {
        this.size = iconSize / 2;
        this.iconSize = iconSize;
        this.direction = direction;
        this.isEnabled = isEnabled;
        this.iconRenderer = new BasicArrowButton(direction);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        try {
            this.iconRenderer.paintTriangle(g, x, y + 3, this.size, this.direction, this.isEnabled);
        }
        catch (ClassCastException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    @Override
    public int getIconWidth() {
        switch (this.direction) {
            case 1: 
            case 5: {
                return this.iconSize;
            }
        }
        return this.size;
    }

    @Override
    public int getIconHeight() {
        switch (this.direction) {
            case 1: 
            case 5: {
                return this.size;
            }
        }
        return this.iconSize;
    }
}

