/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.jsql.view.swing.action.ActionCloseTabResult;
import com.jsql.view.swing.tab.ButtonClose;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TabHeader
extends JPanel
implements MouseListener {
    private transient Cleanable cleanableTab;
    private final JLabel tabTitleLabel = new JLabel(){

        @Override
        public void setText(String text) {
            super.setText(text + " ");
        }
    };

    public TabHeader() {
        this(UiUtil.ICON_TABLE);
    }

    public TabHeader(Icon imageIcon) {
        super(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        this.getTabTitleLabel().setIcon(imageIcon);
        this.add(this.getTabTitleLabel());
        ButtonClose tabCloseButton = new ButtonClose();
        tabCloseButton.addMouseListener(this);
        this.add(tabCloseButton);
    }

    public TabHeader(String label, Icon imageIcon) {
        this(imageIcon);
        this.getTabTitleLabel().setText(label);
        this.tabTitleLabel.setName(label.trim());
    }

    public TabHeader(String label, Icon imageIcon, Cleanable cleanableTab) {
        this(imageIcon);
        this.getTabTitleLabel().setText(label);
        this.tabTitleLabel.setName(label.trim());
        this.cleanableTab = cleanableTab;
    }

    public TabHeader(String label) {
        this();
        this.getTabTitleLabel().setText(label);
        this.tabTitleLabel.setName(label.trim());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        int closeTabNumber = MediatorHelper.tabResults().indexOfTabComponent(this);
        if (this.getCleanableTab() != null) {
            this.getCleanableTab().clean();
        }
        ActionCloseTabResult.perform(closeTabNumber);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public JLabel getTabTitleLabel() {
        return this.tabTitleLabel;
    }

    public Cleanable getCleanableTab() {
        return this.cleanableTab;
    }

    public static interface Cleanable {
        public void clean();
    }
}

