/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree.model;

import com.jsql.model.bean.database.Table;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.view.swing.menubar.JMenuItemWithMargin;
import com.jsql.view.swing.text.JPopupTextField;
import com.jsql.view.swing.tree.CheckBoxMenuItemIconCustom;
import com.jsql.view.swing.tree.ImageObserverAnimated;
import com.jsql.view.swing.tree.ImageOverlap;
import com.jsql.view.swing.tree.PanelNode;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.tree.model.ActionCheckbox;
import com.jsql.view.swing.tree.model.JPopupMenuCustomExtract;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingWorker;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class NodeModelTable
extends AbstractNodeModel {
    public NodeModelTable(Table table) {
        super(table);
    }

    @Override
    protected Icon getLeafIcon(boolean leaf) {
        if (leaf) {
            return UiUtil.ICON_TABLE_GO;
        }
        return UiUtil.ICON_TABLE;
    }

    @Override
    protected void displayProgress(PanelNode panelNode, DefaultMutableTreeNode currentNode) {
        if ("information_schema".equals(this.getParent().toString())) {
            panelNode.showLoader();
            AbstractSuspendable suspendableTask = MediatorHelper.model().getMediatorUtils().getThreadUtil().get(this.getElementDatabase());
            if (suspendableTask != null && suspendableTask.isPaused()) {
                ImageOverlap animatedGifPaused = new ImageOverlap("swing/images/icons/progressBar.gif", "swing/images/icons/pause.png");
                animatedGifPaused.setImageObserver(new ImageObserverAnimated(MediatorHelper.treeDatabase(), currentNode));
                panelNode.setLoaderIcon(animatedGifPaused);
            }
        } else {
            super.displayProgress(panelNode, currentNode);
        }
    }

    @Override
    public void runAction() {
        if (this.isRunning()) {
            return;
        }
        DefaultMutableTreeNode treeNode = MediatorHelper.treeDatabase().getTreeNodeModels().get(this.getElementDatabase());
        treeNode.removeAllChildren();
        DefaultTreeModel treeModel = (DefaultTreeModel)MediatorHelper.treeDatabase().getModel();
        treeModel.reload(treeNode);
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Thread.currentThread().setName("SwingWorkerNodeModelTable");
                Table selectedTable = (Table)NodeModelTable.this.getElementDatabase();
                return MediatorHelper.model().getDataAccess().listColumns(selectedTable);
            }
        }.execute();
        this.setRunning(true);
    }

    @Override
    protected void buildMenu(JPopupMenuCustomExtract tablePopupMenu, TreePath path) {
        this.addCheckUncheckItems(tablePopupMenu, path);
    }

    private void addCustomLoadItems(JPopupMenuCustomExtract tablePopupMenu) {
        JMenu menuCustomLoad = new JMenu("Custom load");
        ButtonGroup buttonGroupLoadRows = new ButtonGroup();
        JRadioButtonMenuItem menuItemLoadAllRows = new JRadioButtonMenuItem("Load all rows (default)", true);
        JRadioButtonMenuItem menuItemLoadOneRow = new JRadioButtonMenuItem("Load first row only");
        JCheckBoxMenuItem menuItemDump = new JCheckBoxMenuItem("Dump to a file");
        JPanel panelCustomFromRow = new JPanel(new BorderLayout());
        JTextField inputCustomFromRow = (JTextField)new JPopupTextField("no.", "1").getProxy();
        inputCustomFromRow.setHorizontalAlignment(11);
        Dimension d = new Dimension((int)inputCustomFromRow.getPreferredSize().getWidth() + 50, (int)inputCustomFromRow.getPreferredSize().getHeight());
        inputCustomFromRow.setPreferredSize(d);
        JCheckBox radioCustomFromRow = new JCheckBox("<html><pre style=\"font-family:'Segoe UI';padding-left: 1px;\">Load from row no.&#9;</pre></html>");
        radioCustomFromRow.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        radioCustomFromRow.setIcon(new CheckBoxMenuItemIconCustom());
        radioCustomFromRow.setFocusPainted(false);
        panelCustomFromRow.add((Component)radioCustomFromRow, "Before");
        panelCustomFromRow.add((Component)inputCustomFromRow, "Center");
        JPanel panelCustomToRow = new JPanel(new BorderLayout());
        JTextField inputCustomToRow = (JTextField)new JPopupTextField("no.", "65565").getProxy();
        inputCustomToRow.setHorizontalAlignment(11);
        inputCustomToRow.setPreferredSize(d);
        JCheckBox radioCustomToRow = new JCheckBox("<html><pre style=\"font-family:'Segoe UI';padding-left: 1px;\">Load to row no.&#9;&#9;&#9;&#9;&#9;&#9;</pre></html>");
        radioCustomToRow.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        radioCustomToRow.setIcon(new CheckBoxMenuItemIconCustom());
        radioCustomToRow.setFocusPainted(false);
        panelCustomToRow.add((Component)radioCustomToRow, "Before");
        panelCustomToRow.add((Component)inputCustomToRow, "Center");
        JPanel panelCustomFromChar = new JPanel(new BorderLayout());
        JTextField inputCustomFromChar = (JTextField)new JPopupTextField("no.", "1").getProxy();
        inputCustomFromChar.setHorizontalAlignment(11);
        inputCustomFromChar.setPreferredSize(d);
        JCheckBox radioCustomFromChar = new JCheckBox("<html><pre style=\"font-family:'Segoe UI';padding-left: 1px;\">Load from char no.</pre></html>");
        radioCustomFromChar.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        radioCustomFromChar.setIcon(new CheckBoxMenuItemIconCustom());
        radioCustomFromChar.setFocusPainted(false);
        panelCustomFromChar.add((Component)radioCustomFromChar, "Before");
        panelCustomFromChar.add((Component)inputCustomFromChar, "Center");
        JPanel panelCustomToChar = new JPanel(new BorderLayout());
        JTextField inputCustomToChar = (JTextField)new JPopupTextField("no.", "65565").getProxy();
        inputCustomToChar.setHorizontalAlignment(11);
        inputCustomToChar.setPreferredSize(d);
        JCheckBox radioCustomToChar = new JCheckBox("<html><pre style=\"font-family:'Segoe UI';padding-left: 1px;\">Load to char no.&#9;&#9;&#9;&#9;&#9;</pre></html>");
        radioCustomToChar.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        radioCustomToChar.setIcon(new CheckBoxMenuItemIconCustom());
        radioCustomToChar.setFocusPainted(false);
        panelCustomToChar.add((Component)radioCustomToChar, "Before");
        panelCustomToChar.add((Component)inputCustomToChar, "Center");
        buttonGroupLoadRows.add(menuItemLoadAllRows);
        buttonGroupLoadRows.add(menuItemLoadOneRow);
        menuCustomLoad.add(menuItemLoadAllRows);
        menuCustomLoad.add(menuItemLoadOneRow);
        menuCustomLoad.add(new JSeparator());
        menuCustomLoad.add(panelCustomFromRow);
        menuCustomLoad.add(panelCustomToRow);
        menuCustomLoad.add(panelCustomFromChar);
        menuCustomLoad.add(panelCustomToChar);
        menuCustomLoad.add(new JSeparator());
        menuCustomLoad.add(menuItemDump);
        for (JMenuItem menuItem : new JMenuItem[]{menuItemLoadAllRows, menuItemLoadOneRow}) {
            menuItem.setUI(new BasicRadioButtonMenuItemUI(){

                @Override
                protected void doClick(MenuSelectionManager msm) {
                    this.menuItem.doClick(0);
                }
            });
        }
        menuItemDump.setUI(new BasicCheckBoxMenuItemUI(){

            @Override
            protected void doClick(MenuSelectionManager msm) {
                this.menuItem.doClick(0);
            }
        });
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(menuCustomLoad);
        tablePopupMenu.setButtonGroupLoadRows(buttonGroupLoadRows);
        tablePopupMenu.setRadioCustomFromChar(radioCustomFromChar);
        tablePopupMenu.setRadioCustomToChar(radioCustomToChar);
        tablePopupMenu.setRadioCustomFromRow(radioCustomFromRow);
        tablePopupMenu.setRadioCustomToRow(radioCustomToRow);
    }

    private void addCheckUncheckItems(JPopupMenuCustomExtract tablePopupMenu, TreePath path) {
        JMenuItemWithMargin menuItemCheckAll = new JMenuItemWithMargin(I18nViewUtil.valueByKey("COLUMNS_CHECK_ALL"), 'C');
        I18nViewUtil.addComponentForKey("COLUMNS_CHECK_ALL", menuItemCheckAll);
        JMenuItemWithMargin menuItemUncheckAll = new JMenuItemWithMargin(I18nViewUtil.valueByKey("COLUMNS_UNCHECK_ALL"), 'U');
        I18nViewUtil.addComponentForKey("COLUMNS_UNCHECK_ALL", menuItemUncheckAll);
        if (!this.isLoaded()) {
            menuItemCheckAll.setEnabled(false);
            menuItemUncheckAll.setEnabled(false);
        }
        menuItemCheckAll.addActionListener(new ActionCheckbox(true, path));
        menuItemUncheckAll.addActionListener(new ActionCheckbox(false, path));
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(menuItemCheckAll);
        tablePopupMenu.add(menuItemUncheckAll);
    }

    @Override
    public boolean isPopupDisplayable() {
        return this.isLoaded() || !this.isLoaded() && this.isRunning();
    }
}

