/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.ObjectUtils;

public class TransformSet
implements Comparable<TransformSet> {
    public static final String PROP_TRANSFORMS = "transforms";
    private final String _name;
    private String _description;
    private Set<String> _transforms;
    private PropertyChangeSupport _listeners;
    private boolean _dirty = true;

    public TransformSet(String name) {
        this._name = StringUtilities.trim((String)name);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markClean() {
        this._dirty = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this._listeners == null) {
            this._listeners = new PropertyChangeSupport(this);
        }
        this._listeners.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this._listeners != null) {
            this._listeners.removePropertyChangeListener(pcl);
        }
    }

    protected void firePropertyChange(String prop, Object old, Object nue) {
        if (this._listeners != null) {
            this._listeners.firePropertyChange(prop, old, nue);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean addTransform(String name) {
        if (this.transforms().add(name)) {
            this._dirty = true;
            this.firePropertyChange(PROP_TRANSFORMS, null, null);
            return true;
        }
        return false;
    }

    public boolean addAllTransforms(Collection<String> names) {
        if (this.transforms().addAll(names)) {
            this._dirty = true;
            this.firePropertyChange(PROP_TRANSFORMS, null, null);
            return true;
        }
        return false;
    }

    public boolean removeTransform(String name) {
        if (this.transforms().remove(name)) {
            this._dirty = true;
            this.firePropertyChange(PROP_TRANSFORMS, null, null);
            return true;
        }
        return false;
    }

    private Set<String> transforms() {
        if (this._transforms == null) {
            this._transforms = new TreeSet<String>();
        }
        return this._transforms;
    }

    public boolean contains(String transform) {
        if (this._transforms == null) {
            return false;
        }
        return this._transforms.contains(transform);
    }

    public Set<String> getAllTransforms() {
        return Collections.unmodifiableSet(this.transforms());
    }

    public boolean isAutoGenerated() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setDescription(String description) {
        if (this._description == null || !this._description.equals(description)) {
            this._description = description;
            this._dirty = true;
        }
    }

    public Set<TransformDefinition> getIntersection(Collection<TransformDefinition> transforms) {
        if (transforms.isEmpty() || this._transforms == null || this._transforms.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> t = this.transforms();
        TreeSet<TransformDefinition> intersection = new TreeSet<TransformDefinition>();
        for (TransformDefinition td : transforms) {
            if (!t.contains(td.getName())) continue;
            intersection.add(td);
        }
        return intersection;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransformSet) {
            return this.equals((TransformSet)obj);
        }
        return false;
    }

    public boolean equals(TransformSet set) {
        if (set == null) {
            return false;
        }
        return set.getName().equals(this.getName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(TransformSet o) {
        if (o == null) {
            return 1;
        }
        return ObjectUtils.compare((Comparable)((Object)this._name), (Comparable)((Object)o._name));
    }
}

