/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour;

import com.maltego.guided.tour.GuidedTour;
import com.maltego.guided.tour.GuidedTourPreferences;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.RequestProcessor;

public class GuidedTourRunner
implements Runnable {
    private static final Logger LOG = Logger.getLogger(GuidedTourRunner.class.getName());

    @Override
    public void run() {
        GuidedTourPreferences prefs = GuidedTourPreferences.getInstance();
        LOG.log(Level.FINE, "Guided tour - firstRunDone : {0}", prefs.isFirstRunDone());
        LOG.log(Level.FINE, "Guided tour - remindLater : {0}", prefs.isRemindLater());
        if (!prefs.isFirstRunDone() || prefs.isRemindLater()) {
            this.startTour();
        }
    }

    private void startTour() {
        if (UIRunQueue.instance().isAllAsyncCompleted() && !LicenseManager.A().A(false).D()) {
            LOG.log(Level.FINE, "UIRunQueue async tasks completed, starting tour");
            SwingUtilities.invokeLater(() -> new GuidedTour().start());
            GuidedTourPreferences prefs = GuidedTourPreferences.getInstance();
            prefs.setFirstRunDone(true);
            prefs.setRemindLater(false);
        } else {
            LOG.log(Level.FINE, "UIRunQueue async tasks still running, will wait 1 sec for it to complete");
            RequestProcessor.getDefault().post(() -> this.startTour(), 1000);
        }
    }
}

