/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.GuidedTourPreferences;
import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.TitlePanel;
import com.maltego.guided.tour.ui.TourDialog;
import com.maltego.guided.tour.ui.TourDialogPresenter;
import com.maltego.guided.tour.ui.TutorialDefaults;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.welcome.GotoUserGuideAction;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StartTourDialog
extends TourDialog {
    private TourStep tourStep = TourStep.DEFAULT;
    private JButton remindButton;
    private JButton startButton;
    private TitlePanel titlePanel;

    public StartTourDialog(Frame frame) {
        super(frame);
        this.setMinimumSize(new Dimension(360, 0));
        this.initComponents();
        this.adjustLocation();
        this.getContentPane().setBackground(TutorialDefaults.COLOR_START_BACKGROUND);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "start");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), "start");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(39, 0), "start");
        this.getRootPane().getActionMap().put("start", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartTourDialog.this.startButton.doClick();
            }
        });
    }

    @Override
    protected Point getRelativeLocation() {
        Rectangle parentBounds = this.getParentFrame().getBounds();
        return new Point(parentBounds.width - this.getWidth(), 58);
    }

    @Override
    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
        this.titlePanel.setTourStep(tourStep);
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        JLabel imageLabel = new JLabel();
        JTextArea contentTextArea = new JTextArea();
        this.startButton = new JButton();
        this.remindButton = new JButton();
        JLabel readUserGuidesLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.titlePanel.setTitle(NbBundle.getMessage(StartTourDialog.class, (String)"StartTourDialog.titlePanel.title"));
        imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/guided/tour/ui/img_start-tour.png")));
        contentTextArea.setEditable(false);
        contentTextArea.setColumns(20);
        contentTextArea.setFont(contentTextArea.getFont().deriveFont((float)contentTextArea.getFont().getSize() + 3.0f));
        contentTextArea.setLineWrap(true);
        contentTextArea.setRows(3);
        contentTextArea.setText(NbBundle.getMessage(StartTourDialog.class, (String)"StartTourDialog.contentTextArea.text"));
        contentTextArea.setWrapStyleWord(true);
        contentTextArea.setBorder(null);
        contentTextArea.setDisabledTextColor(TutorialDefaults.COLOR_TEXT);
        contentTextArea.setEnabled(false);
        contentTextArea.setOpaque(false);
        this.startButton.setBackground(UIManager.getLookAndFeelDefaults().getColor("Button.background").darker().darker());
        this.startButton.setFont(this.startButton.getFont().deriveFont((float)this.startButton.getFont().getSize() + 3.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.startButton, (String)NbBundle.getMessage(StartTourDialog.class, (String)"StartTourDialog.startButton.text"));
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartTourDialog.this.startButtonActionPerformed(evt);
            }
        });
        this.remindButton.setFont(this.remindButton.getFont().deriveFont((float)this.remindButton.getFont().getSize() + 3.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.remindButton, (String)NbBundle.getMessage(StartTourDialog.class, (String)"StartTourDialog.remindButton.text"));
        this.remindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartTourDialog.this.remindButtonActionPerformed(evt);
            }
        });
        readUserGuidesLabel.setFont(readUserGuidesLabel.getFont().deriveFont((float)readUserGuidesLabel.getFont().getSize() + 3.0f));
        readUserGuidesLabel.setForeground(TutorialDefaults.COLOR_TEXT);
        Mnemonics.setLocalizedText((JLabel)readUserGuidesLabel, (String)NbBundle.getMessage(StartTourDialog.class, (String)"StartTourDialog.readUserGuidesLabel.text"));
        readUserGuidesLabel.setCursor(new Cursor(12));
        readUserGuidesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StartTourDialog.this.readUserGuidesLabelMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.remindButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startButton)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(contentTextArea, GroupLayout.Alignment.TRAILING).addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(readUserGuidesLabel, -2, -1, -2).addComponent(imageLabel)).addGap(0, 0, Short.MAX_VALUE))))).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(imageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(contentTextArea, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(readUserGuidesLabel, -2, 26, -2).addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startButton).addComponent(this.remindButton)).addGap(15, 15, 15)));
        this.pack();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        GuidedTourPreferences.getInstance().setRemindLater(false);
        WindowUtil.selectRibbonTab((String)"Investigate");
        this.tourStep.next();
    }

    private void remindButtonActionPerformed(ActionEvent evt) {
        GuidedTourPreferences.getInstance().setRemindLater(true);
        this.tourStep.closeTour();
    }

    private void readUserGuidesLabelMouseClicked(MouseEvent evt) {
        new GotoUserGuideAction().actionPerformed(null);
    }

    public static class Presenter
    extends TourDialogPresenter<StartTourDialog> {
        @Override
        protected StartTourDialog createTourDialog(Frame frame) {
            return new StartTourDialog(frame);
        }
    }
}

