/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.host.GuestToHostCodeCache;
import com.oracle.truffle.host.HostAccessor;
import com.oracle.truffle.host.HostAdapterFactory;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostException;
import com.oracle.truffle.host.HostFunction;
import com.oracle.truffle.host.HostLanguage;
import com.oracle.truffle.host.HostMethodDesc;
import com.oracle.truffle.host.HostMethodScope;
import com.oracle.truffle.host.HostObject;
import com.oracle.truffle.host.HostProxy;
import com.oracle.truffle.host.HostToTypeNode;
import com.oracle.truffle.host.HostToTypeNodeGen;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.proxy.Proxy;

public class HostLanguageService
extends AbstractPolyglotImpl.AbstractHostService {
    final HostLanguage language;

    HostLanguageService(AbstractPolyglotImpl polyglot, HostLanguage language) {
        super(polyglot);
        this.language = language;
    }

    public void initializeHostContext(Object internalContext, Object receiver, HostAccess hostAccess, ClassLoader cl, Predicate<String> clFilter, boolean hostCLAllowed, boolean hostLookupAllowed) {
        HostContext context = (HostContext)receiver;
        ClassLoader useCl = cl;
        if (useCl == null) {
            useCl = TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader();
        }
        this.language.initializeHostAccess(hostAccess, useCl);
        context.initialize(internalContext, useCl, clFilter, hostCLAllowed, hostLookupAllowed);
    }

    public void addToHostClassPath(Object receiver, Object truffleFile) {
        HostContext context = (HostContext)receiver;
        context.addToHostClasspath((TruffleFile)truffleFile);
    }

    public Object findDynamicClass(Object receiver, String classValue) {
        HostContext context = (HostContext)receiver;
        Class<?> found = context.findClass(classValue);
        if (found == null) {
            return null;
        }
        return HostObject.forClass(found, context);
    }

    public Object findStaticClass(Object receiver, String classValue) {
        HostContext context = (HostContext)receiver;
        Class<?> found = context.findClass(classValue);
        if (found == null) {
            return null;
        }
        return HostObject.forStaticClass(found, context);
    }

    public Object createToHostTypeNode() {
        return HostToTypeNodeGen.create();
    }

    public <T> T toHostType(Object hostNode, Object hostContext, Object value, Class<T> targetType, Type genericType) {
        HostContext context = (HostContext)hostContext;
        HostToTypeNode node = (HostToTypeNode)hostNode;
        if (node == null) {
            node = HostToTypeNodeGen.getUncached();
        }
        return (T)node.execute(context, value, targetType, genericType, true);
    }

    public Object asHostStaticClass(Object context, Class<?> value) {
        return HostObject.forStaticClass(value, (HostContext)context);
    }

    public Object toGuestValue(Object hostContext, Object hostValue, boolean asValue) {
        HostContext context = (HostContext)hostContext;
        assert (this.validHostValue(hostValue, context)) : "polyglot unboxing should be a no-op at this point.";
        if (HostContext.isGuestPrimitive(hostValue)) {
            return hostValue;
        }
        if (hostValue instanceof Proxy) {
            return HostProxy.toProxyGuestObject(context, (Proxy)hostValue);
        }
        if (!asValue && hostValue instanceof HostMethodScope.ScopedObject) {
            return ((HostMethodScope.ScopedObject)hostValue).unwrapForGuest();
        }
        if (hostValue instanceof TruffleObject) {
            return hostValue;
        }
        if (hostValue instanceof Class) {
            return HostObject.forClass((Class)hostValue, context);
        }
        if (hostValue == null) {
            return HostObject.NULL;
        }
        return HostObject.forObject(hostValue, context);
    }

    private boolean validHostValue(Object hostValue, HostContext context) {
        Object unboxed = this.language.access.toGuestValue(context.internalContext, hostValue);
        return unboxed == hostValue;
    }

    public boolean isHostValue(Object value) {
        Object obj = HostLanguage.unwrapIfScoped(this.language, value);
        return obj instanceof HostObject || obj instanceof HostFunction || obj instanceof HostException || obj instanceof HostProxy;
    }

    public Object unboxHostObject(Object hostValue) {
        return HostObject.valueOf(this.language, hostValue);
    }

    public Object unboxProxyObject(Object hostValue) {
        return HostProxy.toProxyHostObject(this.language, hostValue);
    }

    public Throwable unboxHostException(Throwable hostValue) {
        if (hostValue instanceof HostException) {
            return ((HostException)hostValue).getOriginal();
        }
        return null;
    }

    public Object toHostObject(Object hostContext, Object value) {
        HostContext context = (HostContext)hostContext;
        return HostObject.forObject(value, context);
    }

    public Object asHostDynamicClass(Object context, Class<?> value) {
        return null;
    }

    public boolean isHostException(Throwable exception) {
        return exception instanceof HostException;
    }

    public boolean isHostFunction(Object value) {
        return HostFunction.isInstance(this.language, value);
    }

    public boolean isHostObject(Object value) {
        return HostObject.isInstance(this.language, value);
    }

    public boolean isHostProxy(Object value) {
        return HostProxy.isProxyGuestObject(this.language, value);
    }

    public boolean isHostSymbol(Object obj) {
        Object o = HostLanguage.unwrapIfScoped(this.language, obj);
        if (o instanceof HostObject) {
            return ((HostObject)o).isStaticClass();
        }
        return false;
    }

    public Object createHostAdapter(Object context, Class<?>[] types, Object classOverrides) {
        HostContext hostContext = (HostContext)context;
        HostAdapterFactory.AdapterResult adapter = HostAdapterFactory.getAdapterClassFor(hostContext, types, classOverrides);
        if (!adapter.isSuccess()) {
            throw adapter.throwException();
        }
        return HostObject.forStaticClass(adapter.getAdapterClass(), hostContext);
    }

    public RuntimeException toHostException(Object context, Throwable exception) {
        HostContext hostContext = (HostContext)context;
        return new HostException(exception, hostContext);
    }

    public Object migrateValue(Object targetContext, Object value, Object valueContext) {
        assert (targetContext != valueContext);
        if (value instanceof TruffleObject) {
            assert (value instanceof TruffleObject);
            if (HostObject.isInstance(this.language, value)) {
                return HostObject.withContext(this.language, value, (HostContext)HostAccessor.ENGINE.getHostContext(targetContext));
            }
            if (value instanceof HostProxy) {
                return HostProxy.withContext(value, (HostContext)HostAccessor.ENGINE.getHostContext(targetContext));
            }
            if (valueContext == null) {
                assert (value instanceof TruffleObject);
                return value;
            }
            return null;
        }
        assert (InteropLibrary.isValidValue(value));
        return value;
    }

    public Error toHostResourceError(Throwable hostException) {
        Throwable t = this.unboxHostException(hostException);
        if (t instanceof StackOverflowError || t instanceof OutOfMemoryError) {
            return (Error)t;
        }
        return null;
    }

    public int findNextGuestToHostStackTraceElement(StackTraceElement firstElement, StackTraceElement[] hostStack, int nextElementIndex) {
        StackTraceElement element = firstElement;
        int index = nextElementIndex;
        while (HostLanguageService.isGuestToHostReflectiveCall(element) && index < hostStack.length) {
            element = hostStack[index++];
        }
        if (HostLanguageService.isGuestToHostCallFromHostInterop(element)) {
            return index - nextElementIndex;
        }
        return -1;
    }

    public void pin(Object receiver) {
        HostMethodScope.pin(receiver);
    }

    private static boolean isGuestToHostCallFromHostInterop(StackTraceElement element) {
        assert (HostLanguageService.assertClassNameUnchanged(HostObject.GuestToHostCalls.class, "com.oracle.truffle.host.HostObject$GuestToHostCalls"));
        assert (HostLanguageService.assertClassNameUnchanged(GuestToHostCodeCache.class, "com.oracle.truffle.host.GuestToHostCodeCache"));
        assert (HostLanguageService.assertClassNameUnchanged(HostMethodDesc.SingleMethod.class, "com.oracle.truffle.host.HostMethodDesc$SingleMethod"));
        switch (element.getClassName()) {
            case "com.oracle.truffle.host.HostMethodDesc$SingleMethod$MHBase": {
                return element.getMethodName().equals("invokeHandle");
            }
            case "com.oracle.truffle.host.HostMethodDesc$SingleMethod$MethodReflectImpl": {
                return element.getMethodName().equals("reflectInvoke");
            }
            case "com.oracle.truffle.host.HostObject$GuestToHostCalls": {
                return true;
            }
        }
        return element.getClassName().startsWith("com.oracle.truffle.host.GuestToHostCodeCache$") && element.getMethodName().equals("executeImpl");
    }

    private static boolean assertClassNameUnchanged(Class<?> c, String name) {
        if (c.getName().equals(name)) {
            return true;
        }
        throw new AssertionError((Object)("Class name is outdated. Expected " + name + " but got " + c.getName()));
    }

    private static boolean isGuestToHostReflectiveCall(StackTraceElement element) {
        switch (element.getClassName()) {
            case "sun.reflect.NativeMethodAccessorImpl": 
            case "sun.reflect.DelegatingMethodAccessorImpl": 
            case "jdk.internal.reflect.NativeMethodAccessorImpl": 
            case "jdk.internal.reflect.DelegatingMethodAccessorImpl": 
            case "java.lang.reflect.Method": {
                return element.getMethodName().startsWith("invoke");
            }
        }
        return false;
    }
}

