/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.collections;

import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapUtils {
    public static <T, U> List<U> getOrCreateList(Map<T, List<U>> map, T key) {
        Args.notNull(map, "map");
        Args.notNull(key, "key");
        List<U> items = map.get(key);
        if (items == null) {
            items = new ArrayList<U>();
            map.put(key, items);
        }
        return items;
    }

    public static <T, U> void addToList(Map<T, List<U>> map, T key, U value) {
        Args.notNull(map, "map");
        Args.notNull(key, "key");
        Args.notNull(value, "value");
        List<U> items = MapUtils.getOrCreateList(map, key);
        items.add(value);
    }

    public static <T, U> void addToList(Map<T, List<U>> map, T key, List<U> values) {
        Args.notNull(map, "map");
        Args.notNull(key, "key");
        Args.notNull(values, "values");
        if (!values.isEmpty()) {
            List<U> items = MapUtils.getOrCreateList(map, key);
            items.addAll(values);
        }
    }
}

