/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.Collection;
import java.util.Map;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class NotEmptyValidator
implements SimpleValidator {
    public static final NotEmptyValidator INSTANCE = new NotEmptyValidator();
    public static final String ID = "not-empty";
    public static final String MESSAGE_ERROR_EMPTY = "error-empty";

    public String getId() {
        return ID;
    }

    @Override
    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (input == null) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_ERROR_EMPTY, input));
            return context;
        }
        if (input instanceof String) {
            if (((String)input).length() == 0) {
                context.addError(new ValidationError(ID, inputHint, MESSAGE_ERROR_EMPTY, input));
            }
            return context;
        }
        if (input instanceof Collection) {
            if (((Collection)input).isEmpty()) {
                context.addError(new ValidationError(ID, inputHint, MESSAGE_ERROR_EMPTY, input));
            }
            return context;
        }
        if (input instanceof Map) {
            if (((Map)input).isEmpty()) {
                context.addError(new ValidationError(ID, inputHint, MESSAGE_ERROR_EMPTY, input));
            }
            return context;
        }
        context.addError(new ValidationError(ID, inputHint, "error-invalid-value", input));
        return context;
    }
}

