/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.java.JavaPackageObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JavaPackage
extends JSNonProxy {
    public static final String TYPE_NAME = "object";
    public static final String CLASS_NAME = "JavaPackage";
    public static final JavaPackage INSTANCE = new JavaPackage();

    private JavaPackage() {
    }

    public static DynamicObject create(JSContext context, JSRealm realm, String packageName) {
        JavaPackageObject obj = JavaPackage.createInstance(context, realm, packageName);
        return context.trackAllocation(obj);
    }

    public static DynamicObject createInit(JSRealm realm, String packageName) {
        CompilerAsserts.neverPartOfCompilation();
        JSContext context = realm.getContext();
        return JavaPackage.createInstance(context, realm, packageName);
    }

    private static JavaPackageObject createInstance(JSContext context, JSRealm realm, String packageName) {
        JSObjectFactory factory = context.getJavaPackageFactory();
        JavaPackageObject obj = new JavaPackageObject(factory.getShape(realm), packageName);
        factory.initProto(obj, realm);
        JSObjectUtil.putDataProperty(context, obj, Symbol.SYMBOL_TO_PRIMITIVE, realm.getJavaPackageToPrimitiveFunction(), JSAttributes.notConfigurableNotEnumerableNotWritable());
        assert (JavaPackage.isJavaPackage((Object)obj));
        return obj;
    }

    public static boolean isJavaPackage(Object obj) {
        return obj instanceof JavaPackageObject;
    }

    public static String getPackageName(DynamicObject obj) {
        assert (JavaPackage.isJavaPackage(obj));
        return ((JavaPackageObject)obj).getPackageName();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> T getClass(JSRealm realm, DynamicObject thisObj, String className, Class<? extends T> returnType) {
        Object clazz;
        Object javaType;
        TruffleLanguage.Env env = realm.getEnv();
        assert (env.isHostLookupAllowed());
        String qualifiedName = JavaPackage.prependPackageName(thisObj, className);
        try {
            javaType = env.lookupHostSymbol(qualifiedName);
        }
        catch (Exception e) {
            return null;
        }
        if (javaType == null) {
            return null;
        }
        if (env.isHostObject(javaType) && (clazz = env.asHostObject(javaType)) instanceof Class) {
            if (returnType == Class.class) {
                return returnType.cast(clazz);
            }
            return returnType.cast(javaType);
        }
        return null;
    }

    public static DynamicObject subpackage(JSContext context, JSRealm realm, DynamicObject thisObj, String name) {
        return JavaPackage.create(context, realm, JavaPackage.prependPackageName(thisObj, name));
    }

    public static Object getJavaClassOrConstructorOrSubPackage(JSContext context, DynamicObject thisObj, String name) {
        int openParen;
        JSRealm realm = JSRealm.get(null);
        if (context.isOptionNashornCompatibilityMode() && Boundaries.stringEndsWith(name, ")") && (openParen = name.indexOf(40)) != -1) {
            String className = Boundaries.substring(name, 0, openParen);
            Object javaClass = JavaPackage.getClass(realm, thisObj, className, Object.class);
            if (javaClass != null) {
                return javaClass;
            }
            throw Errors.createTypeErrorFormat("No such Java class: %s", JavaPackage.prependPackageName(thisObj, className));
        }
        return JavaPackage.getJavaClassOrSubPackage(context, realm, thisObj, name);
    }

    private static Object getJavaClassOrSubPackage(JSContext context, JSRealm realm, DynamicObject thisObj, String name) {
        Object javaClass = JavaPackage.getClass(realm, thisObj, name, Object.class);
        if (javaClass != null) {
            return javaClass;
        }
        return JavaPackage.subpackage(context, realm, thisObj, name);
    }

    @CompilerDirectives.TruffleBoundary
    private static String prependPackageName(DynamicObject thisObj, String className) {
        String packageName = JavaPackage.getPackageName(thisObj);
        return !packageName.isEmpty() ? packageName + "." + className : className;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toPrimitiveString(DynamicObject obj) {
        return "[JavaPackage " + JavaPackage.getPackageName(obj) + "]";
    }

    public static DynamicObject createToPrimitiveFunction(JSContext context, JSRealm realm) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.JavaPackageToPrimitive, JavaPackage::createToPrimitiveFunctionImpl);
        return JSFunction.create(realm, functionData);
    }

    private static JSFunctionData createToPrimitiveFunctionImpl(JSContext context) {
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                Object hint;
                Object[] arguments = frame.getArguments();
                Object obj = JSArguments.getThisObject(arguments);
                Object object = hint = JSArguments.getUserArgumentCount(arguments) > 0 ? JSArguments.getUserArgument(arguments, 0) : null;
                if (!JSRuntime.isObject(obj)) {
                    throw Errors.createTypeError("cannot call JavaPackage[@@toPrimitive] with non-object argument");
                }
                if ("string".equals(hint)) {
                    return JavaPackage.toPrimitiveString((DynamicObject)obj);
                }
                if ("default".equals(hint) || "number".equals(hint)) {
                    return JSObject.ordinaryToPrimitive((DynamicObject)obj, "number");
                }
                throw Errors.createTypeError("invalid hint");
            }
        });
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "[Symbol.toPrimitive]");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getHelper(DynamicObject store, Object thisObj, Object name, Node encapsulatingNode) {
        Object propertyValue = super.getHelper(store, thisObj, name, encapsulatingNode);
        if (propertyValue != null) {
            return propertyValue;
        }
        if (name instanceof String) {
            return JavaPackage.getJavaClassOrConstructorOrSubPackage(JSObject.getJSContext(store), store, (String)name);
        }
        return null;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject objectPrototype) {
        return JSObjectUtil.getProtoChildShape(objectPrototype, INSTANCE, context);
    }
}

