/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.ctxmenu;

import com.paterva.maltego.util.ui.treelist.TreeListItem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;

public abstract class ProxyTreeListItem
implements TreeListItem,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(ProxyTreeListItem.class.getName());
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final TreeListItem _delegate;
    private boolean _visible = false;

    public ProxyTreeListItem(TreeListItem delegate) {
        LOG.log(Level.FINE, "Created proxy {0} for {1}", new Object[]{this, delegate});
        this._delegate = delegate;
    }

    @Override
    public void addNotify() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "addNotify {0} {1}", new Object[]{this, this.getName()});
        }
        if (!this._visible) {
            this._delegate.addPropertyChangeListener(this);
            this._visible = true;
        }
    }

    @Override
    public void removeNotify() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "removeNotify {0} {1}", new Object[]{this, this.getName()});
        }
        if (this._visible) {
            this._delegate.removePropertyChangeListener(this);
            this._visible = false;
        }
    }

    public TreeListItem getDelegate() {
        return this._delegate;
    }

    @Override
    public String getName() {
        return this._delegate.getName();
    }

    @Override
    public String getDisplayName() {
        return this._delegate.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this._delegate.getDescription();
    }

    @Override
    public int getDepth() {
        return this._delegate.getDepth();
    }

    @Override
    public void setExpanded(boolean expanded) {
        this._delegate.setExpanded(expanded);
    }

    @Override
    public boolean isExpanded() {
        return this._delegate.isExpanded();
    }

    @Override
    public void setSelected(boolean selected) {
        this._delegate.setSelected(selected);
    }

    @Override
    public boolean isSelected() {
        return this._delegate.isSelected();
    }

    @Override
    public Icon getIcon() {
        return this._delegate.getIcon();
    }

    @Override
    public String getLafPrefix() {
        return this._delegate.getLafPrefix();
    }

    @Override
    public TreeListItem getParent() {
        return this._delegate.getParent();
    }

    @Override
    public boolean isVisible() {
        return this._delegate.isVisible();
    }

    @Override
    public void addChild(TreeListItem item, int index) {
        this._delegate.addChild(item, index);
    }

    @Override
    public void removeChild(TreeListItem item) {
        this._delegate.removeChild(item);
    }

    @Override
    public List<TreeListItem> getChildren() {
        return this._delegate.getChildren();
    }

    @Override
    public List<TreeListItem> getAsList() {
        return this._delegate.getAsList();
    }

    @Override
    public Action getDefaultAction() {
        return this._delegate.getDefaultAction();
    }

    @Override
    public List<Action> getContextActions() {
        return this._delegate.getContextActions();
    }

    @Override
    public List<Action> getToolbarActions() {
        return this._delegate.getToolbarActions();
    }

    @Override
    public boolean isRemeberPage() {
        return this._delegate.isRemeberPage();
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this._changeSupport.firePropertyChange(event);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this._changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "add listener this={0} {1} listener={2} count={3}", new Object[]{this, this.getName(), listener, this._changeSupport.getPropertyChangeListeners().length});
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "remove listener this={0} {1} listener={2} count={3}", new Object[]{this, this.getName(), listener, this._changeSupport.getPropertyChangeListeners().length});
        }
    }

    public int hashCode() {
        return this._delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this._delegate.equals(obj);
    }
}

