/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.windows.WindowManager;

public class UIRunQueue {
    private static final Logger LOG = Logger.getLogger(UIRunQueue.class.getName());
    private static UIRunQueue INSTANCE;
    private final List<Runner> list = new ArrayList<Runner>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Map<String, Boolean> asyncStatusMap = new HashMap<String, Boolean>();

    public static synchronized UIRunQueue instance() {
        if (INSTANCE == null) {
            INSTANCE = new UIRunQueue();
        }
        return INSTANCE;
    }

    public void registerAsyncTask(String taskName) {
        this.asyncStatusMap.put(taskName, Boolean.FALSE);
    }

    public void setAsyncTaskCompleted(String taskName) {
        this.asyncStatusMap.put(taskName, Boolean.TRUE);
    }

    public boolean isAllAsyncCompleted() {
        boolean allCompleted = true;
        for (Boolean value : this.asyncStatusMap.values()) {
            allCompleted = allCompleted && value != false;
        }
        return allCompleted;
    }

    public synchronized void queue(int priority, String name, Runnable runnable) {
        Runner runner = new Runner();
        runner.runnable = runnable;
        runner.priority = priority;
        runner.name = name;
        this.list.add(runner);
        LOG.log(Level.FINE, "Queue (priority {0}, name {1})(size {2}): {3}", new Object[]{priority, name, this.list.size(), runnable});
        this.schedule();
    }

    private void schedule() {
        if (this.running.compareAndSet(false, true)) {
            Runner runner = this.popNext();
            if (runner == null) {
                this.running.set(false);
            } else {
                WindowManager.getDefault().invokeWhenUIReady(() -> {
                    LOG.log(Level.FINE, "Start: {0}, {1}", new Object[]{runner.name, runner.runnable});
                    runner.runnable.run();
                    LOG.log(Level.FINE, "End: {0}, {1}", new Object[]{runner.name, runner.runnable});
                    this.running.set(false);
                    this.schedule();
                });
            }
        }
    }

    private synchronized Runner popNext() {
        Runner next = null;
        for (Runner runner : this.list) {
            if (next == null) {
                next = runner;
                continue;
            }
            if (next.priority <= runner.priority) continue;
            next = runner;
        }
        if (next != null) {
            this.list.remove(next);
        }
        return next;
    }

    private static class Runner {
        public Runnable runnable;
        public int priority;
        public String name;

        private Runner() {
        }
    }
}

