/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.search;

import com.bulenkov.darcula.ui.DarculaTextFieldUICallback;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SearchPanel
extends JPanel {
    private final DarculaTextFieldUICallback fieldCallBack = new DarculaTextFieldUICallbackImpl();
    private final int delay = 750;
    private final JComponent filteringObject;
    private final TextQuickFilter filter;
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            char keyChar = e.getKeyChar();
            if (!(e.isControlDown() || e.isConsumed() || keyChar == '\u001b' || keyChar == '\u007f' || SearchPanel.this.searchTextField.hasFocus())) {
                SearchPanel.this.searchTextField.requestFocus();
                if (!e.isActionKey()) {
                    SearchPanel.this.searchTextField.setText(SearchPanel.this.filterCharacter(keyChar));
                }
            }
            SearchPanel.this.checkEscPressed(keyChar);
        }
    };
    private JTextField searchTextField;

    public SearchPanel(JComponent filteringObject, TextQuickFilter filter) {
        this.filteringObject = filteringObject;
        this.filter = filter;
        this.initComponents();
        this.searchTextField.putClientProperty("JTextField.variant", "search");
        this.searchTextField.putClientProperty("JTextField.Search.SearchType", "progressiveTimer");
        this.fieldCallBack.setFilterDelay(750);
        this.searchTextField.putClientProperty("JTextField.Search.ProgressiveTimer.Callback", this.fieldCallBack);
        this.searchTextField.setText(filter.getText());
    }

    private String filterCharacter(char c) {
        String val = this.searchTextField.getText();
        if (c == '\b') {
            return !val.isEmpty() ? val.substring(0, val.length() - 1) : "";
        }
        return val + String.valueOf(c);
    }

    private void initComponents() {
        this.searchTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchPanel.this.searchTextFieldKeyReleased(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.searchTextField, gridBagConstraints);
    }

    private void searchTextFieldKeyReleased(KeyEvent evt) {
        this.checkEscPressed(evt.getKeyCode());
    }

    private void checkEscPressed(int keycode) {
        if (keycode == 27) {
            this.searchTextField.setText("");
            this.doSearch();
            this.filteringObject.requestFocus();
        }
    }

    public void clear() {
        this.searchTextField.setText("");
        this.doSearch();
        this.filteringObject.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.filteringObject.addKeyListener(this.keyAdapter);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.filteringObject.removeKeyListener(this.keyAdapter);
    }

    private void doSearch() {
        String text = this.searchTextField.getText();
        if (this.filter != null) {
            this.filter.setText(text);
        }
    }

    private class DarculaTextFieldUICallbackImpl
    extends DarculaTextFieldUICallback {
        private DarculaTextFieldUICallbackImpl() {
        }

        public void perform() {
            SearchPanel.this.doSearch();
        }
    }
}

