/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.slide;

import com.paterva.maltego.util.ui.ctxmenu.WindowPopupMenu;
import com.paterva.maltego.util.ui.slide.SlideWindow;
import com.paterva.maltego.util.ui.slide.SlideWindowContainer;
import com.paterva.maltego.util.ui.slide.SlideWindowManager;
import com.paterva.maltego.util.ui.slide.SlideWindowProvider;
import com.paterva.maltego.util.ui.slide.SlideWindowSerializer;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class DefaultSlideWindowManager
extends SlideWindowManager {
    private final List<SlideWindowContainer> _slideWindows = new ArrayList<SlideWindowContainer>();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private SlideWindowContainer _active = null;
    private PropertyChangeListener _listener;

    @Override
    public void addAll(Container parent) {
        Collection providers = Lookup.getDefault().lookupAll(SlideWindowProvider.class);
        for (SlideWindowProvider provider : providers) {
            SlideWindow slideWindow = provider.getSlideWindow();
            SlideWindowContainer container = new SlideWindowContainer(slideWindow);
            SlideWindowSerializer.getDefault().restore(container);
            parent.add((Component)container, (Object)1);
            this._slideWindows.add(container);
            slideWindow.opened();
        }
        this._listener = new FocusListener();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(this._listener);
    }

    @Override
    public void closeAll() {
        this.setActiveSlideWindow(null);
        for (SlideWindowContainer container : this._slideWindows) {
            SlideWindow slideWindow = container.getSlideWindow();
            SlideWindowSerializer.getDefault().save(container);
            slideWindow.deactivated();
            slideWindow.closed();
        }
        this._slideWindows.clear();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(this._listener);
        this._listener = null;
    }

    @Override
    public List<SlideWindowContainer> getAll() {
        return Collections.unmodifiableList(this._slideWindows);
    }

    private void setActiveSlideWindow(SlideWindowContainer slideWindow) {
        if (!Utilities.compareObjects((Object)this._active, (Object)slideWindow)) {
            SlideWindowContainer old = this._active;
            this._active = slideWindow;
            if (old != null) {
                this.setActivated(old, false);
            }
            if (this._active != null) {
                this.setActivated(this._active, true);
            }
            this._changeSupport.firePropertyChange("activeSlideWindowChanged", old, this._active);
        }
    }

    @Override
    public SlideWindow getActive() {
        return this._active != null ? this._active.getSlideWindow() : null;
    }

    @Override
    public JComponent getActiveContent() {
        SlideWindow active = this.getActive();
        return active != null ? active.getComponent() : null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private void setActivated(SlideWindowContainer container, boolean activated) {
        SlideWindow content = container.getSlideWindow();
        if (content instanceof SlideWindow) {
            SlideWindow slideWindowTopComponent = content;
            if (activated) {
                slideWindowTopComponent.activated();
            } else {
                slideWindowTopComponent.deactivated();
            }
            container.repaint();
        }
    }

    private class FocusListener
    implements PropertyChangeListener {
        private FocusListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component owner;
            Object newValue;
            if ("permanentFocusOwner".equals(evt.getPropertyName()) && (newValue = evt.getNewValue()) instanceof Component && !this.isInContextMenu(owner = (Component)newValue)) {
                SlideWindowContainer active = null;
                block0: for (Component parent = owner; parent != null && active == null; parent = parent.getParent()) {
                    if (!(parent instanceof SlideWindowContainer)) continue;
                    for (SlideWindowContainer slideWindow : DefaultSlideWindowManager.this._slideWindows) {
                        if (!parent.equals(slideWindow)) continue;
                        active = slideWindow;
                        continue block0;
                    }
                }
                DefaultSlideWindowManager.this.setActiveSlideWindow(active);
            }
        }

        private boolean isInContextMenu(Component owner) {
            return owner instanceof WindowPopupMenu || SwingUtilities.getAncestorOfClass(WindowPopupMenu.class, owner) != null;
        }
    }
}

