/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonTaskToggleButtonUI;

public class OfficeRibbonTaskToggleButtonUI
extends BasicRibbonTaskToggleButtonUI {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static final String normalBackground = "ribbon-tab-bg";
    private static final String selectedBackground1 = "ribbon-tab-bg-selected1";
    private static final String selectedBackground2 = "ribbon-tab-bg-selected2";
    private static final String normalTabText = "ribbon-tab-text-normal";
    private static final String normalTabTextFont = "ribbon-tab-text-normalFont";
    private static final String selectedTabText = "ribbon-tab-text-selected";
    private static final String selectedTabTextFont = "ribbon-tab-text-selectedFont";
    private PropertyChangeListener officePropertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new OfficeRibbonTaskToggleButtonUI();
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        this.officePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("contextualGroupHueColor".equals(evt.getPropertyName())) {
                    Color newValue = (Color)evt.getNewValue();
                    OfficeRibbonTaskToggleButtonUI.this.commandButton.setBackground(newValue);
                }
            }
        };
        this.commandButton.addPropertyChangeListener(this.officePropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.commandButton.removePropertyChangeListener(this.officePropertyChangeListener);
        this.officePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected Color getForegroundColor(boolean isTextPaintedEnabled) {
        return LAF.getColor(isTextPaintedEnabled ? "ribbon-button-text-color" : "ribbon-button-disabled-text-color");
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        ActionButtonModel model = this.commandButton.getActionModel();
        toFill.height -= 10;
        if (model.isArmed() && model.isPressed() || model.isSelected() || model.isRollover()) {
            this.paintSelectedBackground(graphics, this.commandButton, toFill);
            graphics.setColor(LAF.getColor(selectedTabText));
        } else {
            this.paintNormalBackground(graphics, this.commandButton, toFill);
            graphics.setColor(LAF.getColor(normalTabText));
        }
    }

    protected void paintText(Graphics g) {
        ActionButtonModel model = this.commandButton.getActionModel();
        if (model.isArmed() && model.isPressed() || model.isSelected() || model.isRollover()) {
            g.setFont(LAF.getFont(selectedTabTextFont));
        } else {
            g.setFont(LAF.getFont(normalTabTextFont));
        }
        super.paintText(g);
    }

    protected void paintNormalBackground(Graphics g, AbstractCommandButton button, Rectangle rect) {
        int x = rect.x;
        int y = rect.y;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(LAF.getColor(normalBackground));
        g2d.fillRect(x, y, rect.width, rect.height);
    }

    protected void paintSelectedBackground(Graphics g, AbstractCommandButton button, Rectangle rect) {
        Graphics2D g2d = (Graphics2D)g;
        int x = rect.x;
        int y = rect.y;
        int b = rect.y + rect.height - 1;
        g2d.setPaint(new LinearGradientPaint(x, y + 1, x, b, new float[]{0.0f, 1.0f}, new Color[]{LAF.getColor(selectedBackground1), LAF.getColor(selectedBackground2)}));
        g2d.fillRect(x, y, rect.width, rect.height);
    }
}

