/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.manager.palette.PaletteSupport;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewNotificationAdapter;
import com.paterva.maltego.ui.graph.ViewCallback;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.ViewDescriptor;
import com.paterva.maltego.ui.graph.actions.BookmarkAction;
import com.paterva.maltego.ui.graph.actions.EditNodeAction;
import com.paterva.maltego.ui.graph.actions.FullScreenTCAction;
import com.paterva.maltego.ui.graph.actions.FullScreenTCButton;
import com.paterva.maltego.ui.graph.actions.SelectBookmarkAction;
import com.paterva.maltego.ui.graph.actions.SelectionToggleAction;
import com.paterva.maltego.ui.graph.clipboard.GraphCopyAction;
import com.paterva.maltego.ui.graph.clipboard.GraphCutAction;
import com.paterva.maltego.ui.graph.clipboard.MergeGraphPasteAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.find.ShowFindBarAction;
import com.paterva.maltego.ui.graph.impl.GraphViewElementUndoRedo;
import com.paterva.maltego.ui.graph.impl.GraphViewUpdateManager;
import com.paterva.maltego.ui.graph.impl.SlaveGraphViewElement;
import com.paterva.maltego.ui.graph.impl.ViewPanel;
import com.paterva.maltego.ui.graph.nodes.QuickDeleteAction;
import com.paterva.maltego.util.ui.components.LeftAlignedToggleButton;
import com.paterva.maltego.util.ui.components.ToolBarLabel;
import com.paterva.maltego.view.customization.api.CustomizableViewRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.painter.BusyPainter;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.spi.palette.PaletteController;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import yguard.A.A._;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.tB;
import yguard.A.J.x;

class GraphViewElement
implements MultiViewElement,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(GraphViewElement.class.getName());
    private static final String FREEZE_BUTTON = "freeze_button";
    private static final String UPDATE_BUTTON = "update_button";
    private static final String CONTROL_VIEW = "ControlView";
    private static final String PROGRESS_VIEW = "ProgressView";
    private final JPanel _elementPanel = new JPanel(new BorderLayout());
    private final GraphViewPanel _viewPanel;
    private final GraphViewElementUndoRedo _undoRedo = new GraphViewElementUndoRedo();
    private final DataObjectListener _dObjListener;
    private DataObject _dobj;
    private ViewControlAdapter _adapter;
    private MultiViewElementCallback _multiviewCB;
    private Lookup _lookup;
    private GraphID _graphID;
    private GraphViewUpdateManager _updater;
    private ViewDescriptor _descriptor;
    private boolean _preparingView = false;
    private JToggleButton _freezeButton;
    private ToolBarLabel _freezeLabel;
    private JButton _updateButton;
    private JComponent _viewControl;
    private GraphFindListener findListener;
    private long time = System.currentTimeMillis();

    public GraphViewElement(DataObject dobj, ViewControlAdapter adapter) {
        this._dobj = dobj;
        this._dObjListener = new DataObjectListener();
        this._dobj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._dObjListener, (Object)this._dobj));
        this._adapter = adapter;
        this._viewControl = this.getControlAdapter().getViewControl();
        this._viewPanel = new GraphViewPanel((GraphDataObject)this._dobj);
        this._viewPanel.addMainView(this._viewControl, CONTROL_VIEW);
        this._viewPanel.addMainView(new ProgressView(), PROGRESS_VIEW);
        this._elementPanel.add(this._viewPanel);
    }

    protected final ViewControlAdapter getControlAdapter() {
        return this._adapter;
    }

    public DataObject getDataObject() {
        return this._dobj;
    }

    protected GraphDataObject getGraphDataObject() {
        return (GraphDataObject)this._dobj;
    }

    public JComponent getVisualRepresentation() {
        return this._elementPanel;
    }

    private void updateFreezeButtons() {
        boolean visible;
        boolean bl = visible = "false".equals(System.getProperty("maltego.hide-freeze-button", "false")) && this.getGraphDataObject().canFreeze();
        if (this._freezeButton != null) {
            this._freezeButton.setVisible(visible);
        }
        if (this._updateButton != null) {
            this._updateButton.setVisible(visible);
        }
        if (this._freezeLabel != null) {
            this._freezeLabel.setVisible(visible);
        }
    }

    public JComponent getToolbarRepresentation() {
        JToolBar panel = new JToolBar(){

            @Override
            public void addSeparator() {
                JToolBar.Separator s2 = new JToolBar.Separator(null){

                    @Override
                    public void setBounds(int x2, int y2, int width, int height) {
                        super.setBounds(0, y2, width, height);
                    }
                };
                s2.setBorder(new EmptyBorder(0, 0, 0, 0));
                s2.setAlignmentX(0.0f);
                this.add(s2);
            }
        };
        panel.setOrientation(1);
        Dimension minD = new Dimension(10, 10);
        panel.setMinimumSize(minD);
        panel.setFloatable(false);
        panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel.setMargin(new Insets(0, 0, 0, 0));
        FullScreenTCAction fullScreenAction = new FullScreenTCAction();
        FullScreenTCButton fullscreenButton = new FullScreenTCButton(fullScreenAction);
        ((JComponent)((Object)fullscreenButton)).setOpaque(false);
        ((AbstractButton)((Object)fullscreenButton)).setText("");
        panel.add((Component)((Object)fullscreenButton));
        String fullScreenKey = "maltego.fullscreen";
        this._viewPanel.getActionMap().put(fullScreenKey, fullScreenAction);
        this._viewPanel.getInputMap(1).put(KeyStroke.getKeyStroke("alt pressed ENTER"), fullScreenKey);
        this._viewPanel.getInputMap(2).put(KeyStroke.getKeyStroke("alt pressed ENTER"), fullScreenKey);
        String editDialogKey = "maltego.edit.dialog";
        this._viewPanel.getActionMap().put(editDialogKey, (Action)SystemAction.get(EditNodeAction.class));
        this._viewPanel.getInputMap(1).put(KeyStroke.getKeyStroke("ctrl pressed ENTER"), editDialogKey);
        this._viewPanel.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl pressed ENTER"), editDialogKey);
        JComponent toolbarComp = this.getControlAdapter().getToolbar();
        int insertIndexView = -1;
        ArrayList<Integer> removeIndices = new ArrayList<Integer>();
        if (toolbarComp != null) {
            if (toolbarComp instanceof JToolBar) {
                JToolBar toolbar = (JToolBar)toolbarComp;
                toolbar.setOrientation(1);
                this.doubleCheckSelectedButton(toolbar);
                for (Component comp : toolbar.getComponents()) {
                    Object button;
                    if (comp instanceof ToolBarLabel) {
                        ToolBarLabel label = (ToolBarLabel)comp;
                        if ("View".equals(label.getText())) {
                            int n2 = insertIndexView = insertIndexView == -1 ? toolbar.getComponentIndex(comp) : insertIndexView;
                        }
                        if (!"Freeze".equals(label.getText())) continue;
                        removeIndices.add(toolbar.getComponentIndex(comp));
                        continue;
                    }
                    if (comp instanceof LeftAlignedToggleButton) {
                        button = (LeftAlignedToggleButton)comp;
                        if (!Boolean.TRUE.equals(button.getClientProperty((Object)FREEZE_BUTTON))) continue;
                        removeIndices.add(toolbar.getComponentIndex(comp));
                        continue;
                    }
                    if (!(comp instanceof JButton) || !Boolean.TRUE.equals(((JComponent)(button = (JButton)comp)).getClientProperty(UPDATE_BUTTON))) continue;
                    removeIndices.add(toolbar.getComponentIndex(comp));
                }
                Collections.reverse(removeIndices);
                if (insertIndexView != -1) {
                    for (Integer index : removeIndices) {
                        if (index == -1) continue;
                        toolbar.remove(index);
                        if (index >= insertIndexView) continue;
                        --insertIndexView;
                    }
                    this.createFreezeOptions(toolbar, insertIndexView);
                }
                toolbar.setMinimumSize(minD);
                panel.add(toolbar);
            } else {
                Component comp;
                this.createFreezeOptions(panel, panel.getComponentCount());
                Component[] comps = toolbarComp.getComponents();
                if (comps.length == 1 && (comp = comps[0]) instanceof JToolBar) {
                    ToolBarLabel label;
                    Component component;
                    int i;
                    JToolBar toolbar = (JToolBar)comp;
                    toolbar.setOrientation(1);
                    Component[] components = toolbar.getComponents();
                    for (i = 0; !(i >= components.length || (component = components[i]) instanceof ToolBarLabel && "View".equals((label = (ToolBarLabel)component).getText())); ++i) {
                    }
                    --i;
                    while (i >= 0) {
                        toolbar.remove(i);
                        --i;
                    }
                    panel.add(toolbar);
                }
            }
        }
        return panel;
    }

    private void doubleCheckSelectedButton(JToolBar toolbar) {
        String activeViewlet = CustomizableViewRegistry.getDefault().getView(this.getControlAdapter().getGraphID()).getActiveViewlet();
        if (activeViewlet != null) {
            Component[] components = toolbar.getComponents();
            JComponent component = (JComponent)components[components.length - 1];
            component = (JComponent)component.getComponents()[0];
            for (Component comp : component.getComponents()) {
                if (!(comp instanceof JToggleButton)) continue;
                JToggleButton button = (JToggleButton)comp;
                button.setSelected(button.getActionCommand().equals(activeViewlet));
            }
        }
    }

    private void createFreezeOptions(JToolBar toolbar, int insertIndexView) {
        GraphViewUpdateManager updater = this.updater();
        if (updater != null) {
            this._freezeLabel = new ToolBarLabel("Freeze");
            toolbar.add((Component)this._freezeLabel, insertIndexView++);
            this._freezeButton = new LeftAlignedToggleButton(updater.getToggleFreezeAction());
            this._freezeButton.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FreezeBlue.png", (boolean)false));
            this._freezeButton.setSelectedIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FreezeRed.png", (boolean)false));
            this._freezeButton.setSelected(updater.isFrozen());
            this._freezeButton.setText("");
            this._freezeButton.setOpaque(false);
            this._freezeButton.putClientProperty(FREEZE_BUTTON, Boolean.TRUE);
            toolbar.add((Component)this._freezeButton, insertIndexView++);
            this._updateButton = new JButton(updater.getUpdateViewAction()){

                @Override
                public void setBounds(int x2, int y2, int width, int height) {
                    super.setBounds(1, y2, width, height);
                }
            };
            this._updateButton.setOpaque(false);
            this._updateButton.putClientProperty("alphaHoverColor", Boolean.TRUE);
            this._updateButton.setText("");
            this._updateButton.putClientProperty(UPDATE_BUTTON, Boolean.TRUE);
            toolbar.add((Component)this._updateButton, insertIndexView);
            this.updateFreezeButtons();
        }
    }

    public Action[] getActions() {
        if (this._multiviewCB != null) {
            return this._multiviewCB.createDefaultActions();
        }
        return new Action[0];
    }

    public synchronized Lookup getLookup() {
        if (this._lookup == null) {
            int i;
            PaletteController pc = null;
            if (this._descriptor.showPalette()) {
                pc = PaletteSupport.getPalette();
            }
            ActionMap map = this._viewPanel.getActionMap();
            JComponent view = this.getControlAdapter().getViewControl();
            GraphViewElement.attachActions(view.getActionMap(), map);
            BookmarkAction bookmarkAction = new BookmarkAction();
            SelectBookmarkAction selectBookmarkAction = new SelectBookmarkAction();
            map.put("copy-to-clipboard", (Action)SystemAction.get(GraphCopyAction.class));
            map.put("cut-to-clipboard", (Action)SystemAction.get(GraphCutAction.class));
            map.put("maltego.paste", (Action)SystemAction.get(MergeGraphPasteAction.class));
            map.put("delete", (Action)SystemAction.get(QuickDeleteAction.class));
            map.put("maltego.selection.toggle", (Action)SystemAction.get(SelectionToggleAction.class));
            for (i = 0; i < 10; ++i) {
                map.put("bookmark" + i, bookmarkAction);
                map.put("select.bookmark" + i, selectBookmarkAction);
            }
            GraphViewElement.attachActions(map, this._elementPanel.getActionMap());
            this.addInput(Utilities.stringToKey((String)"D-C"), "copy-to-clipboard");
            this.addInput(Utilities.stringToKey((String)"D-X"), "cut-to-clipboard");
            this.addInput(Utilities.stringToKey((String)"D-V"), "maltego.paste");
            this.addInput(KeyStroke.getKeyStroke("DELETE"), "delete");
            this.addInput(Utilities.stringToKey((String)"D-N"), "maltego.selection.toggle");
            for (i = 0; i < 10; ++i) {
                this.addInput(Utilities.stringToKey((String)("D-" + i)), "bookmark" + i);
                this.addInput(Utilities.stringToKey((String)Integer.toString(i)), "select.bookmark" + i);
            }
            ArrayList<Lookup> lookups = new ArrayList<Lookup>();
            if (pc != null) {
                lookups.add(Lookups.singleton((Object)pc));
            }
            lookups.add(this._dobj.getNodeDelegate().getLookup());
            Lookup controlLookup = this.getControlAdapter().getLookup();
            if (controlLookup != Lookup.EMPTY) {
                lookups.add(controlLookup);
            }
            this._lookup = new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
        }
        return this._lookup;
    }

    private void addInput(KeyStroke keyStroke, Object action) {
        if (this._elementPanel != null) {
            this._elementPanel.getInputMap(1).put(keyStroke, action);
        }
        if (this._viewPanel != null) {
            this._viewPanel.getInputMap(1).put(keyStroke, action);
        }
        if (this._adapter != null) {
            this._adapter.addInput(keyStroke, action);
        }
    }

    private static void attachActions(ActionMap src, ActionMap target) {
        Object[] keys = src.keys();
        if (keys != null) {
            for (Object key : keys) {
                target.put(key, src.get(key));
            }
        }
    }

    public void componentOpened() {
        this.startLoadModelGraph();
    }

    private void modelGraphLoadedImpl(GraphID graphID) {
        LOGGER.log(Level.FINE, "Graph Loaded: {0}", graphID);
        this._graphID = graphID;
        this._undoRedo.setGraphID(graphID);
        this.updater().setGraphID(graphID);
        this.updater().addPropertyChangeListener(this);
        this.getControlAdapter().onGraphLoaded();
        this.getControlAdapter().componentOpened();
        this.getControlAdapter().componentShowing();
    }

    private synchronized GraphViewUpdateManager updater() {
        if (this._updater == null) {
            this._updater = new GraphViewUpdateManager();
        }
        return this._updater;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("freezableChanged".equals(evt.getPropertyName()) && this._freezeButton != null && this._updater != null) {
            this._freezeButton.setSelected(this._updater.isFrozen());
        }
    }

    public void componentClosed() {
        if (this._graphID != null) {
            GraphLifeCycleManager.getDefault().fireGraphClosing(this._graphID);
        }
        LOGGER.fine("Graph Closed");
        try {
            if (this._updater != null) {
                this._updater.removePropertyChangeListener(this);
                this._updater.viewClosed();
            }
            if (this._adapter != null) {
                this._adapter.componentClosed();
            }
            if (this._dobj instanceof GraphDataObject && !(this instanceof SlaveGraphViewElement)) {
                GraphDataObject graphDataObject = (GraphDataObject)this._dobj;
                GraphID graphID = graphDataObject.getGraphID();
                SA graph2D = GraphViewManager.getDefault().getViewGraph(graphID);
                if (graph2D != null) {
                    graph2D.t();
                    this.removeListeners(graph2D);
                    Object[] dataProviderKeys = graph2D.q();
                    if (dataProviderKeys != null) {
                        for (Object dataProviderKey : dataProviderKeys) {
                            String dataProviderStr;
                            if (!(dataProviderKey instanceof String) || !(dataProviderStr = (String)dataProviderKey).startsWith("maltego")) continue;
                            graph2D.E(dataProviderKey);
                        }
                    }
                }
                graphDataObject.onGraphClosed();
                graphDataObject.setModified(false);
            }
            this._dobj = null;
            this._multiviewCB = null;
            this._updater = null;
            this._lookup = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphViewElement.this._adapter = null;
                    if (GraphViewElement.this._viewControl != null) {
                        GraphViewElement.this._viewControl.removeAll();
                        GraphViewElement.this._viewControl = null;
                    }
                }
            });
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void removeListeners(SA graph) {
        Iterator itr = graph.\u00c0();
        while (itr.hasNext()) {
            graph.B((_)itr.next());
        }
        Iterator graph2DListeners = graph.\u0104();
        while (graph2DListeners.hasNext()) {
            graph.A((tB)graph2DListeners.next());
        }
        Iterator selectionListeners = graph.\u0109();
        while (selectionListeners.hasNext()) {
            graph.B((yguard.A.J._)selectionListeners.next());
        }
    }

    public void componentShowing() {
        LOGGER.log(Level.FINE, "Component Showing (preparing={0})", this._preparingView);
        if (this._graphID != null && !this._preparingView) {
            this._preparingView = true;
            this.startProgress();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    GraphViewElement.this.getControlAdapter().prepareToShow();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GraphViewElement.this.progressComplete();
                            GraphViewElement.this._preparingView = false;
                            GraphViewUpdateManager updater = GraphViewElement.this.updater();
                            if (updater != null) {
                                updater.viewShowing();
                            }
                            GraphViewElement.this.getControlAdapter().componentShowing();
                            GraphViewElement.this._viewPanel.componentShowing();
                            GraphViewElement.this.attachFocus();
                            LOGGER.log(Level.INFO, "Open to showing graph took: {0}s", (double)(System.currentTimeMillis() - GraphViewElement.this.time) / 1000.0);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    TopComponent topComponent = GraphEditorRegistry.getDefault().getTopmost();
                                    GraphDataObject gdo = (GraphDataObject)topComponent.getLookup().lookup(GraphDataObject.class);
                                    gdo.updateDisplayName();
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private void attachFocus() {
        JComponent viewControl;
        boolean mustAdd = this.findListener == null;
        if (mustAdd) {
            this.findListener = new GraphFindListener(this._graphID);
        }
        if ((viewControl = this._adapter.getViewControl()) instanceof U) {
            for (Component component : viewControl.getComponents()) {
                if (!(component instanceof x)) continue;
                if (mustAdd) {
                    component.addKeyListener(this.findListener);
                }
                component.requestFocus();
                break;
            }
        }
    }

    public void componentHidden() {
        LOGGER.fine("Component Hidden");
        GraphViewUpdateManager updater = this.updater();
        if (updater != null) {
            updater.viewHidden();
        }
        this.getControlAdapter().componentHidden();
        this._viewPanel.componentHidden();
    }

    public void componentActivated() {
        LOGGER.fine("Component Activated");
        this.getControlAdapter().componentActivated();
    }

    public void componentDeactivated() {
        LOGGER.fine("Component Deactivated");
        this.getControlAdapter().componentDeactivated();
    }

    public UndoRedo getUndoRedo() {
        return this._undoRedo;
    }

    public void setMultiViewCallback(MultiViewElementCallback mvec) {
        this._multiviewCB = mvec;
        this.getControlAdapter().setViewCallback(new ViewElementCallback());
    }

    public CloseOperationState canCloseElement() {
        if (this._dobj.isModified()) {
            return MultiViewFactory.createUnsafeCloseState((String)"dirty", (Action)new ProceedAction(), (Action)new DiscardAction());
        }
        return CloseOperationState.STATE_OK;
    }

    private void startLoadModelGraph() {
        LOGGER.fine("Start Load Graph");
        final GraphCookie cookie = (GraphCookie)this.getDataObject().getLookup().lookup(GraphCookie.class);
        if (cookie != null) {
            this.startProgress();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    final GraphID graphID = cookie.getOrLoadGraph();
                    if (graphID != null) {
                        GraphViewElement.this.modelGraphLoadedImpl(graphID);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GraphViewElement.this.progressComplete();
                                GraphViewElement.this.componentShowing();
                                GraphViewNotificationAdapter.getDefault().fireGraphLoadingDone(GraphViewElement.this.getGraphDataObject());
                                GraphLifeCycleManager.getDefault().fireGraphOpened(graphID);
                            }
                        });
                    }
                }
            });
        }
    }

    private void startProgress() {
        LOGGER.fine("Start Progress");
        this._viewPanel.selectMainView(PROGRESS_VIEW);
    }

    private void progressComplete() {
        LOGGER.fine("Progress Complete");
        this._viewPanel.selectMainView(CONTROL_VIEW);
    }

    void init(ViewDescriptor descriptor) {
        this._descriptor = descriptor;
    }

    private class GraphFindListener
    extends KeyAdapter {
        private final GraphID graphID;

        public GraphFindListener(GraphID graphID) {
            this.graphID = graphID;
        }

        @Override
        public void keyTyped(KeyEvent e2) {
            String key;
            GraphUserData gud;
            Object get;
            char keyChar = e2.getKeyChar();
            if (!e2.isControlDown() && !e2.isActionKey() && !e2.isConsumed() && keyChar != '\u001b' && keyChar != '\b' && keyChar != '\u007f' && (get = (gud = GraphUserData.forGraph((GraphID)this.graphID)).get((Object)(key = ShowFindBarAction.class.getName()))) != null && get instanceof ShowFindBarAction) {
                ShowFindBarAction findAction = (ShowFindBarAction)get;
                findAction.fireAndInitialise(keyChar);
            }
        }
    }

    private class DataObjectListener
    implements PropertyChangeListener {
        private DataObjectListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("canFreezeGraph".equals(evt.getPropertyName())) {
                GraphViewUpdateManager updater = GraphViewElement.this.updater();
                boolean canFreeze = (Boolean)evt.getNewValue();
                if (!canFreeze && updater.isFrozen()) {
                    updater.setFrozen(false);
                }
                GraphViewElement.this.updateFreezeButtons();
            }
        }
    }

    private static final class ProgressView
    extends JPanel {
        public ProgressView() {
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel(new BorderLayout());
            int size = 25;
            float factor = 0.25f;
            JXBusyLabel label = new JXBusyLabel(new Dimension(25, 25));
            BusyPainter painter = new BusyPainter(25);
            painter.setTrailLength(5);
            painter.setPoints(10);
            painter.setPointShape((Shape)new RoundRectangle2D.Float(10.0f * factor, 10.0f * factor, 50.0f * factor, 20.0f * factor, 20.0f * factor, 20.0f * factor));
            painter.setFrame(1);
            label.setPreferredSize(new Dimension(25, 25));
            label.setIcon((Icon)new EmptyIcon(25, 25));
            label.setBusyPainter(painter);
            label.setBusy(true);
            label.setHorizontalAlignment(0);
            panel.add((Component)label, "Center");
            panel.setAlignmentY(0.5f);
            this.add((Component)panel, "Center");
        }
    }

    private final class ViewElementCallback
    implements ViewCallback {
        private ViewElementCallback() {
        }

        @Override
        public ViewDescriptor getDescriptor() {
            return GraphViewElement.this._descriptor;
        }

        @Override
        public TopComponent getTopComponent() {
            return GraphViewElement.this._multiviewCB.getTopComponent();
        }

        @Override
        public void showSideBar(Component component, String position) {
            GraphViewElement.this._viewPanel.addSideBar(component, position);
        }

        @Override
        public void hideSideBar(String position) {
            GraphViewElement.this._viewPanel.removeSideBar(position);
        }
    }

    private class DiscardAction
    extends AbstractAction {
        private DiscardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                if (GraphViewElement.this._dobj != null) {
                    GraphViewElement.this._dobj.setModified(false);
                    GraphViewElement.this._dobj.setValid(false);
                }
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private class ProceedAction
    extends AbstractAction {
        private ProceedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                SaveCookie sc;
                if (GraphViewElement.this._dobj != null && (sc = (SaveCookie)GraphViewElement.this._dobj.getCookie(SaveCookie.class)) != null) {
                    sc.save();
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        @Override
        public boolean isEnabled() {
            return GraphViewElement.this._dobj != null ? GraphViewElement.this._dobj.isModified() : false;
        }
    }

    private class GraphViewPanel
    extends ViewPanel {
        public GraphViewPanel(GraphDataObject gdo) {
            super(gdo);
            this.forceHeavyWeightPopups();
        }

        private void forceHeavyWeightPopups() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Field field;
                    Class<?> clazz2;
                    boolean success = false;
                    try {
                        clazz2 = Class.forName("javax.swing.ClientPropertyKey");
                        field = clazz2.getDeclaredField("PopupFactory_FORCE_HEAVYWEIGHT_POPUP");
                        field.setAccessible(true);
                        GraphViewPanel.this.putClientProperty(field.get(null), Boolean.TRUE);
                        success = true;
                    }
                    catch (Exception clazz2) {
                        // empty catch block
                    }
                    if (!success) {
                        try {
                            clazz2 = Class.forName("javax.swing.PopupFactory");
                            field = clazz2.getDeclaredField("forceHeavyWeightPopupKey");
                            field.setAccessible(true);
                            GraphViewPanel.this.putClientProperty(field.get(null), Boolean.TRUE);
                            success = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!success) {
                        LOGGER.severe("Failed to force popups to be heavyweight.");
                    }
                    return null;
                }
            });
        }
    }
}

