/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.metadata;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.metadata.GraphMetadata;
import com.paterva.maltego.graph.metadata.GraphMetadataManager;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.metadata.MetadataController;
import com.paterva.maltego.util.ui.actions.ActionSupplemental;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Utilities;

@ActionSupplemental(key="description", value="View or edit the metadata for the current graph")
public final class EditMetadataAction
implements ActionListener {
    private GraphCookie _cookie;

    public EditMetadataAction(GraphCookie cookie) {
        this._cookie = cookie;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String authorNew;
        GraphID graphID = this._cookie.getGraphID();
        GraphMetadata metadata = GraphMetadataManager.getDefault().get(graphID);
        MetadataController controller = new MetadataController();
        EditDialogDescriptor dd = new EditDialogDescriptor("Graph Metadata", (WizardDescriptor.Panel)controller);
        String authorOld = metadata.getAuthor();
        dd.putProperty("author", (Object)authorOld);
        dd.putProperty("created", (Object)metadata.getCreated());
        dd.putProperty("modified", (Object)metadata.getModified());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == EditDialogDescriptor.OK_OPTION && !Utilities.compareObjects((Object)authorOld, (Object)(authorNew = (String)dd.getProperty("author")))) {
            metadata.setAuthor(authorNew);
            if (this._cookie instanceof GraphDataObject) {
                ((GraphDataObject)this._cookie).setModified(true);
            }
        }
    }
}

