/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.HitInfoCache;
import com.paterva.maltego.ui.graph.view2d.LinkEdgeRealizer;
import com.paterva.maltego.ui.graph.view2d.LinkPresenter;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.UIManager;
import org.openide.util.Exceptions;
import yguard.A.A.C;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.A._;
import yguard.A.J.BA;
import yguard.A.J.GA;
import yguard.A.J.MC;
import yguard.A.J.SA;
import yguard.A.J.Y;
import yguard.A.J.fA;
import yguard.A.J.mB;
import yguard.A.J.q;

public class LinkHighlighter
extends mB {
    private Y _lastHoveredNode;
    private final fA _highlightType = fA.I;
    private E _lastSelection;
    private final MyListener _selectionListener = new MyListener();
    private static final int MAX_NODES = 50;
    private Rectangle2D _dirtyArea = null;

    private Color getHighlightColorChild() {
        return UIManager.getLookAndFeelDefaults().getColor("graph-link-highlight-child-color");
    }

    private Color getHighlightColorParent() {
        return UIManager.getLookAndFeelDefaults().getColor("graph-link-highlight-parent-color");
    }

    private boolean highlightOnHover() {
        return true;
    }

    private boolean highlightOnSelect() {
        return true;
    }

    private boolean highlightOnHover(Y node) {
        if (this._lastSelection == null) {
            return true;
        }
        return !this.highlightOnSelect() || this._lastSelection.size() > 50 || !this.view.getGraph2D().g(node);
    }

    protected void setSelectedNodes(E selectionCursor) throws GraphStoreException {
        if (this.highlightOnSelect()) {
            E nc;
            if (this._lastSelection != null && this._lastSelection.size() <= 50) {
                this._lastSelection.toFirst();
                nc = this._lastSelection;
                while (nc.ok()) {
                    this.markEdges(nc.B().I(), null, null);
                    nc.next();
                }
            }
            if (selectionCursor != null && selectionCursor.size() <= 50) {
                selectionCursor.toFirst();
                nc = selectionCursor;
                while (nc.ok()) {
                    this.markEdges(nc.B().M(), this.getHighlightColorParent(), this._highlightType);
                    this.markEdges(nc.B().G(), this.getHighlightColorChild(), this._highlightType);
                    nc.next();
                }
            }
            this._lastSelection = selectionCursor;
        }
    }

    protected void setHoveredEdge(H edge) {
    }

    protected void setHoveredNode(Y node) {
        try {
            if (this.highlightOnHover() && this._lastHoveredNode != node) {
                if (this._lastHoveredNode != null && this.highlightOnHover(this._lastHoveredNode)) {
                    this.markEdges(this._lastHoveredNode.I(), null, null);
                    if (this._lastSelection != null && this.highlightOnSelect()) {
                        this.setSelectedNodes(this._lastSelection);
                    }
                }
                if (node != null && this.highlightOnHover(node)) {
                    this.markEdges(node.M(), this.getHighlightColorParent(), this._highlightType);
                    this.markEdges(node.G(), this.getHighlightColorChild(), this._highlightType);
                }
                this._lastHoveredNode = node;
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void markEdges(Z cursor, Color color, fA type) throws GraphStoreException {
        SA graph = this.view.getGraph2D();
        GraphID graphID = GraphIDProvider.forGraph((SA)graph);
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
        HashMap<LinkID, Realizers> linkRealizers = new HashMap<LinkID, Realizers>(cursor.size());
        HashMap<LinkID, Realizers> cnLinkRealizers = new HashMap<LinkID, Realizers>(cursor.size());
        cursor.toFirst();
        while (cursor.ok()) {
            H edge = cursor.D();
            LinkID linkID = wrapper.linkID(edge);
            q er = graph.X(edge);
            BA sr = graph.f(edge.X());
            BA tr = graph.f(edge.V());
            if (!wrapper.isCollectionNodeLink(linkID)) {
                linkRealizers.put(linkID, new Realizers(er, sr, tr));
            } else {
                cnLinkRealizers.put(linkID, new Realizers(er, sr, tr));
            }
            cursor.next();
        }
        Set linkIDs = linkRealizers.keySet();
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        linkIDs = structureReader.getExistingLinks(linkIDs);
        Map links = GraphStoreHelper.getLinks((GraphID)graphID, (Collection)linkIDs);
        GraphStoreView gsView = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings modelViewMappings = gsView.getModelViewMappings();
        Set cnLinkIDs = cnLinkRealizers.keySet();
        for (LinkID linkID : cnLinkIDs) {
            if (!modelViewMappings.isViewLink(linkID)) continue;
            links.put(linkID, null);
        }
        for (Map.Entry entry : links.entrySet()) {
            Color lineColor;
            fA lineType;
            LinkID linkID = (LinkID)entry.getKey();
            MaltegoLink link = (MaltegoLink)entry.getValue();
            Realizers realizers = (Realizers)linkRealizers.get(linkID);
            if (realizers == null) {
                realizers = (Realizers)cnLinkRealizers.get(linkID);
            }
            q er = realizers.getEdgeRealizer();
            LinkPresenter linkPresenter = LinkPresenter.getDefault();
            if (link == null) {
                lineType = type != null ? type : LinkEdgeRealizer.DEFAULT_LINE_TYPE;
                lineColor = color != null ? color : LinkEdgeRealizer.DEFAULT_MANUAL_LINK_COLOR;
            } else {
                lineType = type != null ? type : fA.B((int)linkPresenter.getThickness(link), (byte)((byte)linkPresenter.getStyle(link)));
                lineColor = color != null ? color : linkPresenter.getColor(link);
            }
            er.setLineColor(lineColor);
            er.setLineType(lineType);
            GA label = er.getLabel();
            if (label != null) {
                label.setTextColor(lineColor);
            }
            BA sr = realizers.getSourceRealizer();
            BA tr = realizers.getTargetRealizer();
            this.addDirtyArea(new Rectangle2D.Double(sr.getX() - 1.0, sr.getY() - 1.0, sr.getWidth() + 2.0, sr.getHeight() + 2.0));
            this.addDirtyArea(new Rectangle2D.Double(tr.getX() - 1.0, tr.getY() - 1.0, tr.getWidth() + 2.0, tr.getHeight() + 2.0));
        }
    }

    public void mouseMoved(double x2, double y2) {
        super.mouseMoved(x2, y2);
        MC info = this.getHitInfo(x2, y2);
        if (info != null) {
            if (info.B()) {
                this.setHoveredNode(info.V());
            } else if (info.X()) {
                this.setHoveredEdge(info.T());
            } else {
                this.setHoveredEdge(null);
                this.setHoveredNode(null);
            }
        } else {
            this.setHoveredEdge(null);
            this.setHoveredNode(null);
        }
        this.repaint();
    }

    public void disconnect(SA graph) {
        graph.B((yguard.A.J._)this._selectionListener);
        graph.B((_)this._selectionListener);
    }

    public void connect(SA graph) {
        graph.A((yguard.A.J._)this._selectionListener);
        graph.A((_)this._selectionListener);
    }

    private void repaint() {
        if (this._dirtyArea != null) {
            this.view.updateView(this._dirtyArea);
            this._dirtyArea = null;
        }
    }

    private void addDirtyArea(Rectangle2D area) {
        if (this._dirtyArea == null) {
            this._dirtyArea = area.getBounds2D();
        } else {
            this._dirtyArea.add(area);
        }
    }

    protected MC getHitInfo(double x2, double y2) {
        return HitInfoCache.getDefault().getStandardHitInfo(this.view, x2, y2);
    }

    private static class Realizers {
        private final q _edgeRealizer;
        private final BA _sourceRealizer;
        private final BA _targetRealizer;

        public Realizers(q edgeRealizer, BA sourceRealizer, BA targetRealizer) {
            this._edgeRealizer = edgeRealizer;
            this._sourceRealizer = sourceRealizer;
            this._targetRealizer = targetRealizer;
        }

        public q getEdgeRealizer() {
            return this._edgeRealizer;
        }

        public BA getSourceRealizer() {
            return this._sourceRealizer;
        }

        public BA getTargetRealizer() {
            return this._targetRealizer;
        }
    }

    private class MyListener
    extends Y._D {
        private int _eventDepth = 0;
        private boolean _inDeleteTransaction = false;

        private MyListener() {
        }

        protected void updateSelectionState(SA graph) {
            if (!this._inDeleteTransaction) {
                this.smartUpdateSelectionState(graph);
            }
        }

        public void onGraphEvent(C ge) {
            this.handle(ge);
            super.onGraphEvent(ge);
        }

        private void handle(C evt) {
            switch (evt.C()) {
                case 5: {
                    if (this._eventDepth <= 0) break;
                    this._inDeleteTransaction = true;
                    break;
                }
                case 3: {
                    if (this._eventDepth <= 0) break;
                    this._inDeleteTransaction = true;
                    break;
                }
                case 12: {
                    ++this._eventDepth;
                    break;
                }
                case 13: {
                    --this._eventDepth;
                    if (this._eventDepth > 0 || !this._inDeleteTransaction) break;
                    this._eventDepth = 0;
                    this._inDeleteTransaction = false;
                    this.updateSelectionState((SA)evt.B());
                }
            }
        }

        protected void smartUpdateSelectionState(SA graph) {
            try {
                LinkHighlighter.this.setSelectedNodes(graph.\u0108());
                LinkHighlighter.this.repaint();
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

