/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.preferences.RelPaths;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.BaseUtilities;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.io.NbObjectInputStream;

final class BinaryFS
extends FileSystem
implements DataInput {
    static final Logger LOG = Logger.getLogger(BinaryFS.class.getName());
    static final byte[] MAGIC = "org.netbeans.core.projects.cache.BinaryV6".getBytes();
    static final FileObject[] NO_CHILDREN = new FileObject[0];
    String binaryFile;
    ByteBuffer content;
    private FileObject root;
    private final List<String> urls;
    private final List<Long> modifications;
    private final Date lastModified = new Date(Stamps.getModulesJARs().lastModified());
    private final Map<Integer, String> texts;
    private final ByteBuffer strings;

    private void _setSystemName(String s) throws PropertyVetoException {
        this.setSystemName(s);
    }

    public BinaryFS(String binaryFile, ByteBuffer buff) throws IOException {
        try {
            this._setSystemName("BinaryFS" + binaryFile.replace('/', '-').replace(File.separatorChar, '-'));
        }
        catch (PropertyVetoException ex) {
            throw new IOException(ex);
        }
        LayerCacheManager.err.log(Level.FINE, "Reading {0} buffer: {1}", new Object[]{binaryFile, buff.limit()});
        this.binaryFile = binaryFile;
        byte[] magic = new byte[MAGIC.length];
        buff.get(magic);
        if (!Arrays.equals(magic, MAGIC)) {
            throw new IOException("Bad magic header: " + new String(magic));
        }
        long storedLen = buff.getInt();
        if ((long)buff.limit() != storedLen) {
            throw new IOException("Corrupted image, correct length=" + storedLen + ", found=" + buff.limit());
        }
        LayerCacheManager.err.log(Level.FINER, "Stored Len OK: {0}", storedLen);
        int strLen = buff.getInt();
        this.texts = new HashMap<Integer, String>();
        this.strings = buff.slice().asReadOnlyBuffer();
        buff.position(buff.position() + strLen);
        int stop = buff.getInt() + 8 + MAGIC.length + strLen + 4;
        this.urls = new ArrayList<String>();
        ArrayList<Object> _modifications = new ArrayList<Object>();
        while (buff.position() < stop) {
            this.urls.add(BinaryFS.toAbsoluteURL(this.getString(buff)));
            _modifications.add(null);
        }
        this.modifications = Collections.synchronizedList(_modifications);
        this.content = buff.slice().order(ByteOrder.LITTLE_ENDIAN);
        LayerCacheManager.err.log(Level.FINER, "Reading root");
        this.root = new BFSFolder("", null, 0);
        LayerCacheManager.err.log(Level.FINER, "Root ready: {0}", this.root);
    }

    public FileObject findResource(String name) {
        String next;
        FileObject fo;
        if (name.length() == 0) {
            return this.root;
        }
        StringTokenizer st = new StringTokenizer(name, "/");
        for (fo = this.root; fo != null && st.hasMoreTokens(); fo = fo.getFileObject(next, null)) {
            next = st.nextToken();
        }
        return fo;
    }

    public String getDisplayName() {
        return "BinaryFS[" + this.binaryFile + "]";
    }

    public FileObject getRoot() {
        return this.root;
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String getString(ByteBuffer buffer) throws IOException {
        ByteBuffer byteBuffer = this.strings;
        synchronized (byteBuffer) {
            int offset = buffer.getInt();
            String t = this.texts.get(offset);
            if (t != null) {
                return t;
            }
            this.strings.position(offset);
            String s = DataInputStream.readUTF(this);
            this.texts.put(offset, s);
            return s;
        }
    }

    private static String toAbsoluteURL(String relURL) {
        if (relURL.startsWith("home@")) {
            return BinaryFS.toJarURI(System.getProperty("netbeans.home")) + relURL.substring(5);
        }
        if (relURL.startsWith("user@")) {
            return BinaryFS.toJarURI(System.getProperty("netbeans.user")) + relURL.substring(5);
        }
        if (relURL.startsWith("abs@")) {
            return "jar:file:" + relURL.substring(4);
        }
        int indx = relURL.indexOf(64);
        if (indx == -1) {
            return relURL;
        }
        int cluster = Integer.parseInt(relURL.substring(0, indx));
        return BinaryFS.toJarURI(RelPaths.cluster(cluster)) + relURL.substring(indx + 1);
    }

    private static String toJarURI(String path) {
        class DirFile
        extends File {
            public DirFile(String pathname) {
                super(pathname);
            }

            @Override
            public boolean isDirectory() {
                return true;
            }

            @Override
            public boolean isFile() {
                return false;
            }

            @Override
            public File getAbsoluteFile() {
                return this;
            }
        }
        String ret = "jar:" + BaseUtilities.toURI((File)new DirFile(path)).toString();
        assert (!ret.contains("//")) : ret;
        return ret;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        Thread.holdsLock(this.strings);
        this.strings.get(b, off, len);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        Thread.holdsLock(this.strings);
        int ch1 = this.strings.get();
        if (ch1 < 0) {
            ch1 += 256;
        }
        if ((ch2 = this.strings.get()) < 0) {
            ch2 += 256;
        }
        return (ch1 << 8) + ch2;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        throw new IOException();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new IOException();
    }

    @Override
    public boolean readBoolean() throws IOException {
        throw new IOException();
    }

    @Override
    public byte readByte() throws IOException {
        throw new IOException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new IOException();
    }

    @Override
    public short readShort() throws IOException {
        throw new IOException();
    }

    @Override
    public char readChar() throws IOException {
        throw new IOException();
    }

    @Override
    public int readInt() throws IOException {
        throw new IOException();
    }

    @Override
    public long readLong() throws IOException {
        throw new IOException();
    }

    @Override
    public float readFloat() throws IOException {
        throw new IOException();
    }

    @Override
    public double readDouble() throws IOException {
        throw new IOException();
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new IOException();
    }

    static final Map wrapToMap(FileObject fo) {
        return fo == null ? Collections.emptyMap() : new FileMap(fo);
    }

    private static final class FOEntry
    implements Map.Entry<String, Object> {
        private FileObject fo;
        private String attr;

        private FOEntry(FileObject fo, String attr) {
            this.fo = fo;
            this.attr = attr;
        }

        @Override
        public String getKey() {
            return this.attr;
        }

        @Override
        public Object getValue() {
            return this.fo.getAttribute(this.attr);
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class AttrFileSet
    extends AbstractSet<Map.Entry<String, Object>> {
        private FileObject fo;

        private AttrFileSet(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            class Iter
            implements Iterator<Map.Entry<String, Object>> {
                Enumeration<String> attrs;

                Iter() {
                    this.attrs = AttrFileSet.this.fo.getAttributes();
                }

                @Override
                public boolean hasNext() {
                    return this.attrs.hasMoreElements();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    String s = this.attrs.nextElement();
                    return new FOEntry(AttrFileSet.this.fo, s);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new Iter();
        }

        @Override
        public int size() {
            Enumeration all = this.fo.getAttributes();
            int cnt = 0;
            while (all.hasMoreElements()) {
                ++cnt;
                all.nextElement();
            }
            return cnt;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class FileMap
    extends AbstractMap<String, Object> {
        private FileObject fo;

        private FileMap(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AttrFileSet(this.fo);
        }

        @Override
        public Object get(Object key) {
            if (key == FileObject.class) {
                return this.fo;
            }
            return key instanceof String ? this.fo.getAttribute((String)key) : null;
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map)) {
                return false;
            }
            Object o = ((Map)obj).get(FileObject.class);
            if (o != null) {
                return this.fo.equals(o);
            }
            return obj.equals(this);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.fo != null ? this.fo.hashCode() : 0);
            return hash;
        }

        @Override
        public String toString() {
            return "BinaryFileMap@" + Integer.toHexString(System.identityHashCode(this)) + "{fo=" + this.fo + '}';
        }
    }

    private class BFSFolder
    extends BFSBase {
        Map<String, BFSBase> childrenMap;

        public BFSFolder(String name, FileObject parent, int offset) {
            super(name, parent, offset);
            this.childrenMap = Collections.emptyMap();
        }

        public boolean isData() {
            return false;
        }

        public boolean isFolder() {
            return true;
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException("Is a directory: " + (Object)((Object)this));
        }

        public FileObject[] getChildren() {
            this.initialize();
            return this.childrenMap.values().toArray(NO_CHILDREN);
        }

        public FileObject getFileObject(String name, String ext) {
            if ("..".equals(name) && ext == null) {
                return this.getParent();
            }
            this.initialize();
            String fullName = ext == null ? name : name + "." + ext;
            return this.childrenMap.get(fullName);
        }

        @Override
        protected void doInitialize(ByteBuffer sub) throws Exception {
            int files = sub.getInt();
            if (files > 0) {
                HashMap<String, BFSBase> map = new HashMap<String, BFSBase>(files * 4 / 3 + 1);
                for (int i = 0; i < files; ++i) {
                    String nm = BinaryFS.this.getString(sub);
                    byte isFolder = sub.get();
                    int off = sub.getInt();
                    map.put(nm, isFolder == 0 ? new BFSFile(nm, this, off) : new BFSFolder(nm, this, off));
                }
                this.childrenMap = map;
                if (LayerCacheManager.err.isLoggable(Level.FINEST)) {
                    LayerCacheManager.err.log(Level.FINEST, "  children for " + this.getPath() + " are: " + this.childrenMap.keySet());
                }
            }
        }

        @Override
        protected boolean specificEquals(BFSBase _f) {
            if (!(_f instanceof BFSFolder)) {
                return false;
            }
            BFSFolder f = (BFSFolder)_f;
            this.initialize();
            return this.childrenMap.equals(f.childrenMap);
        }
    }

    final class BFSFile
    extends BFSBase {
        private int len;
        private int size;
        private int contentOffset;
        private String uri;

        public BFSFile(String name, FileObject parent, int offset) {
            super(name, parent, offset);
            this.size = -1;
        }

        public FileObject[] getChildren() {
            return NO_CHILDREN;
        }

        public FileObject getFileObject(String name, String ext) {
            return null;
        }

        public boolean isData() {
            return true;
        }

        public boolean isFolder() {
            return false;
        }

        private byte[] data() throws IOException {
            if (this.len == -1) {
                throw new IllegalArgumentException();
            }
            byte[] data = new byte[this.len];
            ((ByteBuffer)BinaryFS.this.content.duplicate().position(this.contentOffset)).get(data);
            return data;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            this.initialize();
            try {
                return this.len == -1 ? new URL(this.uri).openConnection().getInputStream() : new ByteArrayInputStream(this.data());
            }
            catch (Exception e) {
                throw (FileNotFoundException)new FileNotFoundException("Cannot find '" + this.uri + "'").initCause(e);
            }
        }

        public long getSize() {
            this.initialize();
            try {
                if (this.len == -1) {
                    if (this.size == -1) {
                        this.size = new URL(this.uri).openConnection().getContentLength();
                    }
                    return this.size;
                }
                return this.len;
            }
            catch (Exception e) {
                System.err.println("exception in getSize() on " + this.name + ": " + e);
                return 0L;
            }
        }

        @Override
        public Date lastModified() {
            this.initialize();
            try {
                long date;
                int index = -1;
                URLConnection conn = null;
                if (this.len == -1) {
                    if (this.uri.startsWith("jar:")) {
                        return super.lastModified();
                    }
                    conn = new URL(this.uri).openConnection();
                } else {
                    String url;
                    ByteBuffer sub = (ByteBuffer)BinaryFS.this.content.duplicate().order(ByteOrder.LITTLE_ENDIAN).position(this.offset);
                    index = sub.getInt();
                    if (index <= -10) {
                        index = -(index + 10);
                    }
                    if ((url = (String)BinaryFS.this.urls.get(index)).startsWith("jar:")) {
                        return super.lastModified();
                    }
                    Long obj = (Long)BinaryFS.this.modifications.get(index);
                    if (obj != null) {
                        return new Date(obj);
                    }
                    conn = new URL(url).openConnection();
                }
                if (conn != null && (date = conn.getLastModified()) > 0L) {
                    if (index >= 0) {
                        BinaryFS.this.modifications.set(index, date);
                    }
                    return new Date(date);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, null, e);
            }
            return super.lastModified();
        }

        @Override
        protected void doInitialize(ByteBuffer sub) throws Exception {
            this.len = sub.getInt();
            this.contentOffset = sub.position();
            if (this.len == -1) {
                this.uri = BinaryFS.toAbsoluteURL(BinaryFS.this.getString(sub));
            } else {
                sub.position(this.contentOffset + this.len);
            }
        }

        @Override
        protected boolean specificEquals(BFSBase _f) {
            if (!(_f instanceof BFSFile)) {
                return false;
            }
            BFSFile f = (BFSFile)_f;
            this.initialize();
            f.initialize();
            if (this.len == -1 && f.len == -1) {
                return this.uri.equals(f.uri);
            }
            if (this.len != -1 && f.len != -1) {
                byte[] fdata;
                byte[] data;
                try {
                    data = this.data();
                    fdata = f.data();
                }
                catch (IOException ioe) {
                    return false;
                }
                if (data.length != fdata.length) {
                    return false;
                }
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == fdata[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    static final class AttrImpl {
        private int index;
        private String value;
        private static final Set<String> notified = Collections.synchronizedSet(new HashSet());

        AttrImpl(int type, String textValue) {
            this.index = type;
            this.value = textValue;
        }

        public boolean equals(Object o) {
            if (o instanceof AttrImpl) {
                AttrImpl impl = (AttrImpl)o;
                return this.index == impl.index && this.value.equals(impl.value);
            }
            return false;
        }

        public int hashCode() {
            return 2343 + this.index + this.value.hashCode();
        }

        public Object getValue(BFSBase foProvider, String attrName) {
            try {
                switch (this.index) {
                    case 0: {
                        return Byte.valueOf(this.value);
                    }
                    case 1: {
                        return Short.valueOf(this.value);
                    }
                    case 2: {
                        return Integer.valueOf(this.value);
                    }
                    case 3: {
                        return Long.valueOf(this.value);
                    }
                    case 4: {
                        return Float.valueOf(this.value);
                    }
                    case 5: {
                        return Double.valueOf(this.value);
                    }
                    case 6: {
                        return Boolean.valueOf(this.value);
                    }
                    case 7: {
                        if (this.value.trim().length() != 1) break;
                        return Character.valueOf(this.value.charAt(0));
                    }
                    case 8: {
                        return this.value;
                    }
                    case 9: {
                        return new URL(this.value);
                    }
                    case 10: {
                        return this.methodValue(this.value, foProvider, attrName).invoke();
                    }
                    case 11: {
                        Class<?> cls = this.findClass(this.value);
                        if (SharedClassObject.class.isAssignableFrom(cls)) {
                            return SharedClassObject.findObject(cls.asSubclass(SharedClassObject.class), (boolean)true);
                        }
                        Constructor<?> init = cls.getDeclaredConstructor(new Class[0]);
                        init.setAccessible(true);
                        return init.newInstance(null);
                    }
                    case 12: {
                        return this.decodeValue(this.value);
                    }
                    case 13: {
                        String[] arr = this.value.split("#", 2);
                        return NbBundle.getBundle((String)arr[0]).getObject(arr[1]);
                    }
                    default: {
                        throw new IllegalStateException("Bad index: " + this.index);
                    }
                }
            }
            catch (Exception exc) {
                LOG.log(notified.add(foProvider.getPath()) ? Level.INFO : Level.FINE, "value = " + this.value + " from " + foProvider.getPath(), exc);
            }
            return null;
        }

        public Class<?> getType(BFSBase foProvider) {
            try {
                switch (this.index) {
                    case 0: {
                        return Byte.class;
                    }
                    case 1: {
                        return Short.class;
                    }
                    case 2: {
                        return Integer.class;
                    }
                    case 3: {
                        return Long.class;
                    }
                    case 4: {
                        return Float.class;
                    }
                    case 5: {
                        return Double.class;
                    }
                    case 6: {
                        return Boolean.class;
                    }
                    case 7: {
                        return Character.class;
                    }
                    case 8: {
                        return String.class;
                    }
                    case 9: {
                        return URL.class;
                    }
                    case 10: {
                        return this.methodValue(this.value, foProvider, null).getMethod().getReturnType();
                    }
                    case 11: {
                        return this.findClass(this.value);
                    }
                    case 12: {
                        return null;
                    }
                    case 13: {
                        return String.class;
                    }
                }
                throw new IllegalStateException("Bad index: " + this.index);
            }
            catch (Exception exc) {
                Exceptions.attachMessage((Throwable)exc, (String)("value = " + this.value + " from " + foProvider.getPath()));
                LOG.log(notified.add(foProvider.getPath()) ? Level.INFO : Level.FINE, null, exc);
                return null;
            }
        }

        private MethodAndParams methodValue(String method, BFSBase foProvider, String attr) throws Exception {
            int i = method.lastIndexOf(46);
            if (i != -1) {
                Class[][] paramArray;
                Class<?> cls = this.findClass(method.substring(0, i));
                String methodName = method.substring(i + 1);
                for (Class[] paramTypes : paramArray = new Class[][]{{FileObject.class, String.class}, {String.class, FileObject.class}, {FileObject.class}, {String.class}, new Class[0], {Map.class, String.class}, {Map.class}}) {
                    Method m;
                    try {
                        m = cls.getDeclaredMethod(methodName, paramTypes);
                    }
                    catch (NoSuchMethodException x) {
                        continue;
                    }
                    Object[] values = new Object[paramTypes.length];
                    for (int j = 0; j < paramTypes.length; ++j) {
                        if (paramTypes[j] == FileObject.class) {
                            values[j] = foProvider.getFileObjectForAttr();
                            continue;
                        }
                        if (paramTypes[j] == String.class) {
                            values[j] = attr;
                            continue;
                        }
                        assert (paramTypes[j] == Map.class);
                        values[j] = BinaryFS.wrapToMap(foProvider.getFileObjectForAttr());
                    }
                    return new MethodAndParams(m, values);
                }
            }
            throw new InstantiationException(method);
        }

        private Object decodeValue(String value) throws Exception {
            if (value == null || value.length() == 0) {
                return null;
            }
            byte[] bytes = new byte[value.length() / 2];
            int count = 0;
            for (int i = 0; i < value.length(); i += 2) {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
            return new NbObjectInputStream((InputStream)bis).readObject();
        }

        private Class<?> findClass(String name) throws ClassNotFoundException {
            ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            String tname = BaseUtilities.translate((String)name);
            try {
                if (c == null) {
                    return Class.forName(tname);
                }
                return Class.forName(tname, true, c);
            }
            catch (LinkageError err) {
                throw new ClassNotFoundException("Cannot read " + name, err);
            }
        }

        private static class MethodAndParams {
            private Method method;
            private Object[] params;

            MethodAndParams(Method method, Object[] params) {
                this.method = method;
                this.params = params;
            }

            public Object invoke() throws Exception {
                this.method.setAccessible(true);
                return this.method.invoke(null, this.params);
            }

            public Method getMethod() {
                return this.method;
            }
        }
    }

    private abstract class BFSBase
    extends FileObject {
        private final FileObject parent;
        protected final String name;
        protected final int offset;
        private boolean initialized = false;
        private Map<String, AttrImpl> attrs = Collections.emptyMap();

        public BFSBase(String name, FileObject parent, int offset) {
            this.name = name;
            this.parent = parent;
            this.offset = offset;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof BFSBase)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            BFSBase f = (BFSBase)((Object)o);
            return f.getPath().equals(this.getPath()) && this.specificEquals(f) && this.attributeEquals(f);
        }

        private final boolean attributeEquals(BFSBase base) {
            this.initialize();
            base.initialize();
            return this.attrs.equals(base.attrs);
        }

        public final int hashCode() {
            return this.getPath().hashCode();
        }

        protected abstract boolean specificEquals(BFSBase var1);

        public void addFileChangeListener(FileChangeListener fcl) {
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
        }

        @Deprecated
        public boolean isReadOnly() {
            return true;
        }

        @Deprecated
        public void setImportant(boolean b) {
        }

        public FileObject createData(String name, String ext) throws IOException {
            throw new IOException();
        }

        public FileObject createFolder(String name) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock lock) throws IOException {
            throw new IOException();
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new IOException();
        }

        public FileLock lock() throws IOException {
            throw new IOException();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new IOException();
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            throw new IOException();
        }

        public FileSystem getFileSystem() {
            return BinaryFS.this;
        }

        public FileObject getParent() {
            return this.parent;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isValid() {
            return true;
        }

        public Date lastModified() {
            return BinaryFS.this.lastModified;
        }

        public String getName() {
            int i = this.name.lastIndexOf(46);
            return i <= 0 ? this.name : this.name.substring(0, i);
        }

        public String getExt() {
            int i = this.name.lastIndexOf(46) + 1;
            return i <= 1 || i == this.name.length() ? "" : this.name.substring(i);
        }

        public String getNameExt() {
            return this.name;
        }

        public Object getAttribute(String attrName) {
            this.initialize();
            AttrImpl attr = this.attrs.get(attrName);
            if (attr == null && attrName.startsWith("class:")) {
                attr = this.attrs.get(attrName.substring(6));
                return attr == null ? null : attr.getType(this);
            }
            if (attr == null && attrName.startsWith("raw:")) {
                attr = this.attrs.get(attrName.substring(4));
                try {
                    if (attr != null && attr.index == 10) {
                        return attr.methodValue(attr.value, this, attrName).getMethod();
                    }
                    if (attr != null && attr.index == 11) {
                        return attr.getType(this);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            if (attr == null && attrName.equals("layers")) {
                return this.getLayersAttr();
            }
            return attr != null ? attr.getValue(this, attrName) : null;
        }

        public FileObject getFileObjectForAttr() {
            FileObject topFO = null;
            try {
                Class<?> mfoClass = Class.forName("org.openide.filesystems.MultiFileObject");
                Field field = mfoClass.getDeclaredField("attrAskedFileObject");
                field.setAccessible(true);
                ThreadLocal attrAskedFileObject = (ThreadLocal)ThreadLocal.class.cast(field.get(null));
                topFO = (FileObject)attrAskedFileObject.get();
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return topFO == null ? this : topFO;
        }

        public Enumeration<String> getAttributes() {
            this.initialize();
            if (this.attrs == null) {
                return Enumerations.empty();
            }
            return Collections.enumeration(this.attrs.keySet());
        }

        protected final void initialize() {
            if (this.initialized) {
                return;
            }
            try {
                int attrCount;
                ByteBuffer sub = (ByteBuffer)BinaryFS.this.content.duplicate().order(ByteOrder.LITTLE_ENDIAN).position(this.offset);
                if (!this.isRoot()) {
                    while (sub.getInt() >= 0) {
                    }
                }
                if ((attrCount = sub.getInt()) > 0) {
                    this.attrs = new HashMap<String, AttrImpl>(attrCount * 4 / 3 + 1);
                }
                for (int i = 0; i < attrCount; ++i) {
                    String attrName = BinaryFS.this.getString(sub);
                    byte type = sub.get();
                    String value = BinaryFS.this.getString(sub);
                    this.attrs.put(attrName, new AttrImpl(type, value));
                }
                this.doInitialize(sub);
            }
            catch (Exception e) {
                System.err.println("exception in initialize() on " + this.name + ": " + e);
            }
            this.initialized = true;
        }

        protected abstract void doInitialize(ByteBuffer var1) throws Exception;

        private Object getLayersAttr() {
            ArrayList<URL> ret = new ArrayList<URL>();
            if (this.isRoot()) {
                for (String u : BinaryFS.this.urls) {
                    try {
                        ret.add(new URL(u));
                    }
                    catch (MalformedURLException ex) {
                        LOG.warning("Cannot create URL: " + u);
                    }
                }
            } else {
                ByteBuffer sub = (ByteBuffer)BinaryFS.this.content.duplicate().order(ByteOrder.LITTLE_ENDIAN).position(this.offset);
                boolean cont = true;
                while (cont) {
                    int index = sub.getInt();
                    if (index < 0) {
                        cont = false;
                    }
                    if (index <= -10) {
                        index = -(index + 10);
                    }
                    try {
                        ret.add(new URL((String)BinaryFS.this.urls.get(index)));
                    }
                    catch (MalformedURLException ex) {
                        LOG.warning("Cannot create URL: " + (String)BinaryFS.this.urls.get(index));
                    }
                }
            }
            return ret.toArray(new URL[ret.size()]);
        }
    }
}

