/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.lucene.serialize.NumericTypeConverter;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.NumericUtils;

class DoubleConverter
extends NumericTypeConverter<Double> {
    private static final Double MIN_SORT_VALUE = Double.MIN_VALUE;
    private static final Double MAX_SORT_VALUE = Double.MAX_VALUE;

    public DoubleConverter() {
        super("double", Double.class, Double.TYPE, SortField.Type.DOUBLE);
    }

    @Override
    IndexableField createNumberField(Double value, String fieldName) {
        return new DoubleField(fieldName, value.doubleValue(), Field.Store.YES);
    }

    @Override
    long toSortableLong(Double value) {
        return NumericUtils.doubleToSortableLong((double)value);
    }

    @Override
    protected Double getMinSortField() {
        return MIN_SORT_VALUE;
    }

    @Override
    protected Double getMaxSortField() {
        return MAX_SORT_VALUE;
    }

    @Override
    Double toType(Number number) {
        return number.doubleValue();
    }
}

