/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.xmpp.ReplayDetectedException;
import com.paterva.maltego.collab.session.xmpp.WrongVersionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.jivesoftware.smack.util.StringUtils;

abstract class PayloadEncoder {
    private static final String ENCODING = "UTF-8";

    PayloadEncoder() {
    }

    public abstract String encode(String var1) throws CollaborationException;

    public abstract String decode(String var1) throws CollaborationException, GeneralSecurityException, WrongVersionException, ReplayDetectedException;

    public static class Base64
    extends PayloadEncoder {
        @Override
        public String encode(String xml) throws CollaborationException {
            return StringUtils.encodeBase64((String)xml);
        }

        @Override
        public String decode(String data) throws CollaborationException {
            try {
                return new String(StringUtils.decodeBase64((String)data), PayloadEncoder.ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                throw new CollaborationException(ex, true);
            }
        }
    }

    public static class Stream
    extends PayloadEncoder {
        private static final SecureRandom _rand = new SecureRandom();
        private char[] _password;
        private byte[] _salt = new byte[]{-12, 45, -84, 18, -73, -103, -70, -125};
        private int _keySize;
        private int _version;
        private int _reserved;
        private int _sequenceNumber;
        private int _userNumber;
        private Map<Integer, Integer> _lastUserSeqNumbers = new HashMap<Integer, Integer>();
        private static final boolean TEST_REPLAY = false;
        private int _testReplay = 0;

        public Stream(char[] password, boolean use256Encryption, int version, int reserved) {
            this._password = password;
            this._keySize = use256Encryption ? 256 : 128;
            this.checkRange("version", version, 0, 31);
            this._version = version;
            this.checkRange("reserved", reserved, 0, 7);
            this._reserved = reserved;
            this._sequenceNumber = _rand.nextInt();
            this._userNumber = _rand.nextInt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String encode(String xml) throws CollaborationException {
            DeflaterOutputStream gzip = null;
            ByteArrayOutputStream os = null;
            try {
                os = new ByteArrayOutputStream();
                try {
                    InputStream is = IOUtils.toInputStream(xml, PayloadEncoder.ENCODING);
                    gzip = new DeflaterOutputStream(os);
                    IOUtils.copy(is, (OutputStream)gzip);
                }
                finally {
                    if (gzip != null) {
                        gzip.close();
                    }
                }
                byte[] compressed = os.toByteArray();
                byte[] replayProtected = this.addUserAndSequenceNumber(compressed);
                byte[] encrypted = this.encrypt(replayProtected);
                byte[] versioned = this.addVersion(encrypted);
                String string = StringUtils.encodeBase64((byte[])versioned);
                return string;
            }
            catch (IOException ex) {
                throw new CollaborationException(ex, true);
            }
            catch (GeneralSecurityException ex) {
                throw new CollaborationException(ex, false);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ex) {
                    throw new CollaborationException(ex, true);
                }
            }
        }

        @Override
        public String decode(String data) throws CollaborationException, GeneralSecurityException, WrongVersionException, ReplayDetectedException {
            InflaterInputStream gzip = null;
            try {
                byte[] versioned = StringUtils.decodeBase64((String)data);
                byte[] encrypted = this.checkVersion(versioned);
                byte[] replayProtected = this.decrypt(encrypted);
                byte[] compressed = this.checkUserAndSequenceNumber(replayProtected);
                ByteArrayInputStream is = new ByteArrayInputStream(compressed);
                gzip = new InflaterInputStream(is);
                String xml = IOUtils.toString((InputStream)gzip, PayloadEncoder.ENCODING);
                this.checkValidXml(xml);
                String string = xml;
                return string;
            }
            catch (IOException ex) {
                throw new CollaborationException(ex, true);
            }
            finally {
                try {
                    if (gzip != null) {
                        gzip.close();
                    }
                }
                catch (IOException ex) {
                    throw new CollaborationException(ex, true);
                }
            }
        }

        private byte[] encrypt(byte[] plainText) throws GeneralSecurityException {
            SecretKey secret = this.getSecretKey();
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] cipherText = cipher.doFinal(plainText);
            return ArrayUtils.addAll((byte[])iv, (byte[])cipherText);
        }

        private byte[] decrypt(byte[] ivAndCipherText) throws GeneralSecurityException {
            byte[] iv = Arrays.copyOf(ivAndCipherText, 16);
            byte[] cipherText = Arrays.copyOfRange(ivAndCipherText, 16, ivAndCipherText.length);
            SecretKey secret = this.getSecretKey();
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return cipher.doFinal(cipherText);
        }

        private SecretKey getSecretKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(this._password, this._salt, 65536, this._keySize);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            return secret;
        }

        private byte[] addVersion(byte[] encrypt) {
            byte[] reservedAndVersion = new byte[1];
            int reserved2bits = this._reserved << 5 & 0xE0;
            int version4bits = this._version & 0x1F;
            reservedAndVersion[0] = (byte)(reserved2bits | version4bits);
            return ArrayUtils.addAll((byte[])reservedAndVersion, (byte[])encrypt);
        }

        private void checkRange(String varName, int value, int min, int max) {
            if (value < min || value > max) {
                throw new IllegalArgumentException(String.format("%s is %d, but must be between %d and %d", varName, value, min, max));
            }
        }

        private byte[] checkVersion(byte[] versionIvAndCipherText) throws WrongVersionException {
            byte reservedAndVersion = versionIvAndCipherText[0];
            int version = reservedAndVersion & 0x1F;
            if (version > this._version) {
                throw new WrongVersionException(false);
            }
            byte[] cipherText = Arrays.copyOfRange(versionIvAndCipherText, 1, versionIvAndCipherText.length);
            return cipherText;
        }

        private byte[] addUserAndSequenceNumber(byte[] compressed) {
            byte[] userAndSeqNum = ByteBuffer.allocate(8).putInt(this._userNumber).putInt(this._sequenceNumber).array();
            ++this._sequenceNumber;
            return ArrayUtils.addAll((byte[])userAndSeqNum, (byte[])compressed);
        }

        private byte[] checkUserAndSequenceNumber(byte[] replyProtected) throws ReplayDetectedException {
            byte[] userAndSeqNum = Arrays.copyOf(replyProtected, 8);
            ByteBuffer bytes = ByteBuffer.wrap(userAndSeqNum);
            int userNum = bytes.getInt();
            int seqNum = bytes.getInt();
            Integer lastSeqNum = this._lastUserSeqNumbers.get(userNum);
            if (lastSeqNum != null) {
                boolean isReplay = true;
                for (int i = 0; i < 20 && isReplay; ++i) {
                    if (lastSeqNum + i == seqNum) continue;
                    isReplay = false;
                }
                if (isReplay) {
                    throw new ReplayDetectedException("Message replay detected.", false);
                }
            }
            this._lastUserSeqNumbers.put(userNum, seqNum);
            byte[] compressed = Arrays.copyOfRange(replyProtected, 8, replyProtected.length);
            return compressed;
        }

        private void checkValidXml(String xml) throws CollaborationException {
            String xmlExtract = xml.substring(0, Math.min(20, xml.length())).replaceAll("\\s", "");
            if (!xmlExtract.matches("^<mtg>.*$")) {
                String msg = String.format("Payload does not contain valid xml: (%s)", xmlExtract);
                throw new CollaborationException(msg, false);
            }
        }
    }

    public static class None
    extends PayloadEncoder {
        @Override
        public String encode(String xml) throws CollaborationException {
            return xml;
        }

        @Override
        public String decode(String data) throws CollaborationException, GeneralSecurityException, WrongVersionException, ReplayDetectedException {
            return data;
        }
    }
}

