/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runviews.ctxmenu;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.runviews.list.RootRunProviderTreeListItem;
import com.paterva.maltego.ui.graph.view2d.HitInfoCache;
import com.paterva.maltego.util.ui.ctxmenu.ContextMenuActionsProvider;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupManager;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import yguard.A.A.Y;
import yguard.A.J.MC;
import yguard.A.J.SA;
import yguard.A.J.mB;

public class WindowPopupMode
extends mB {
    private static final RootRunProviderTreeListItem ROOT_ITEM = new RootRunProviderTreeListItem("context-menu");

    public static RootRunProviderTreeListItem getPopupRootItem() {
        return ROOT_ITEM;
    }

    public void mousePressed(MouseEvent e) {
        SA graph = this.view.getGraph2D();
        GraphID graphID = GraphIDProvider.forGraph((SA)graph);
        this.checkNodeHit(e, graphID);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        Set selectedModelEntities = selection.getSelectedModelEntities();
        if (!selectedModelEntities.isEmpty()) {
            this.showPopup(e, selectedModelEntities);
        }
        this.reactivateParent();
    }

    private void checkNodeHit(MouseEvent e, GraphID graphID) {
        GraphWrapper wrapper;
        EntityID entityID;
        GraphSelection selection;
        MC hitInfo = this.getHitInfo(e);
        Y hitNode = hitInfo.V();
        if (hitNode != null && (selection = GraphSelection.forGraph((GraphID)graphID)).getViewSelectionState(entityID = (wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID)).entityID(hitNode)) == SelectionState.NO) {
            selection.setSelectedViewEntities(Collections.singleton(entityID));
        }
    }

    private void showPopup(MouseEvent e, Set<EntityID> entities) {
        A licenseMode = LicenseManager.A().A(false);
        if (!licenseMode.D()) {
            if (e.isShiftDown() && e.isControlDown() || licenseMode.F()) {
                JPopupMenu popup = this.createActionOnlyPopup();
                popup.show((Component)this.view, e.getX(), e.getY());
            } else {
                RootRunProviderTreeListItem rootItem = WindowPopupMode.getPopupRootItem();
                WindowPopupManager.getInstance().show(entities, (TreeListItem)rootItem, rootItem.getQuickFilter(), e);
            }
        }
    }

    protected MC getHitInfo(double x, double y) {
        MC hInfo = HitInfoCache.getDefault().getOrCreateHitInfo(this.view, x, y, true, 5);
        this.setLastHitInfo(hInfo);
        return hInfo;
    }

    private JPopupMenu createActionOnlyPopup() {
        JPopupMenu popup = new JPopupMenu();
        for (Action action : ContextMenuActionsProvider.getDefault().getActions()) {
            if (action != null) {
                SystemAction systemAction;
                String name;
                boolean add = true;
                if (action instanceof SystemAction && ((name = (systemAction = (SystemAction)action).getName()).contains("Transform") || name.contains("Machine"))) {
                    add = false;
                }
                if (!add) continue;
                if (action instanceof Presenter.Popup) {
                    popup.add(((Presenter.Popup)action).getPopupPresenter());
                    continue;
                }
                popup.add(action);
                continue;
            }
            popup.add(new JSeparator());
        }
        return popup;
    }
}

