/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.inputs;

import com.paterva.maltego.transform.runner.inputs.DisclaimerResult;
import com.paterva.maltego.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.util.NbBundle;

class DisclaimerControl
extends JPanel {
    private DisclaimerResult _result;
    private JCheckBox _accepted;
    private JTextArea _text;
    private JScrollPane _textScrollPanel;

    public DisclaimerControl(String disclaimer, DisclaimerResult accepted) {
        this.initComponents();
        disclaimer = StringEscapeUtils.unescapeJava((String)disclaimer);
        this._text.setText(disclaimer);
        Dimension size = this._text.getPreferredSize();
        String longestWord = StringUtilities.getLongestWord((String)disclaimer);
        FontMetrics fm = this._text.getFontMetrics(this._text.getFont());
        int prefWidth = fm.stringWidth(longestWord);
        Dimension d = new Dimension(Math.max(size.width, prefWidth + 20), 0);
        d.height = Math.max(size.height, (StringUtilities.getWrappedLines((JTextArea)this._text, (int)d.width) + 1) * fm.getHeight());
        this._textScrollPanel.setPreferredSize(d);
        this._result = accepted;
        this._accepted.setSelected(accepted.isAccepted());
    }

    public JScrollPane getScrollPane() {
        return this._textScrollPanel;
    }

    private void initComponents() {
        this._textScrollPanel = new JScrollPane();
        this._text = new JTextArea();
        this._accepted = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this._textScrollPanel.setBackground(new Color(255, 255, 255));
        this._textScrollPanel.setHorizontalScrollBarPolicy(31);
        this._textScrollPanel.setPreferredSize(new Dimension(600, 150));
        this._text.setEditable(false);
        this._text.setBackground(UIManager.getLookAndFeelDefaults().getColor("transform-manager-lowlight-bg"));
        this._text.setColumns(20);
        this._text.setLineWrap(true);
        this._text.setRows(5);
        this._text.setWrapStyleWord(true);
        this._text.setOpaque(false);
        this._text.setPreferredSize(new Dimension(600, 50));
        this._textScrollPanel.setViewportView(this._text);
        this.add((Component)this._textScrollPanel, "Center");
        this._accepted.setText(NbBundle.getMessage(DisclaimerControl.class, (String)"DisclaimerControl._accepted.text"));
        this._accepted.setHorizontalAlignment(4);
        this._accepted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisclaimerControl.this._acceptedActionPerformed(evt);
            }
        });
        this.add((Component)this._accepted, "South");
    }

    private void _acceptedActionPerformed(ActionEvent evt) {
        this._result.setAccepted(this._accepted.isSelected());
    }
}

