/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.treelist;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.item.AbstractRunCategoryItem;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.runner.TransformRequestProcessor;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import com.paterva.maltego.transform.runner.treelist.RunWithAllFilter;
import com.paterva.maltego.transform.runner.treelist.TransformRunItem;
import com.paterva.maltego.transform.runner.treelist.TransformSetItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class TransformCategoryItem
extends AbstractRunCategoryItem {
    private final List<? extends RunProviderItem> _children;

    public TransformCategoryItem(List<? extends RunProviderItem> children) {
        this._children = children;
    }

    public List<? extends RunProviderItem> getChildren() {
        return Collections.unmodifiableList(this._children);
    }

    public boolean canRun() {
        return true;
    }

    public void run(GraphID graphID, Set<EntityID> entities) {
        if (!entities.isEmpty()) {
            Set<TransformDefinition> transforms = this.getTransforms();
            if (!(transforms = RunWithAllFilter.filter(transforms)).isEmpty()) {
                TransformRequestProcessor.getDefault().runTransforms(transforms, null, graphID, entities, true, TransformRunOrigin.fromSetRun((String)this.getName()));
            }
        }
    }

    Set<TransformDefinition> getTransforms() {
        HashSet<TransformDefinition> transforms = new HashSet<TransformDefinition>();
        for (RunProviderItem runProviderItem : this.getChildren()) {
            TransformDefinition transform;
            if (runProviderItem instanceof TransformSetItem) {
                transforms.addAll(((TransformSetItem)runProviderItem).getTransforms());
                continue;
            }
            if (!(runProviderItem instanceof TransformRunItem) || (transform = ((TransformRunItem)runProviderItem).getTransform()) == null) continue;
            transforms.add(transform);
        }
        return transforms;
    }
}

