/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Point;
import java.awt.Rectangle;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.Range;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.util.Diagnostics;

class MarkupUtilities {
    private MarkupUtilities() {
    }

    public static BoundableRenderable findRenderable(Renderable[] renderables, Point point, boolean vertical) {
        return MarkupUtilities.findRenderable(renderables, point, 0, renderables.length, vertical);
    }

    public static BoundableRenderable findRenderable(Renderable[] renderables, int x, int y, boolean vertical) {
        return MarkupUtilities.findRenderable(renderables, x, y, 0, renderables.length, vertical);
    }

    private static BoundableRenderable findRenderable(Renderable[] renderables, Point point, int firstIndex, int length, boolean vertical) {
        return MarkupUtilities.findRenderable(renderables, point.x, point.y, firstIndex, length, vertical);
    }

    private static BoundableRenderable findRenderable(Renderable[] renderables, int x, int y, int firstIndex, int length, boolean vertical) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            Renderable r = renderables[firstIndex];
            if (!(r instanceof BoundableRenderable)) {
                return null;
            }
            BoundableRenderable br = (BoundableRenderable)r;
            Rectangle rbounds = br.getBounds();
            return rbounds.contains(x, y) ? br : null;
        }
        int middleIndex = firstIndex + length / 2;
        Renderable r = renderables[middleIndex];
        if (!(r instanceof BoundableRenderable)) {
            BoundableRenderable rleft = MarkupUtilities.findRenderable(renderables, x, y, firstIndex, middleIndex - firstIndex, vertical);
            if (rleft != null) {
                return rleft;
            }
            return MarkupUtilities.findRenderable(renderables, x, y, middleIndex + 1, length - (middleIndex - firstIndex + 1), vertical);
        }
        Rectangle rbounds = ((BoundableRenderable)r).getBounds();
        if (rbounds.contains(x, y)) {
            return (BoundableRenderable)r;
        }
        if (vertical) {
            if (y < rbounds.y) {
                return MarkupUtilities.findRenderable(renderables, x, y, firstIndex, middleIndex - firstIndex, vertical);
            }
            return MarkupUtilities.findRenderable(renderables, x, y, middleIndex + 1, length - (middleIndex - firstIndex + 1), vertical);
        }
        if (x < rbounds.x) {
            return MarkupUtilities.findRenderable(renderables, x, y, firstIndex, middleIndex - firstIndex, vertical);
        }
        return MarkupUtilities.findRenderable(renderables, x, y, middleIndex + 1, length - (middleIndex - firstIndex + 1), vertical);
    }

    public static Range findRenderables(Renderable[] renderables, Rectangle clipArea, boolean vertical) {
        return MarkupUtilities.findRenderables(renderables, clipArea, 0, renderables.length, vertical);
    }

    private static Range findRenderables(Renderable[] renderables, Rectangle clipArea, int firstIndex, int length, boolean vertical) {
        if (length == 0) {
            return new Range(0, 0);
        }
        int offset1 = MarkupUtilities.findFirstIndex(renderables, clipArea, firstIndex, length, vertical);
        int offset2 = MarkupUtilities.findLastIndex(renderables, clipArea, firstIndex, length, vertical);
        if (offset1 == -1 && offset2 == -1) {
            return new Range(0, 0);
        }
        if (offset1 == -1) {
            offset1 = firstIndex;
        }
        if (offset2 == -1) {
            offset2 = firstIndex + length - 1;
        }
        return new Range(offset1, offset2 - offset1 + 1);
    }

    private static int findFirstIndex(Renderable[] renderables, Rectangle clipArea, int index, int length, boolean vertical) {
        Diagnostics.Assert(length > 0, "length=" + length);
        if (length == 1) {
            Renderable r = renderables[index];
            if (!(r instanceof BoundableRenderable)) {
                return -1;
            }
            Rectangle rbounds = ((BoundableRenderable)r).getBounds();
            if (MarkupUtilities.intersects(rbounds, clipArea, vertical)) {
                return index;
            }
            return -1;
        }
        int middleIndex = index + length / 2;
        Renderable r = renderables[middleIndex];
        if (!(r instanceof BoundableRenderable)) {
            int leftIndex = MarkupUtilities.findFirstIndex(renderables, clipArea, index, middleIndex - index, vertical);
            if (leftIndex != -1) {
                return leftIndex;
            }
            return MarkupUtilities.findFirstIndex(renderables, clipArea, middleIndex + 1, length - (middleIndex - index + 1), vertical);
        }
        Rectangle rbounds = ((BoundableRenderable)r).getBounds();
        if (vertical) {
            int resultIdx;
            if (rbounds.y + rbounds.height < clipArea.y) {
                int newLen = length - (middleIndex - index + 1);
                return newLen == 0 ? -1 : MarkupUtilities.findFirstIndex(renderables, clipArea, middleIndex + 1, newLen, vertical);
            }
            int newLen = middleIndex - index;
            int n = resultIdx = newLen == 0 ? -1 : MarkupUtilities.findFirstIndex(renderables, clipArea, index, newLen, vertical);
            if (resultIdx == -1 && MarkupUtilities.intersects(clipArea, rbounds, vertical)) {
                return middleIndex;
            }
            return resultIdx;
        }
        if (rbounds.x + rbounds.width < clipArea.x) {
            return MarkupUtilities.findFirstIndex(renderables, clipArea, middleIndex + 1, length - (middleIndex - index), vertical);
        }
        int resultIdx = MarkupUtilities.findFirstIndex(renderables, clipArea, index, middleIndex - index, vertical);
        if (resultIdx == -1 && MarkupUtilities.intersects(clipArea, rbounds, vertical)) {
            return middleIndex;
        }
        return resultIdx;
    }

    private static int findLastIndex(Renderable[] renderables, Rectangle clipArea, int index, int length, boolean vertical) {
        Diagnostics.Assert(length > 0, "length<=0");
        if (length == 1) {
            Renderable r = renderables[index];
            if (!(r instanceof BoundableRenderable)) {
                return -1;
            }
            Rectangle rbounds = ((BoundableRenderable)r).getBounds();
            if (MarkupUtilities.intersects(clipArea, rbounds, vertical)) {
                return index;
            }
            return -1;
        }
        int middleIndex = index + length / 2;
        Renderable r = renderables[middleIndex];
        if (!(r instanceof BoundableRenderable)) {
            int rightIndex = MarkupUtilities.findLastIndex(renderables, clipArea, middleIndex + 1, length - (middleIndex - index + 1), vertical);
            if (rightIndex != -1) {
                return rightIndex;
            }
            return MarkupUtilities.findLastIndex(renderables, clipArea, index, middleIndex - index, vertical);
        }
        Rectangle rbounds = ((BoundableRenderable)r).getBounds();
        if (vertical) {
            int resultIdx;
            if (rbounds.y > clipArea.y + clipArea.height) {
                return MarkupUtilities.findLastIndex(renderables, clipArea, index, middleIndex - index, vertical);
            }
            int newLen = length - (middleIndex - index + 1);
            int n = resultIdx = newLen == 0 ? -1 : MarkupUtilities.findLastIndex(renderables, clipArea, middleIndex + 1, newLen, vertical);
            if (resultIdx == -1 && MarkupUtilities.intersects(clipArea, rbounds, vertical)) {
                return middleIndex;
            }
            return resultIdx;
        }
        if (rbounds.x > clipArea.x + clipArea.width) {
            return MarkupUtilities.findLastIndex(renderables, clipArea, index, middleIndex - index, vertical);
        }
        int resultIdx = MarkupUtilities.findLastIndex(renderables, clipArea, middleIndex + 1, length - (middleIndex - index + 1), vertical);
        if (resultIdx == -1 && MarkupUtilities.intersects(clipArea, rbounds, vertical)) {
            return middleIndex;
        }
        return resultIdx;
    }

    private static boolean intersects(Rectangle rect1, Rectangle rect2, boolean vertical) {
        if (vertical) {
            return rect1.y <= rect2.y + rect2.height && rect2.y <= rect1.y + rect1.height;
        }
        return rect1.x <= rect2.x + rect2.width && rect2.x <= rect1.x + rect1.width;
    }
}

