/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.error.reporting.ui;

import com.paterva.maltego.error.reporting.ui.NotificationUtility;
import com.paterva.maltego.error.reporting.ui.ProblemDtoBuilder;
import com.paterva.maltego.error.reporting.ui.ProblemNotificationPanel;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.openide.util.ImageUtilities;

public final class ExceptionHandler
extends Handler {
    @Override
    public void publish(LogRecord record) {
        Level level = record.getLevel();
        if (level.intValue() >= Level.SEVERE.intValue()) {
            String exceptionSummary;
            Throwable thrown = record.getThrown();
            ProblemDtoBuilder problemBuilder = new ProblemDtoBuilder();
            if (thrown != null) {
                if (this.block(thrown)) {
                    return;
                }
                exceptionSummary = this.getExceptionSummary(thrown);
                problemBuilder.setMessage(thrown);
            } else {
                exceptionSummary = this.getExceptionSummary(record, true);
                problemBuilder.setMessage(this.getExceptionSummary(record, false));
            }
            Runnable runnable = () -> {
                ProblemNotificationPanel panel = new ProblemNotificationPanel(exceptionSummary, problemBuilder);
                ImageIcon img = ImageUtilities.loadImageIcon((String)"org/netbeans/core/resources/exception.gif", (boolean)true);
                boolean slownessProblem = false;
                if (exceptionSummary != null && exceptionSummary.contains("EDT slowness detected: ")) {
                    slownessProblem = true;
                }
                NotificationUtility.showNotification("Unexpected Exception", panel, img, slownessProblem);
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private boolean block(Throwable t) {
        StackTraceElement[] trace;
        if (t == null) {
            return false;
        }
        if (t instanceof ArrayIndexOutOfBoundsException && (trace = t.getStackTrace()) != null && trace.length >= 1) {
            return trace[0].getClassName().startsWith("y.");
        }
        return false;
    }

    private String getExceptionSummary(Throwable thrown) {
        String val = thrown.getLocalizedMessage();
        if (val != null) {
            return val;
        }
        val = thrown.getMessage();
        if (val != null) {
            return val;
        }
        return thrown.getClass().getName();
    }

    private String getExceptionSummary(LogRecord record, boolean reduced) {
        String message = new SimpleFormatter().formatMessage(record);
        String name = reduced && StringUtils.isNotBlank((String)message) ? null : record.getLoggerName();
        return Stream.of(name, message).filter(Objects::nonNull).collect(Collectors.joining(": "));
    }
}

