/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepositoriesLock;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformSeedRepository;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.repository.serializer.TransformServerInfoSerializer;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ListSet;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class FSTransformServerRegistry
extends TransformServerRegistry {
    private static final Logger LOGGER = Logger.getLogger(FSTransformServerRegistry.class.getName());
    private static final String MALTEGO_FOLDER = "Maltego";
    private static final String SEED_FOLDER = "Servers";
    private static final String EXTENSION = "tas";
    private Map<FastURL, TransformServerFile> _map;
    private final FileObject _configRoot;

    public FSTransformServerRegistry() {
        this(FileUtil.getConfigRoot());
    }

    public FSTransformServerRegistry(FileObject configRoot) {
        this._configRoot = configRoot;
    }

    protected boolean isLocal(TransformServerFile file) {
        return false;
    }

    public Set<TransformServerInfo> findServers(String transformName, boolean enabledOnly) {
        ListSet servers = new ListSet();
        for (TransformServerInfo server : this.getAll()) {
            if (!FSTransformServerRegistry.enabled(server, enabledOnly) || !server.getTransforms().contains(transformName)) continue;
            servers.add(server);
        }
        return servers;
    }

    public boolean exists(String transformName, boolean onlyIfEnabled) {
        for (TransformServerInfo server : this.getAll()) {
            if (!FSTransformServerRegistry.enabled(server, onlyIfEnabled) || !server.getTransforms().contains(transformName)) continue;
            return true;
        }
        return false;
    }

    private static boolean enabled(TransformServerInfo server, boolean enabledOnly) {
        if (!enabledOnly) {
            return true;
        }
        return server.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TransformServerInfo server) {
        if (server.isDirty()) {
            try {
                boolean isNew;
                Object object = TransformRepositoriesLock.LOCK;
                synchronized (object) {
                    TransformServerFile info = this.getIgnoreCase(server.getUrl());
                    if (info == null) {
                        info = new TransformServerFile(server, this.addServer(server));
                        isNew = true;
                    } else {
                        this.updateServer(info.getFile(), server);
                        isNew = false;
                    }
                    this.map().put(server.getUrl(), info);
                    server.markClean();
                }
                if (isNew) {
                    this.fireItemAdded(server);
                } else {
                    this.fireItemChanged(server);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private FileObject addServer(TransformServerInfo info) throws IOException, XmlSerializationException {
        FileObject folder = this.getOrCreateTasFolder();
        FileObject file = FileUtilities.createUniqueFile((FileObject)folder, (String)FileUtilities.replaceIllegalChars((String)info.getDisplayName()), (String)EXTENSION);
        this.updateServer(file, info);
        return file;
    }

    private void updateServer(FileObject file, TransformServerInfo server) throws IOException {
        this.save(file, server);
        TransformServerFile serverFile = this.getIgnoreCase(server.getUrl());
        if (serverFile == null) {
            serverFile = new TransformServerFile(server, file);
            this.map().put(server.getUrl(), serverFile);
        } else {
            serverFile.setInfo(server);
        }
    }

    protected void save(FileObject file, TransformServerInfo server) throws IOException {
        try (OutputStream out = file.getOutputStream();){
            TransformServerInfoSerializer.write(server, out);
            server.markClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformServerInfo get(FastURL url) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            TransformServerFile file = this.getIgnoreCase(url);
            if (file == null) {
                return null;
            }
            return file.getInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformServerInfo getBySeedUrl(String url) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            TransformServerFile server = null;
            for (Map.Entry<FastURL, TransformServerFile> entry : this.map().entrySet()) {
                if (!entry.getValue().getInfo().getSeedUrls().contains(url)) continue;
                server = entry.getValue();
                break;
            }
            if (server == null) {
                return null;
            }
            return server.getInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TransformServerInfo> getAll() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            LinkedList<TransformServerInfo> list = new LinkedList<TransformServerInfo>();
            for (TransformServerFile file : this.map().values()) {
                list.add(file.getInfo());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(FastURL url) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            return this.containsIgnoreCase(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsIgnoreCase(FastURL url) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            return this.getIgnoreCase(url) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FastURL url) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            TransformServerFile info = this.getIgnoreCase(url);
            this.remove(info);
        }
    }

    private void remove(TransformServerFile info) {
        this.remove(info, true, true);
    }

    private void remove(TransformServerFile info, boolean removeRogueTransforms, boolean removeMissingTransformsFromSets) {
        if (info != null) {
            try {
                info.getFile().delete();
                this.removeIgnoreCase(info.getInfo().getUrl());
                if (removeRogueTransforms) {
                    this.removeRogueTransforms();
                }
                if (removeMissingTransformsFromSets) {
                    this.removeMissingTransformsFromSets();
                }
                this.fireItemRemoved(info);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSeedUrl(String seedUrl) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            ArrayList<FastURL> toRemove = new ArrayList<FastURL>();
            for (TransformServerInfo server : this.getAll()) {
                boolean removed = server.removeSeedUrl(seedUrl);
                if (!removed || !server.getSeedUrls().isEmpty()) continue;
                toRemove.add(server.getUrl());
            }
            for (FastURL url : toRemove) {
                this.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMissingSeeds() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            List transformSeedUrls = Stream.of(TransformSeedRepository.getDefault().getAll()).map(seed -> seed.getUrl().toString()).collect(Collectors.toList());
            ArrayList<TransformServerFile> filesToRemove = new ArrayList<TransformServerFile>();
            for (TransformServerInfo server : this.getAll()) {
                ArrayList<String> seedUrlsToRemove = new ArrayList<String>(server.getSeedUrls());
                seedUrlsToRemove.removeIf(seedUrl -> transformSeedUrls.stream().anyMatch(transformSeedUrl -> transformSeedUrl.equalsIgnoreCase((String)seedUrl)));
                for (String seedUrl2 : seedUrlsToRemove) {
                    TransformServerFile infoFile = this.getIgnoreCase(server.getUrl());
                    if (this.isLocal(infoFile)) continue;
                    boolean removed = server.removeSeedUrl(seedUrl2);
                    LOGGER.log(Level.INFO, "Removing transform seed URL from server since it is no longer associated with any transform seeds: transform seed URL = {0}", seedUrl2);
                    if (!removed || !server.getSeedUrls().isEmpty() || filesToRemove.contains(infoFile)) continue;
                    filesToRemove.add(infoFile);
                }
            }
            for (TransformServerFile infoFile : filesToRemove) {
                LOGGER.log(Level.INFO, "Removing server since it is no longer associated with any transform seeds: server URL = {0}", infoFile.getInfo().getUrl());
                this.remove(infoFile, false, false);
            }
            return !filesToRemove.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSeedUrl(String oldSeedUrl, String newSeedUrl) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            Collection<TransformServerInfo> infos = this.getAll();
            for (TransformServerInfo info : infos) {
                List seedUrls = info.getSeedUrls();
                if (seedUrls.contains(oldSeedUrl)) {
                    info.removeSeedUrl(oldSeedUrl);
                    info.addSeedUrl(newSeedUrl);
                }
                this.put(info);
            }
        }
    }

    private void removeRogueTransforms() {
        TransformRepository repository = TransformRepositoryRegistry.getDefault().getRepository("Remote");
        ArrayList<String> toRemove = new ArrayList<String>();
        for (TransformDefinition transform : repository.getAll()) {
            String name = transform.getName();
            Set<TransformServerInfo> servers = this.findServers(name, false);
            if (!servers.isEmpty()) continue;
            toRemove.add(name);
        }
        for (String transformName : toRemove) {
            repository.remove(transformName);
        }
    }

    private void removeMissingTransformsFromSets() {
        List transforms = TransformRepositoryRegistry.getDefault().getRepository("Remote").getAll().stream().map(transform -> transform.getName()).collect(Collectors.toList());
        TransformSetRepository setRepo = TransformSetRepository.getDefault();
        HashSet sets = new HashSet(setRepo.allSets());
        for (TransformSet set : sets) {
            boolean updated = false;
            HashSet setTransforms = new HashSet(set.getAllTransforms());
            for (String setTransform : setTransforms) {
                if (transforms.contains(setTransform)) continue;
                set.removeTransform(setTransform);
                updated = true;
            }
            if (!updated) continue;
            setRepo.put(set);
        }
        setRepo.removeEmptySets();
    }

    private FileObject getOrCreateTasFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this.getOrCreateMaltegoFolder(), (String)SEED_FOLDER);
    }

    private FileObject getOrCreateMaltegoFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)MALTEGO_FOLDER);
    }

    private FileObject getTasFolder() {
        FileObject maltegoFolder = this._configRoot.getFileObject(MALTEGO_FOLDER);
        if (maltegoFolder != null) {
            return maltegoFolder.getFileObject(SEED_FOLDER);
        }
        return null;
    }

    private Map<FastURL, TransformServerFile> map() {
        if (this._map == null) {
            this._map = this.load();
        }
        return this._map;
    }

    private void removeIgnoreCase(FastURL url) {
        ArrayList<FastURL> toRemove = new ArrayList<FastURL>();
        for (Map.Entry<FastURL, TransformServerFile> entry : this.map().entrySet()) {
            FastURL key = entry.getKey();
            if (!key.equalsIgnoreCase(url)) continue;
            toRemove.add(key);
        }
        for (FastURL fastURL : toRemove) {
            this.map().remove(fastURL);
        }
    }

    private TransformServerFile getIgnoreCase(FastURL url) {
        FastURL foundUrl = null;
        TransformServerFile server = null;
        for (Map.Entry<FastURL, TransformServerFile> entry : this.map().entrySet()) {
            FastURL key = entry.getKey();
            if (!key.equalsIgnoreCase(url)) continue;
            foundUrl = key;
            server = entry.getValue();
        }
        if (server != null && foundUrl != null && !foundUrl.equals((Object)url)) {
            this.remove(server);
            TransformServerInfo info = server.getInfo();
            info.setUrl(url);
            this.put(info);
        }
        return server;
    }

    private Map<FastURL, TransformServerFile> load() {
        HashMap<FastURL, TransformServerFile> map = new HashMap<FastURL, TransformServerFile>();
        FileObject folder = this.getTasFolder();
        if (folder != null) {
            Enumeration fileEnum = folder.getData(false);
            while (fileEnum.hasMoreElements()) {
                FileObject file = (FileObject)fileEnum.nextElement();
                if (!EXTENSION.equals(file.getExt())) continue;
                try {
                    TransformServerInfo info = this.load(file);
                    info.markClean();
                    map.put(info.getUrl(), new TransformServerFile(info, file));
                }
                catch (FileNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (XmlSerializationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransformServerInfo load(FileObject file) throws FileNotFoundException, XmlSerializationException {
        InputStream is = null;
        try {
            is = file.getInputStream();
            TransformServerInfo transformServerInfo = this.serializer().read(is);
            return transformServerInfo;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private TransformServerInfoSerializer serializer() {
        return new TransformServerInfoSerializer();
    }

    protected class TransformServerFile {
        private TransformServerInfo _info;
        private FileObject _file;

        public TransformServerFile() {
        }

        public TransformServerFile(TransformServerInfo info) {
            this(info, null);
        }

        public TransformServerFile(TransformServerInfo info, FileObject file) {
            this._info = info;
            this._file = file;
        }

        public TransformServerInfo getInfo() {
            return this._info;
        }

        public void setInfo(TransformServerInfo info) {
            this._info = info;
        }

        public FileObject getFile() {
            return this._file;
        }

        public void setFile(FileObject file) {
            this._file = file;
        }
    }
}

