/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.matching.StatelessMatchingRuleDescriptor;
import com.paterva.maltego.transform.descriptor.CompoundConstraint;
import com.paterva.maltego.transform.descriptor.ConditionalInputConstraint;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.EntityConstraint;
import com.paterva.maltego.transform.descriptor.IntegerStealthLevel;
import com.paterva.maltego.transform.descriptor.PersistenceMode;
import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.StealthLevel;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformInputType;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyInputType;
import com.paterva.maltego.transform.repository.serializer.PropertiesStub;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorStub;
import com.paterva.maltego.transform.repository.serializer.TransformPropertyStub;
import com.paterva.maltego.transform.repository.serializer.VisibilityTranslator;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.serializer.DisplayDescriptorTranslator;
import com.paterva.maltego.typing.serializer.FieldStub;
import com.paterva.maltego.typing.serializer.UnresolvedReferenceException;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class TransformDescriptorSerializer {
    public TransformDescriptor read(InputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformDescriptorStub stub = (TransformDescriptorStub)serializer.read(TransformDescriptorStub.class, stream);
        return TransformDescriptorSerializer.translate(stub);
    }

    public static TransformDescriptor translate(TransformDescriptorStub from) throws XmlSerializationException {
        TransformDescriptor to = new TransformDescriptor(from.getName(), from.getBaseName(), TransformDescriptorSerializer.translate(from.getProperties()), ProtocolVersion.get((String)from.getProtocolVersion(), (ProtocolVersion)ProtocolVersion.V2_0));
        to.setAbstract(from.isAbstract());
        to.setTemplate(from.isTemplate());
        to.setAuthor(from.getAuthor());
        to.setDefaultSets(from.getDefaultSets());
        to.setDescription(from.getDescription());
        to.setDisclaimer(from.getDisclaimer());
        to.setDisplayName(from.getDisplayName());
        to.setHelpText(from.getHelpText());
        to.setHelpUrl(from.getHelpUrl());
        to.setVisibility(VisibilityTranslator.get(from.getVisibility()));
        to.setLocationRelevance(from.getLocationRelevance());
        to.setOwner(from.getOwner());
        to.setRequireDisplayInfo(from.requiresDisplayInfo());
        to.setStealthLevel((StealthLevel)new IntegerStealthLevel(from.getStealthLevel()));
        to.setVersion(from.getVersion());
        if (from.getInputConstraints() != null) {
            to.setInputConstraint(TransformDescriptorSerializer.translate(from.getInputType(), from.getInputConstraints(), from.getInputPropertyConstraintsType(), from.getInputPropertyConstraints()));
        }
        if (from.getOutputEntities() != null) {
            to.getOutputEntities().addAll(from.getOutputEntities());
        }
        to.setMatchingRule(StatelessMatchingRuleDescriptor.Value);
        to.setAuthenticator(from.getAuthenticator());
        return to;
    }

    private static Constraint translate(String inputType, List<TransformDescriptorStub.EntityReferenceStub> fromTypes, String propertyConstraintsType, List<String> fromProperties) {
        ConditionalInputConstraint constraint = new ConditionalInputConstraint(TransformInputType.get((String)inputType));
        if (!fromTypes.isEmpty()) {
            List types = fromTypes.stream().map(f -> f.getTypeName()).collect(Collectors.toList());
            constraint.setTypeNames(types);
        }
        if (propertyConstraintsType != null && fromProperties != null && !fromProperties.isEmpty()) {
            constraint.setPropertyConstraintsType(TransformPropertyInputType.get((String)propertyConstraintsType));
            constraint.setPropertyConstraints(fromProperties);
        }
        return constraint;
    }

    static DisplayDescriptorCollection translate(PropertiesStub from) throws UnresolvedReferenceException {
        DisplayDescriptorList list = new DisplayDescriptorList();
        if (from != null) {
            for (TransformPropertyStub stub : from.getFields()) {
                TransformPropertyDescriptor td = TransformDescriptorSerializer.translate(stub);
                list.add((DisplayDescriptor)td);
            }
        }
        return list;
    }

    public static TransformPropertyDescriptor translate(TransformPropertyStub stub) throws UnresolvedReferenceException {
        DisplayDescriptorTranslator translator = new DisplayDescriptorTranslator();
        TransformPropertyDescriptor td = new TransformPropertyDescriptor(translator.translate((FieldStub)stub));
        td.setAbstract(stub.isAbstract());
        td.setPersistence(TransformDescriptorSerializer.getPersistence(stub.getPersistence()));
        td.setVisibility(VisibilityTranslator.get(stub.getVisibility()));
        td.setPopup(stub.isPopup());
        td.setAuth(stub.isAuth());
        td.setGlobal(stub.isGlobal());
        return td;
    }

    private static PersistenceMode getPersistence(String s) {
        if ("no-export".equals(s)) {
            return PersistenceMode.NoExport;
        }
        if ("none".equals(s)) {
            return PersistenceMode.None;
        }
        return PersistenceMode.Normal;
    }

    private static String getPersistence(PersistenceMode mode) {
        switch (mode) {
            case NoExport: {
                return "no-export";
            }
            case None: {
                return "none";
            }
        }
        return null;
    }

    public void write(TransformDescriptor descriptor, OutputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformDescriptorStub stub = TransformDescriptorSerializer.translate(descriptor);
        serializer.write((Object)stub, stream);
    }

    public static TransformDescriptorStub translate(TransformDescriptor from) throws XmlSerializationException {
        TransformDescriptorStub to = new TransformDescriptorStub();
        to.setName(from.getName());
        to.setAbstract(from.isAbstract());
        to.setTemplate(from.isTemplate());
        to.setAuthor(from.getAuthor());
        to.setDescription(from.getDescription());
        to.setDisclaimer(from.getDisclaimer());
        to.setDisplayName(from.getDisplayName());
        to.setHelpText(from.getHelpText());
        to.setHelpUrl(from.getHelpUrl());
        to.setVisibility(VisibilityTranslator.get(from.getVisibility()));
        to.setLocationRelevance(from.getLocationRelevance());
        to.setOwner(from.getOwner());
        to.setRequireDisplayInfo(from.isRequireDisplayInfo());
        int stealthLevel = 0;
        if (from.getStealthLevel() != null) {
            IntegerStealthLevel level = (IntegerStealthLevel)from.getStealthLevel();
            stealthLevel = level.getLevelNumber();
        }
        to.setStealthLevel(stealthLevel);
        to.setVersion(from.getVersion());
        if (from.getDefaultSets() != null) {
            to.setDefaultSets(from.getDefaultSets());
        }
        if (from.getInputConstraint() != null) {
            Constraint inputConstraint = from.getInputConstraint();
            to.getInputConstraints().addAll(TransformDescriptorSerializer.translate(inputConstraint));
            if (inputConstraint instanceof ConditionalInputConstraint) {
                ConditionalInputConstraint constraint = (ConditionalInputConstraint)from.getInputConstraint();
                String propertyConstraintsTypesString = null;
                if (constraint.getPropertyConstraintsType() != null) {
                    propertyConstraintsTypesString = constraint.getPropertyConstraintsType().name();
                }
                to.setInputType(((ConditionalInputConstraint)from.getInputConstraint()).getInputType().name());
                to.setInputPropertyConstraints(constraint.getPropertyConstraints());
                to.setInputPropertyConstraintsType(propertyConstraintsTypesString);
            }
        }
        if (from.getOutputEntities() != null) {
            to.setOutputEntities(from.getOutputEntities());
        }
        if (from.getProperties() != null) {
            to.setProperties(TransformDescriptorSerializer.translate(from.getProperties()));
        }
        to.setAuthenticator(from.getAuthenticator());
        to.setProtocolVersion(from.getProtocolVersion().toString());
        return to;
    }

    static PropertiesStub translate(DisplayDescriptorCollection descriptors) throws UnresolvedReferenceException {
        ArrayList<TransformPropertyStub> stubs = new ArrayList<TransformPropertyStub>();
        if (descriptors != null) {
            for (DisplayDescriptor dd : descriptors) {
                if (!(dd instanceof TransformPropertyDescriptor)) continue;
                TransformPropertyDescriptor td = (TransformPropertyDescriptor)dd;
                TransformPropertyStub stub = TransformDescriptorSerializer.translate(td);
                stubs.add(stub);
            }
        }
        PropertiesStub stub = new PropertiesStub(stubs, null);
        return stub;
    }

    public static TransformPropertyStub translate(TransformPropertyDescriptor td) throws UnresolvedReferenceException {
        DisplayDescriptorTranslator translator = new DisplayDescriptorTranslator();
        TransformPropertyStub stub = new TransformPropertyStub();
        translator.translate((DisplayDescriptor)td, (FieldStub)stub);
        stub.setAbstract(td.isAbstract());
        stub.setPopup(td.isPopup());
        stub.setPersistence(TransformDescriptorSerializer.getPersistence(td.getPersistence()));
        stub.setVisibility(VisibilityTranslator.get(td.getVisibility()));
        stub.setAuth(td.isAuth());
        stub.setGlobal(td.isGlobal());
        return stub;
    }

    private static Collection<TransformDescriptorStub.EntityReferenceStub> translate(Constraint c) {
        ArrayList<TransformDescriptorStub.EntityReferenceStub> to;
        block3: {
            block4: {
                block2: {
                    to = new ArrayList<TransformDescriptorStub.EntityReferenceStub>();
                    if (!(c instanceof EntityConstraint)) break block2;
                    to.add(TransformDescriptorSerializer.translate((EntityConstraint)c));
                    break block3;
                }
                if (!(c instanceof CompoundConstraint)) break block4;
                CompoundConstraint from = (CompoundConstraint)c;
                for (EntityConstraint entity : from) {
                    to.add(TransformDescriptorSerializer.translate(entity));
                }
                break block3;
            }
            if (!(c instanceof ConditionalInputConstraint)) break block3;
            ConditionalInputConstraint from = (ConditionalInputConstraint)c;
            for (String entity : from.getTypeNames()) {
                to.add(TransformDescriptorSerializer.translate(entity));
            }
        }
        return to;
    }

    private static TransformDescriptorStub.EntityReferenceStub translate(String typeName) {
        TransformDescriptorStub.EntityReferenceStub stub = new TransformDescriptorStub.EntityReferenceStub(typeName);
        return stub;
    }

    private static TransformDescriptorStub.EntityReferenceStub translate(EntityConstraint entity) {
        TransformDescriptorStub.EntityReferenceStub stub = new TransformDescriptorStub.EntityReferenceStub(entity.getTypeName());
        return stub;
    }
}

