/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud;

import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.lock.CloudGraphQueryUtils;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.util.NormalException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

public class CloudGraphRegistry {
    private static CloudGraphRegistry instance;
    private final HashMap<GraphID, CloudGraph> cloudGraphs = new HashMap();
    private final HashMap<GraphID, CloudGraph> versionsOfCloudGraphs = new HashMap();

    public static synchronized CloudGraphRegistry getDefault() {
        if (instance == null) {
            instance = new CloudGraphRegistry();
        }
        return instance;
    }

    public CloudGraphRegistry() {
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)new GraphClosingListener());
    }

    public void addCloudGraph(GraphID cloudGraphID, CloudGraph cloudGraph) {
        this.cloudGraphs.put(cloudGraphID, cloudGraph);
    }

    public void addVersionOfCloudGraph(GraphID maltegoGraphID, CloudGraph cloudGraph) {
        this.versionsOfCloudGraphs.put(maltegoGraphID, cloudGraph);
    }

    public void removeCloudGraph(GraphID graphID) {
        this.cloudGraphs.remove(graphID);
    }

    public void removeVersionOfCloudGraph(GraphID maltegoGraphID) {
        this.versionsOfCloudGraphs.remove(maltegoGraphID);
    }

    public boolean isCloudGraph(GraphID graphID) {
        return this.cloudGraphs.keySet().contains(graphID);
    }

    public boolean isVersionOfCloudGraph(GraphID maltegoGraphID) {
        return this.versionsOfCloudGraphs.keySet().contains(maltegoGraphID);
    }

    public GraphID getSameVersionOfCloudGraph(GraphID cloudGraphID, String version) {
        GraphID versionIdFound = null;
        if (cloudGraphID != null && version != null) {
            for (Map.Entry<GraphID, CloudGraph> entry : this.versionsOfCloudGraphs.entrySet()) {
                CloudGraph cloudGraph = entry.getValue();
                if (!cloudGraphID.equals((Object)cloudGraph.getCloudGraphId()) || !version.equals(cloudGraph.getVersion())) continue;
                versionIdFound = cloudGraph.getMaltegoGraphID();
                break;
            }
        }
        return versionIdFound;
    }

    public boolean isEditable(GraphID graphID) {
        return this.isCloudGraph(graphID) && Boolean.TRUE.equals(this.cloudGraphs.get(graphID).isEditable());
    }

    private class GraphClosingListener
    implements PropertyChangeListener {
        private GraphClosingListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("graphClosing".equals(evt.getPropertyName())) {
                this.removeLock(evt);
            } else if ("graphClosed".equals(evt.getPropertyName())) {
                this.removeLock(evt);
            }
        }

        private void removeLock(PropertyChangeEvent evt) {
            Object graphIDObject = evt.getNewValue();
            if (graphIDObject instanceof GraphID) {
                if (CloudGraphRegistry.this.isCloudGraph((GraphID)graphIDObject)) {
                    CloudGraphRegistry.this.removeCloudGraph((GraphID)graphIDObject);
                    try {
                        CloudGraphQueryUtils.removeLock((GraphID)graphIDObject);
                    }
                    catch (Exception ex) {
                        NormalException.logStackTrace((Throwable)ex);
                    }
                }
                if (CloudGraphRegistry.this.isVersionOfCloudGraph((GraphID)graphIDObject)) {
                    CloudGraphRegistry.this.removeVersionOfCloudGraph((GraphID)graphIDObject);
                }
            }
        }
    }
}

