/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.lock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.lock.CloudGraphQueryError;
import com.maltego.cloud.lock.CloudGraphQueryResult;
import com.maltego.cloud.lock.CloudGraphQueryState;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.serializers.json.GraphLock;
import com.paterva.maltego.serializers.json.GraphMeta;
import com.paterva.maltego.util.NormalException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.keycloak.representations.AccessToken;

public class CloudGraphQueryUtils {
    private static final Logger LOG = Logger.getLogger(CloudGraphQueryUtils.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();

    public static CloudGraphQueryResult findGraph(CloudAuth cloudAuth, GraphID graphID) throws Exception {
        return CloudGraphQueryUtils.apiQueryFind(cloudAuth, graphID.toString(), HttpAgent.HttpMethod.GET);
    }

    public static CloudGraphQueryResult lock(CloudAuth cloudAuth, GraphID graphID) throws Exception {
        return CloudGraphQueryUtils.apiQueryLock(cloudAuth, graphID + "/lock", HttpAgent.HttpMethod.PUT);
    }

    public static boolean removeLock(GraphID graphID) throws Exception {
        CloudAuth cloudAuth = CloudAuth.getDefault();
        CloudGraphQueryResult result = CloudGraphQueryUtils.apiQueryLock(cloudAuth, graphID + "/lock", HttpAgent.HttpMethod.DELETE);
        CloudGraphQueryState state = result.getQueryState();
        boolean success = false;
        if (CloudGraphQueryState.LOCKDELETE__GRAPH_EXISTS_NO_LOCK_YET_OR_LOCK_REMOVE_SUCCESS.equals((Object)state)) {
            success = true;
        } else {
            LOG.log(Level.WARNING, state.getMsg() + " Graph ID: {0}", graphID);
        }
        return success;
    }

    private static CloudGraphQueryResult apiQueryFind(CloudAuth cloudAuth, String path, HttpAgent.HttpMethod method) throws Exception {
        CloudGraphQueryResult result = new CloudGraphQueryResult(CloudGraphQueryState.FAILED);
        HttpAgent httpAgent = CloudGraphQueryUtils.createHttpAgent(cloudAuth, cloudAuth.getCloudSyncUrl() + "/graphs/" + path);
        try {
            switch (method) {
                case GET: {
                    httpAgent.doGet();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
            String graphMetaJson = httpAgent.getContentAsString();
            CloudGraphQueryUtils.checkReponse(graphMetaJson, cloudAuth, result, path, method);
        }
        catch (JsonMappingException ex) {
            throw ex;
        }
        catch (JsonProcessingException ex) {
            throw ex;
        }
        catch (IOException ex) {
            boolean errorFound = CloudGraphQueryUtils.checkCloudGraphError(ex, CloudGraphQueryError.GRAPH_CONTROLLER_FIND_GRAPH_404);
            if (errorFound && HttpAgent.HttpMethod.GET.equals((Object)method)) {
                result.setQueryResult(CloudGraphQueryState.ERROR__GRAPH_DOES_NOT_EXIST_YET);
            }
            int responseCode = httpAgent.getResponseCode();
            LOG.log(Level.WARNING, "Response code is: {0} : path : {1}", new Object[]{responseCode, path});
        }
        return result;
    }

    private static CloudGraphQueryResult apiQueryLock(CloudAuth cloudAuth, String path, HttpAgent.HttpMethod method) throws Exception {
        CloudGraphQueryResult result = new CloudGraphQueryResult(CloudGraphQueryState.FAILED);
        HttpAgent httpAgent = CloudGraphQueryUtils.createHttpAgent(cloudAuth, cloudAuth.getCloudSyncUrl() + "/graphs/" + path);
        try {
            switch (method) {
                case PUT: {
                    httpAgent.doPut();
                    break;
                }
                case DELETE: {
                    httpAgent.doDelete();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
            String graphMetaJson = httpAgent.getContentAsString();
            CloudGraphQueryUtils.checkReponse(graphMetaJson, cloudAuth, result, path, method);
        }
        catch (JsonMappingException ex) {
            throw ex;
        }
        catch (JsonProcessingException ex) {
            throw ex;
        }
        catch (IOException ex) {
            boolean errorFound = CloudGraphQueryUtils.checkCloudGraphError(ex, CloudGraphQueryError.GRAPH_CONTROLLER_LOCK_GRAPH_404);
            if (errorFound && (HttpAgent.HttpMethod.PUT.equals((Object)method) || HttpAgent.HttpMethod.DELETE.equals((Object)method))) {
                result.setQueryResult(CloudGraphQueryState.ERROR__GRAPH_DOES_NOT_EXIST_YET);
            }
            errorFound = CloudGraphQueryUtils.checkCloudGraphError(ex, CloudGraphQueryError.GRAPH_CONTROLLER_LOCK_GRAPH_403);
            if (errorFound && HttpAgent.HttpMethod.PUT.equals((Object)method)) {
                result.setQueryResult(CloudGraphQueryState.ERROR_LOCKPUT__GRAPH_EXISTS_BUT_USER_CANNOT_LOCK1);
            }
            int responseCode = httpAgent.getResponseCode();
            LOG.log(Level.WARNING, "Response code is: {0} : path : {1}", new Object[]{responseCode, path});
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkReponse(String graphMetaJson, CloudAuth cloudAuth, CloudGraphQueryResult result, String path, HttpAgent.HttpMethod method) throws JsonProcessingException {
        LOG.log(Level.FINE, "Result: {0}", graphMetaJson);
        AccessToken accessToken = cloudAuth.getAccessToken();
        if (accessToken == null) {
            String msg = "Access token is null.";
            LOG.log(Level.WARNING, msg + ": {0}", path);
            throw new IllegalStateException(msg);
        }
        String email = accessToken.getEmail();
        if (email == null) {
            String msg = "Email not found in access token.";
            LOG.log(Level.WARNING, msg + ": {0}", path);
            throw new IllegalStateException(msg);
        }
        if (graphMetaJson == null) {
            String msg = "GraphMeta is null.";
            LOG.log(Level.WARNING, msg + ": {0}", path);
            throw new IllegalStateException(msg);
        }
        GraphMeta graphMeta = (GraphMeta)mapper.readValue(graphMetaJson, GraphMeta.class);
        result.setGraphMeta(graphMeta);
        GraphLock graphLock = graphMeta.getLock();
        if (graphLock != null) {
            if (graphLock.getOwner() != null && email.toLowerCase().equals(graphLock.getOwner().toLowerCase())) {
                result.setQueryResult(CloudGraphQueryState.GRAPH_EXISTS_AND_USER_HAS_LOCK);
                return;
            }
            result.setQueryResult(CloudGraphQueryState.GRAPH_EXISTS_BUT_ANOTHER_USER_HAS_LOCK);
            return;
        }
        if (HttpAgent.HttpMethod.GET.equals((Object)method)) {
            result.setQueryResult(CloudGraphQueryState.FIND__GRAPH_EXISTS_BUT_NOT_LOCKED);
            return;
        }
        if (HttpAgent.HttpMethod.PUT.equals((Object)method)) {
            result.setQueryResult(CloudGraphQueryState.LOCKPUT_GRAPH_EXISTS_BUT_USER_CANNOT_LOCK2);
            return;
        }
        if (!HttpAgent.HttpMethod.DELETE.equals((Object)method)) return;
        result.setQueryResult(CloudGraphQueryState.LOCKDELETE__GRAPH_EXISTS_NO_LOCK_YET_OR_LOCK_REMOVE_SUCCESS);
    }

    private static HttpAgent createHttpAgent(CloudAuth cloudAuth, String urlStr) throws Exception {
        String accessToken = cloudAuth.getAccessTokenString();
        URL url = new URL(urlStr);
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setAccessToken(accessToken);
        return httpAgent;
    }

    private static boolean checkCloudGraphError(Exception ex, CloudGraphQueryError errorToFind) {
        boolean errorFound;
        block3: {
            errorFound = false;
            try {
                if (!(ex instanceof IOException)) break block3;
                Throwable throwable = ex.getCause();
                for (int count = 0; throwable != null && count < 7; ++count, throwable = throwable.getCause()) {
                    String innerMessage = throwable.getMessage();
                    if (innerMessage == null || !innerMessage.contains("Unexpected HTTP response: " + errorToFind.getCode())) continue;
                    errorFound = true;
                    LOG.log(Level.WARNING, errorToFind.getMsg() + ": {0}", innerMessage);
                    break;
                }
            }
            catch (Exception ex1) {
                NormalException.logStackTrace((Throwable)ex1);
            }
        }
        return errorFound;
    }
}

