/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.manager;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.manager.LicensedPanel;
import com.paterva.maltego.licensing.ui.manager.MaltegoIdPanel;
import com.paterva.maltego.licensing.ui.manager.UnknownPanel;
import com.paterva.maltego.licensing.ui.monitor.B;
import com.paterva.maltego.licensing.ui.monitor.C;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.ui.BusySpinnerPanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

public class LicenseManagerPanel
extends JPanel {
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final JButton changeButton;
    private final JButton closeButton;
    private ChangeListener licenseListener;
    private C pollListener;
    private JPanel centerPanel;
    private static final String REFRESH_BUTTON = "refreshButton";
    private static final String REFRESH_SPINNER = "refreshSpinner";
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel refreshPanelContainer = new JPanel(new FlowLayout());
    private final JPanel refreshPanel = new JPanel(this.cardLayout);
    private final JButton refreshButton = new JButton("Refresh license info from server");

    public LicenseManagerPanel(JButton changeButton, JButton closeButton) {
        this.changeButton = changeButton;
        this.closeButton = closeButton;
        this.initComponents();
        this.setBackground(this.LAF.getColor("3-main-dark-color"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.refreshButton.addActionListener(ignored -> this.refreshClicked());
        this.refreshPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.refreshPanel.add((Component)this.refreshButton, REFRESH_BUTTON);
        this.refreshPanelContainer.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.refreshPanelContainer.add(this.refreshPanel);
        BusySpinnerPanel spinner = new BusySpinnerPanel(15);
        spinner.setPreferredSize(this.refreshButton.getPreferredSize());
        spinner.setBackground(this.refreshPanelContainer.getBackground());
        this.refreshPanel.add((Component)spinner, REFRESH_SPINNER);
    }

    public boolean isChangeKey() {
        if (this.centerPanel instanceof LicensedPanel) {
            LicensedPanel licensedPanel = (LicensedPanel)this.centerPanel;
            return licensedPanel.isChangeKey();
        }
        return false;
    }

    public boolean isLogIn() {
        if (this.centerPanel instanceof MaltegoIdPanel) {
            MaltegoIdPanel maltegoIdPanel = (MaltegoIdPanel)this.centerPanel;
            return maltegoIdPanel.isLogIn();
        }
        return false;
    }

    public boolean isLogInAndActivate() {
        if (this.centerPanel instanceof MaltegoIdPanel) {
            MaltegoIdPanel maltegoIdPanel = (MaltegoIdPanel)this.centerPanel;
            return maltegoIdPanel.isLogInAndActivate();
        }
        return false;
    }

    public boolean isSwitchOrg() {
        if (this.centerPanel instanceof MaltegoIdPanel) {
            MaltegoIdPanel maltegoIdPanel = (MaltegoIdPanel)this.centerPanel;
            return maltegoIdPanel.isSwitchOrg();
        }
        return false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.licenseListener = ignored -> this.update();
        LicenseManager.A().A(this.licenseListener);
        this.pollListener = new LicensePollListener();
        B.B(this.pollListener);
        this.update();
    }

    @Override
    public void removeNotify() {
        B.A(this.pollListener);
        this.pollListener = null;
        LicenseManager.A().B(this.licenseListener);
        this.licenseListener = null;
        super.removeNotify();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(size.width, 600), Math.max(size.height, 200));
    }

    private void update() {
        if (B.O()) {
            this.showPolling();
        } else {
            this.showLicense(false);
        }
    }

    private void showPolling() {
        this.removeAll();
        Color orange = this.LAF.getColor("3-maltego-orange");
        JLabel titleLabel = new JLabel("Polling server for Maltego Plan changes");
        Font font = titleLabel.getFont();
        titleLabel.setFont(font.deriveFont(1, font.getSize2D() + 2.0f));
        titleLabel.setForeground(orange);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(ignored -> B.C());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(this.LAF.getColor("7-heading-panel-background"));
        titlePanel.add(titleLabel);
        titlePanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        topPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        topPanel.add(titlePanel);
        JPanel bottomPanel = new JPanel(new FlowLayout());
        bottomPanel.add(cancelButton);
        BusySpinnerPanel spinner = new BusySpinnerPanel();
        spinner.setPreferredSize(new Dimension(208, 208));
        spinner.setBackground(bottomPanel.getBackground());
        this.add((Component)topPanel, "North");
        this.add((Component)spinner, "Center");
        this.add((Component)bottomPanel, "South");
        this.updateWindow();
    }

    private void showLicense(boolean checkOnline) throws IllegalStateException {
        SlownessDetector.setEnabled((boolean)false);
        if (checkOnline) {
            this.cardLayout.show(this.refreshPanel, REFRESH_SPINNER);
            this.updateWindow();
        }
        new Thread(() -> {
            try {
                A licenseMode = LicenseManager.A().A(checkOnline);
                SwingUtilities.invokeLater(() -> {
                    this.removeAll();
                    if (licenseMode.B()) {
                        this.centerPanel = new LicensedPanel(licenseMode, this.closeButton);
                        this.closeButton.setText(licenseMode.P() ? "Close" : "Exit");
                    } else if (licenseMode.W() || licenseMode.Q()) {
                        this.refreshButton.setEnabled(true);
                        this.refreshButton.setToolTipText("Click to update the desktop with the newest license info from the server");
                        if (licenseMode.S()) {
                            this.refreshButton.setEnabled(false);
                            this.refreshButton.setToolTipText("Maltego ID: Offline Activated");
                        } else if (!licenseMode.O() || !LicenseManager.J()) {
                            this.refreshButton.setEnabled(false);
                            this.refreshButton.setToolTipText("Offline: Please check your network and proxy settings");
                        }
                        this.centerPanel = new MaltegoIdPanel(licenseMode, this.closeButton);
                    } else {
                        this.changeButton.setText("Select Maltego Plan");
                        this.centerPanel = new UnknownPanel();
                    }
                    this.add((Component)this.centerPanel, "Center");
                    if (licenseMode.B() || licenseMode.W()) {
                        this.cardLayout.show(this.refreshPanel, REFRESH_BUTTON);
                        this.add((Component)this.refreshPanelContainer, "South");
                    }
                    this.updateWindow();
                    SlownessDetector.setEnabled((boolean)true);
                });
            }
            catch (Exception ex) {
                this.cardLayout.show(this.refreshPanel, REFRESH_BUTTON);
                this.updateWindow();
                SlownessDetector.setEnabled((boolean)true);
            }
        }, "Refresh license info from server").start();
    }

    private void updateWindow() {
        SwingUtilities.invokeLater(() -> {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.pack();
                window.repaint();
                if (window instanceof JDialog) {
                    JDialog dialog = (JDialog)window;
                    dialog.toFront();
                    dialog.requestFocus();
                }
            }
        });
    }

    private void refreshClicked() {
        this.showLicense(true);
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new BorderLayout());
    }

    private class LicensePollListener
    implements C {
        @Override
        public void onPollStart() {
            LicenseManagerPanel.this.showPolling();
        }

        @Override
        public void onPollEnd() {
            LicenseManagerPanel.this.update();
        }
    }
}

