/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.product;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.action.CertificateManagerAction;
import com.paterva.maltego.licensing.ui.product.ProductSelectionResult;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIDefaults;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ActivationTypePanel
extends JPanel {
    private static final String STEP_ACTIVATION_OPTIONS = "step.activation_options";
    private static final String STEP_ACTIVATION_MODE = "step.activation_mode";
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private ChangeListener licenseListener;
    private String currentStep;
    private ProductSelectionResult result = null;
    private Runnable closeUIHook = () -> {};
    private JPanel activationContainerPanel;
    private ButtonGroup activationModeBg;
    private JLabel activationModeLabel;
    private ButtonGroup activationOptionsBg;
    private JLabel activationOptionsLabel;
    private JButton backButton;
    private JPanel bottomPanel;
    private JButton certificatesButton;
    private JButton compareButton;
    private JButton exitButton;
    private JPanel licenseKeyOptionPanel;
    private JRadioButton licenseKeyRb;
    private JScrollPane licenseKeySp;
    private JTextArea licenseKeyTextArea;
    private JPanel maltegoIdOptionPanel;
    private JRadioButton maltegoIdRb;
    private JScrollPane maltegoIdSp;
    private JTextArea maltegoIdTextArea;
    private JPanel modePanel;
    private JScrollPane modeSp;
    private JTextArea modeTextArea;
    private JButton nextButton;
    private JRadioButton offlineActivationRb;
    private JRadioButton onlineActivationRb;
    private JButton optionsButton;
    private JPanel optionsPanel;
    private JLabel titleLabel;
    private JLabel titleMsgLabel;
    private JPanel welcomePanel;

    public ActivationTypePanel() {
        this.initComponents();
        this.activationOptionsBg.add(this.licenseKeyRb);
        this.activationOptionsBg.add(this.maltegoIdRb);
        this.activationModeBg.add(this.onlineActivationRb);
        this.activationModeBg.add(this.offlineActivationRb);
        Color selectedTypeBorderColor = this.LAF.getColor("activation-type-selected-option-border");
        Color nonSelectedTypeBorderColor = this.LAF.getColor("activation-type-panel-background");
        this.licenseKeyRb.addChangeListener(event -> {
            this.licenseKeyOptionPanel.setBorder(new LineBorder(this.licenseKeyRb.isSelected() ? selectedTypeBorderColor : nonSelectedTypeBorderColor));
            this.nextButton.setEnabled(true);
        });
        this.maltegoIdRb.addChangeListener(event -> {
            this.maltegoIdOptionPanel.setBorder(new LineBorder(this.maltegoIdRb.isSelected() ? selectedTypeBorderColor : nonSelectedTypeBorderColor));
            this.nextButton.setEnabled(true);
        });
        this.licenseKeyRb.setSelected(true);
        this.licenseKeyOptionPanel.setBorder(new LineBorder(selectedTypeBorderColor));
        this.onlineActivationRb.addChangeListener(event -> this.nextButton.setEnabled(true));
        this.offlineActivationRb.addChangeListener(event -> this.nextButton.setEnabled(true));
        this.setBackground(this.LAF.getColor("activation-type-panel-background"));
        Color orange = this.LAF.getColor("3-maltego-orange");
        this.titleLabel.setForeground(orange);
        this.titleMsgLabel.setForeground(orange);
        this.bottomPanel.setBackground(this.LAF.getColor("3-main-dark-color"));
        Color modeFgColor = Color.WHITE;
        this.activationOptionsLabel.setForeground(modeFgColor);
        this.activationModeLabel.setForeground(modeFgColor);
        this.licenseKeyTextArea.setDisabledTextColor(modeFgColor);
        this.maltegoIdTextArea.setDisabledTextColor(modeFgColor);
        this.modeTextArea.setDisabledTextColor(modeFgColor);
        this.showActivationOptions();
    }

    public void setCloseUIHook(Runnable closeUIHook) {
        this.closeUIHook = closeUIHook;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ChangeListener listener = ignored -> {
            String exitButtonText;
            A licenseMode = LicenseManager.A().A(false);
            if (licenseMode.D()) {
                exitButtonText = NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.exitButton.text");
            } else {
                exitButtonText = NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.exitButton.closeText");
                if (licenseMode.L() || licenseMode.U()) {
                    this.maltegoIdRb.setSelected(true);
                } else {
                    this.licenseKeyRb.setSelected(true);
                }
            }
            Mnemonics.setLocalizedText((AbstractButton)this.exitButton, (String)exitButtonText);
        };
        listener.stateChanged(null);
        LicenseManager.A().A(this.licenseListener);
    }

    @Override
    public void removeNotify() {
        LicenseManager.A().B(this.licenseListener);
        this.licenseListener = null;
        super.removeNotify();
    }

    public ProductSelectionResult getResult() {
        return this.result;
    }

    final void showActivationOptions() {
        this.activationContainerPanel.removeAll();
        this.activationContainerPanel.add((Component)this.optionsPanel, "Center");
        this.revalidate();
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(this.activationOptionsBg.getSelection() != null);
        this.compareButton.setVisible(true);
        this.currentStep = STEP_ACTIVATION_OPTIONS;
    }

    final void showActivationMode() {
        if (this.licenseKeyRb.isSelected()) {
            Mnemonics.setLocalizedText((JLabel)this.activationModeLabel, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.activationModeLabel.text_licenseKey"));
            this.activationModeLabel.setToolTipText(NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.activationModeLabel.text_licenseKey"));
            this.modeTextArea.setText(NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.modeTextArea.text_licenseKey"));
        } else {
            Mnemonics.setLocalizedText((JLabel)this.activationModeLabel, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.activationModeLabel.text_maltegoId"));
            this.activationModeLabel.setToolTipText(NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.activationModeLabel.text_maltegoId"));
            this.modeTextArea.setText(NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.modeTextArea.text_maltegoId"));
        }
        this.activationContainerPanel.removeAll();
        this.activationContainerPanel.add((Component)this.modePanel, "Center");
        this.revalidate();
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(this.activationModeBg.getSelection() != null);
        this.compareButton.setVisible(false);
        this.currentStep = STEP_ACTIVATION_MODE;
    }

    public static ProductSelectionResult showActivationDialog() {
        ActivationTypePanel asp = new ActivationTypePanel();
        DialogDescriptor dd = new DialogDescriptor((Object)asp, NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.title"));
        dd.setOptions(new Object[0]);
        JDialog dialog = (JDialog)DialogDisplayer.getDefault().createDialog(dd);
        asp.setCloseUIHook(() -> dialog.dispose());
        dialog.setResizable(false);
        dialog.getRootPane().setDefaultButton(asp.nextButton);
        dialog.setVisible(true);
        return asp.getResult();
    }

    private void initComponents() {
        this.activationOptionsBg = new ButtonGroup();
        this.activationModeBg = new ButtonGroup();
        this.modePanel = new JPanel();
        JLabel maltegoLogoLabel1 = new JLabel();
        this.activationModeLabel = new JLabel();
        this.offlineActivationRb = new JRadioButton();
        this.onlineActivationRb = new JRadioButton();
        this.modeSp = new JScrollPane();
        this.modeSp.getViewport().setOpaque(false);
        this.modeTextArea = new JTextArea();
        this.optionsPanel = new JPanel();
        JLabel maltegoLogoLabel = new JLabel();
        this.activationOptionsLabel = new JLabel();
        this.licenseKeyOptionPanel = new JPanel();
        this.licenseKeyRb = new JRadioButton();
        this.licenseKeySp = new JScrollPane();
        this.licenseKeySp.getViewport().setOpaque(false);
        this.licenseKeyTextArea = new JTextArea();
        this.maltegoIdOptionPanel = new JPanel();
        this.maltegoIdRb = new JRadioButton();
        this.maltegoIdSp = new JScrollPane();
        this.maltegoIdSp.getViewport().setOpaque(false);
        this.maltegoIdTextArea = new JTextArea();
        this.welcomePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleMsgLabel = new JLabel();
        this.compareButton = new JButton();
        this.optionsButton = new JButton();
        this.certificatesButton = new JButton();
        JLabel splashLogo = new JLabel();
        this.activationContainerPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.exitButton = new JButton();
        this.nextButton = new JButton();
        this.backButton = new JButton();
        this.modePanel.setOpaque(false);
        maltegoLogoLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/product/ico_activation_options.png")));
        this.activationModeLabel.setFont(this.activationModeLabel.getFont().deriveFont(this.activationModeLabel.getFont().getStyle() | 1, this.activationModeLabel.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.activationModeLabel, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.activationModeLabel.text_maltegoId"));
        this.activationModeLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.offlineActivationRb.setFont(this.offlineActivationRb.getFont().deriveFont(this.offlineActivationRb.getFont().getStyle() & 0xFFFFFFFE, this.offlineActivationRb.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((AbstractButton)this.offlineActivationRb, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.offlineActivationRb.text"));
        this.onlineActivationRb.setFont(this.onlineActivationRb.getFont().deriveFont(this.onlineActivationRb.getFont().getStyle() & 0xFFFFFFFE, this.onlineActivationRb.getFont().getSize() + 1));
        this.onlineActivationRb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.onlineActivationRb, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.onlineActivationRb.text"));
        this.modeSp.setBorder(null);
        this.modeSp.setOpaque(false);
        this.modeTextArea.setColumns(20);
        this.modeTextArea.setFont(this.modeTextArea.getFont().deriveFont((float)this.modeTextArea.getFont().getSize() + 1.0f));
        this.modeTextArea.setLineWrap(true);
        this.modeTextArea.setRows(4);
        this.modeTextArea.setText(NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.modeTextArea.text_maltegoId"));
        this.modeTextArea.setWrapStyleWord(true);
        this.modeTextArea.setEnabled(false);
        this.modeTextArea.setOpaque(false);
        this.modeSp.setViewportView(this.modeTextArea);
        GroupLayout modePanelLayout = new GroupLayout(this.modePanel);
        this.modePanel.setLayout(modePanelLayout);
        modePanelLayout.setHorizontalGroup(modePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modePanelLayout.createSequentialGroup().addComponent(maltegoLogoLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(modePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.offlineActivationRb).addComponent(this.onlineActivationRb).addComponent(this.modeSp, -2, 422, -2).addComponent(this.activationModeLabel, -2, 422, -2)).addContainerGap()));
        modePanelLayout.setVerticalGroup(modePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modePanelLayout.createSequentialGroup().addGroup(modePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(maltegoLogoLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.activationModeLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modeSp, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlineActivationRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offlineActivationRb).addContainerGap(-1, Short.MAX_VALUE)));
        this.optionsPanel.setOpaque(false);
        maltegoLogoLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/product/ico_activation_options.png")));
        this.activationOptionsLabel.setFont(this.activationOptionsLabel.getFont().deriveFont((float)this.activationOptionsLabel.getFont().getSize() + 5.0f));
        Mnemonics.setLocalizedText((JLabel)this.activationOptionsLabel, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.activationOptionsLabel.text"));
        this.activationOptionsLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.licenseKeyOptionPanel.setBorder(BorderFactory.createLineBorder(this.LAF.getColor("activation-type-panel-background")));
        this.licenseKeyOptionPanel.setOpaque(false);
        this.licenseKeyOptionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ActivationTypePanel.this.licenseKeyOptionPanelMouseClicked(evt);
            }
        });
        this.licenseKeyRb.setFont(this.licenseKeyRb.getFont().deriveFont(this.licenseKeyRb.getFont().getStyle() & 0xFFFFFFFE, this.licenseKeyRb.getFont().getSize() + 2));
        this.licenseKeyRb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.licenseKeyRb, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.licenseKeyRb.text"));
        this.licenseKeySp.setBorder(null);
        this.licenseKeySp.setOpaque(false);
        this.licenseKeySp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ActivationTypePanel.this.licenseKeySpMouseClicked(evt);
            }
        });
        this.licenseKeyTextArea.setColumns(20);
        this.licenseKeyTextArea.setLineWrap(true);
        this.licenseKeyTextArea.setRows(5);
        this.licenseKeyTextArea.setText(NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.licenseKeyTextArea.text"));
        this.licenseKeyTextArea.setWrapStyleWord(true);
        this.licenseKeyTextArea.setEnabled(false);
        this.licenseKeyTextArea.setOpaque(false);
        this.licenseKeyTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ActivationTypePanel.this.licenseKeyTextAreaMouseClicked(evt);
            }
        });
        this.licenseKeySp.setViewportView(this.licenseKeyTextArea);
        GroupLayout licenseKeyOptionPanelLayout = new GroupLayout(this.licenseKeyOptionPanel);
        this.licenseKeyOptionPanel.setLayout(licenseKeyOptionPanelLayout);
        licenseKeyOptionPanelLayout.setHorizontalGroup(licenseKeyOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(licenseKeyOptionPanelLayout.createSequentialGroup().addContainerGap().addGroup(licenseKeyOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.licenseKeySp, -2, 189, -2).addComponent(this.licenseKeyRb)).addContainerGap()));
        licenseKeyOptionPanelLayout.setVerticalGroup(licenseKeyOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(licenseKeyOptionPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.licenseKeyRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseKeySp).addContainerGap()));
        this.maltegoIdOptionPanel.setBorder(BorderFactory.createLineBorder(this.LAF.getColor("activation-type-panel-background")));
        this.maltegoIdOptionPanel.setOpaque(false);
        this.maltegoIdOptionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ActivationTypePanel.this.maltegoIdOptionPanelMouseClicked(evt);
            }
        });
        this.maltegoIdRb.setFont(this.maltegoIdRb.getFont().deriveFont(this.maltegoIdRb.getFont().getStyle() & 0xFFFFFFFE, this.maltegoIdRb.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((AbstractButton)this.maltegoIdRb, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.maltegoIdRb.text"));
        this.maltegoIdSp.setBorder(null);
        this.maltegoIdSp.setOpaque(false);
        this.maltegoIdSp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ActivationTypePanel.this.maltegoIdSpMouseClicked(evt);
            }
        });
        this.maltegoIdTextArea.setColumns(20);
        this.maltegoIdTextArea.setLineWrap(true);
        this.maltegoIdTextArea.setRows(6);
        this.maltegoIdTextArea.setText(NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.maltegoIdTextArea.text"));
        this.maltegoIdTextArea.setWrapStyleWord(true);
        this.maltegoIdTextArea.setEnabled(false);
        this.maltegoIdTextArea.setOpaque(false);
        this.maltegoIdTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ActivationTypePanel.this.maltegoIdTextAreaMouseClicked(evt);
            }
        });
        this.maltegoIdSp.setViewportView(this.maltegoIdTextArea);
        GroupLayout maltegoIdOptionPanelLayout = new GroupLayout(this.maltegoIdOptionPanel);
        this.maltegoIdOptionPanel.setLayout(maltegoIdOptionPanelLayout);
        maltegoIdOptionPanelLayout.setHorizontalGroup(maltegoIdOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(maltegoIdOptionPanelLayout.createSequentialGroup().addContainerGap().addGroup(maltegoIdOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maltegoIdSp, -2, 188, -2).addComponent(this.maltegoIdRb)).addContainerGap()));
        maltegoIdOptionPanelLayout.setVerticalGroup(maltegoIdOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(maltegoIdOptionPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.maltegoIdRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maltegoIdSp, -1, 145, Short.MAX_VALUE).addContainerGap()));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.licenseKeyOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maltegoIdOptionPanel, -2, -1, -2)).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(maltegoLogoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.activationOptionsLabel))).addContainerGap(23, Short.MAX_VALUE)));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(maltegoLogoLabel, -1, -1, Short.MAX_VALUE).addComponent(this.activationOptionsLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maltegoIdOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.licenseKeyOptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.welcomePanel.setOpaque(false);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1, this.titleLabel.getFont().getSize() + 5));
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.titleLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.titleMsgLabel, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.titleMsgLabel.text"));
        this.compareButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.compareButton, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.compareButton.text"));
        this.compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivationTypePanel.this.compareButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.optionsButton, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.optionsButton.text"));
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivationTypePanel.this.optionsButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.certificatesButton, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.certificatesButton.text"));
        this.certificatesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivationTypePanel.this.certificatesButtonActionPerformed(evt);
            }
        });
        GroupLayout welcomePanelLayout = new GroupLayout(this.welcomePanel);
        this.welcomePanel.setLayout(welcomePanelLayout);
        welcomePanelLayout.setHorizontalGroup(welcomePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(welcomePanelLayout.createSequentialGroup().addGroup(welcomePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleMsgLabel).addComponent(this.titleLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, welcomePanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.compareButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.certificatesButton)));
        welcomePanelLayout.setVerticalGroup(welcomePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(welcomePanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.titleMsgLabel).addGap(29, 29, 29).addGroup(welcomePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compareButton, -1, -1, Short.MAX_VALUE).addGroup(welcomePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsButton, -1, 26, Short.MAX_VALUE).addComponent(this.certificatesButton, -1, 26, Short.MAX_VALUE))).addContainerGap()));
        splashLogo.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/product/img_activation_options.png")));
        this.activationContainerPanel.setOpaque(false);
        this.activationContainerPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.exitButton, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.exitButton.text"));
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivationTypePanel.this.exitButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.nextButton, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.nextButton.text"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivationTypePanel.this.nextButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.backButton, (String)NbBundle.getMessage(ActivationTypePanel.class, (String)"ActivationTypePanel.backButton.text"));
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivationTypePanel.this.backButtonActionPerformed(evt);
            }
        });
        GroupLayout bottomPanelLayout = new GroupLayout(this.bottomPanel);
        this.bottomPanel.setLayout(bottomPanelLayout);
        bottomPanelLayout.setHorizontalGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, bottomPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.backButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton).addGap(10, 10, 10)));
        bottomPanelLayout.setVerticalGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, bottomPanelLayout.createSequentialGroup().addContainerGap(22, Short.MAX_VALUE).addGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exitButton).addComponent(this.nextButton).addComponent(this.backButton)).addGap(10, 10, 10)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.welcomePanel, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.activationContainerPanel, -2, 480, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(splashLogo)))).addComponent(this.bottomPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.welcomePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(splashLogo).addComponent(this.activationContainerPanel, -2, -1, -2)).addComponent(this.bottomPanel, -2, -1, -2).addGap(0, 0, 0)));
    }

    private void licenseKeyTextAreaMouseClicked(MouseEvent evt) {
        this.licenseKeyRb.doClick();
    }

    private void licenseKeySpMouseClicked(MouseEvent evt) {
        this.licenseKeyRb.doClick();
    }

    private void licenseKeyOptionPanelMouseClicked(MouseEvent evt) {
        this.licenseKeyRb.doClick();
    }

    private void maltegoIdTextAreaMouseClicked(MouseEvent evt) {
        this.maltegoIdRb.setSelected(true);
    }

    private void maltegoIdSpMouseClicked(MouseEvent evt) {
        this.maltegoIdRb.doClick();
    }

    private void maltegoIdOptionPanelMouseClicked(MouseEvent evt) {
        this.maltegoIdRb.doClick();
    }

    private void compareButtonActionPerformed(ActionEvent evt) {
        String licenseKey = LicenseManager.A().C();
        BrowseToUrl.compareProducts(licenseKey);
    }

    private void optionsButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        this.result = null;
        this.closeUIHook.run();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (STEP_ACTIVATION_MODE.equals(this.currentStep)) {
            if (this.licenseKeyRb.isSelected()) {
                if (this.onlineActivationRb.isSelected()) {
                    this.result = ProductSelectionResult.ACTIVATE;
                } else if (this.offlineActivationRb.isSelected()) {
                    this.result = ProductSelectionResult.OFFLINE;
                }
            } else if (this.maltegoIdRb.isSelected()) {
                if (this.onlineActivationRb.isSelected()) {
                    this.result = ProductSelectionResult.ACTIVATE_GATEWAY_MALTEGO_ID;
                } else if (this.offlineActivationRb.isSelected()) {
                    this.result = ProductSelectionResult.OFFLINE_GATEWAY_MALTEGO_ID;
                }
            }
            this.closeUIHook.run();
        } else {
            this.showActivationMode();
        }
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        this.showActivationOptions();
    }

    private void certificatesButtonActionPerformed(ActionEvent evt) {
        CertificateManagerAction.getInstance().performAction();
    }
}

