/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.browser;

import com.paterva.maltego.licensing.ui.action.CertificateManagerAction;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BrowserLoginOptionsControl
extends JPanel {
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final ChangeEventPropagator _changeSupport = new ChangeEventPropagator((Object)this);
    private boolean linkCopied = false;
    private boolean browserLoginClicked = false;
    private JTextField authUrlTextField;
    private JButton browserButton;
    private JButton certificatesButton;
    private JButton copyButton;
    private JLabel header1;
    private JLabel header2;
    private JPanel jPanel1;
    private JButton optionsButton;
    private JPanel resizePanel;
    private JLabel step1;
    private JLabel step2;
    private JLabel step3;
    private JLabel steps;

    public BrowserLoginOptionsControl() {
        this.initComponents();
        this.header1.setFont(this.header1.getFont().deriveFont(1, this.header1.getFont().getSize() + 2));
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    public String getAuthString() {
        return this.authUrlTextField.getText();
    }

    public void setAuthString(String authUrl) {
        this.authUrlTextField.setText(authUrl);
        this.authUrlTextField.setCaretPosition(0);
        if (StringUtilities.isNullOrEmpty((String)authUrl)) {
            this.copyButton.setEnabled(false);
            this.browserButton.setEnabled(false);
            this.steps.setText("Login link cannot be generated:");
            this.step1.setText("\u2022 Please check your network and proxy settings, and make sure the system is online. Click Back to try again.");
            this.step2.setText("\u2022 If the problem persists, please reach out to support@maltego.com");
            this.step3.setVisible(false);
        } else {
            this.copyButton.setEnabled(true);
            this.browserButton.setEnabled(true);
            this.steps.setText("STEPS:");
            this.step1.setText("\u2022 Copy the link into your preferred browser or open the Browser Login in the default browser");
            this.step2.setText("\u2022 Authenticate in the browser");
            this.step3.setVisible(true);
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this._changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this._changeSupport.removeChangeListener(cl);
    }

    public boolean isLinkCopied() {
        return this.linkCopied;
    }

    public void setLinkCopied(boolean linkCopied) {
        this.linkCopied = linkCopied;
    }

    public boolean isBrowserLoginClicked() {
        return this.browserLoginClicked;
    }

    public void setBrowserLoginClicked(boolean browserLoginClicked) {
        this.browserLoginClicked = browserLoginClicked;
    }

    private void showOptions() {
        OptionsDisplayer.getDefault().open("General");
    }

    private void initComponents() {
        this.header1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.optionsButton = new JButton();
        this.certificatesButton = new JButton();
        this.header2 = new JLabel();
        this.authUrlTextField = new JTextField();
        this.copyButton = new JButton();
        this.browserButton = new JButton();
        this.steps = new JLabel();
        this.step1 = new JLabel();
        this.step2 = new JLabel();
        this.step3 = new JLabel();
        this.resizePanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.header1, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.header1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 35, 0);
        this.add((Component)this.header1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.optionsButton.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.optionsButton, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.optionsButton.text"));
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserLoginOptionsControl.this.optionsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 12;
        this.jPanel1.add((Component)this.optionsButton, gridBagConstraints);
        this.certificatesButton.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.certificatesButton, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.certificatesButton.text"));
        this.certificatesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserLoginOptionsControl.this.certificatesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.certificatesButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 35, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.header2, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.header2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.header2, gridBagConstraints);
        this.authUrlTextField.setEditable(false);
        this.authUrlTextField.setColumns(8);
        this.authUrlTextField.setText(NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.authUrlTextField.text"));
        this.authUrlTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.authUrlTextField, gridBagConstraints);
        this.copyButton.setBackground(this.LAF.getColor("Button.darcula.selection.color1"));
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/copy.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.copyButton, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.copyButton.text"));
        this.copyButton.setToolTipText(NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.copyButton.toolTipText"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserLoginOptionsControl.this.copyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 15, 0);
        this.add((Component)this.copyButton, gridBagConstraints);
        this.browserButton.setBackground(this.LAF.getColor("Button.darcula.selection.color1"));
        this.browserButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browse.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.browserButton, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.browserButton.text"));
        this.browserButton.setToolTipText(NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.browserButton.toolTipText"));
        this.browserButton.setHorizontalTextPosition(2);
        this.browserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserLoginOptionsControl.this.browserButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 15, 0);
        this.add((Component)this.browserButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.steps, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.steps.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.steps, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.step1, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.step1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.step1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.step2, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.step2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.step2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.step3, (String)NbBundle.getMessage(BrowserLoginOptionsControl.class, (String)"BrowserLoginOptionsControl.step3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.step3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.resizePanel, gridBagConstraints);
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        if (!StringUtilities.isNullOrEmpty((String)this.getAuthString())) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(this.authUrlTextField.getText()), null);
            this.setLinkCopied(true);
        }
        this._changeSupport.actionPerformed(evt);
    }

    private void browserButtonActionPerformed(ActionEvent evt) {
        if (!StringUtilities.isNullOrEmpty((String)this.getAuthString())) {
            this.setBrowserLoginClicked(true);
        }
        this._changeSupport.actionPerformed(evt);
    }

    private void optionsButtonActionPerformed(ActionEvent evt) {
        this.showOptions();
    }

    private void certificatesButtonActionPerformed(ActionEvent evt) {
        CertificateManagerAction.getInstance().performAction();
    }
}

