/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.manualrequest.http.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.manualrequest.ExtensionManualRequestEditor;
import org.parosproxy.paros.extension.manualrequest.ManualRequestEditorDialog;
import org.parosproxy.paros.extension.manualrequest.http.impl.HttpPanelSender;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.view.ZapMenuItem;

@Deprecated
public class ManualHttpRequestEditorDialog
extends ManualRequestEditorDialog
implements OptionsChangedListener {
    private static final long serialVersionUID = -5830450800029295419L;
    private static final Logger logger = LogManager.getLogger(ManualHttpRequestEditorDialog.class);
    private ZapMenuItem menuItem;
    private HttpPanelSender sender;
    private RequestResponsePanel requestResponsePanel;
    private HttpPanelRequest requestPanel;
    private HttpPanelResponse responsePanel;
    private JToolBar footerToolbar = null;
    private JLabel labelTimeElapse = null;
    private JLabel labelContentLength = null;
    private JLabel labelTotalLength = null;
    private String helpKey = null;

    public ManualHttpRequestEditorDialog(boolean isSendEnabled, String configurationKey) throws HeadlessException {
        this(isSendEnabled, configurationKey, null);
    }

    public ManualHttpRequestEditorDialog(boolean isSendEnabled, String configurationKey, String helpKey) throws HeadlessException {
        super(isSendEnabled, configurationKey);
        this.helpKey = helpKey;
        this.sender = new HttpPanelSender(this.getRequestPanel(), this.getResponsePanel());
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getWindowPanel().add((Component)this.getFooterStatusBar(), "South");
        this.getFooterStatusBar().add(this.getLabelTimeLapse());
        this.getFooterStatusBar().addSeparator();
        this.getFooterStatusBar().add(this.getLabelContentLength());
        this.getFooterStatusBar().addSeparator();
        this.getFooterStatusBar().add(this.getLabelTotalLength());
    }

    @Override
    public void setVisible(boolean show) {
        super.setVisible(show);
        this.switchToTab(0);
    }

    @Override
    public Class<? extends Message> getMessageType() {
        return HttpMessage.class;
    }

    @Override
    public Message getMessage() {
        return this.getRequestPanel().getMessage();
    }

    @Override
    public void setMessage(Message aMessage) {
        if (aMessage == null) {
            return;
        }
        this.getRequestPanel().setMessage(aMessage);
        this.getResponsePanel().setMessage(aMessage);
        this.setFooterStatus(null);
        this.switchToTab(0);
    }

    @Override
    protected HttpPanelSender getMessageSender() {
        return this.sender;
    }

    @Override
    protected HttpPanelRequest getRequestPanel() {
        if (this.requestPanel == null) {
            this.requestPanel = new HttpPanelRequest(true, this.configurationKey);
            this.requestPanel.setEnableViewSelect(true);
            this.requestPanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        }
        return this.requestPanel;
    }

    private HttpPanelResponse getResponsePanel() {
        if (this.responsePanel == null) {
            this.responsePanel = new HttpPanelResponse(false, this.configurationKey);
            this.responsePanel.setEnableViewSelect(true);
            this.responsePanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        }
        return this.responsePanel;
    }

    @Override
    protected Component getManualSendPanel() {
        if (this.requestResponsePanel == null) {
            this.requestResponsePanel = new RequestResponsePanel(this.configurationKey, this.getRequestPanel(), this.getResponsePanel(), this::sendButtonTriggered);
            if (this.helpKey != null) {
                JButton helpButton = new JButton();
                helpButton.setIcon(ExtensionHelp.getHelpIcon());
                helpButton.setToolTipText(Constant.messages.getString("help.dialog.button.tooltip"));
                helpButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExtensionHelp.showHelp(ManualHttpRequestEditorDialog.this.helpKey);
                    }
                });
                this.requestResponsePanel.addToolbarButton(helpButton);
            }
            this.requestResponsePanel.addEndButton(this.getBtnSend());
            this.requestResponsePanel.addSeparator();
            this.requestResponsePanel.loadConfig();
        }
        return this.requestResponsePanel;
    }

    @Override
    protected void btnSendAction() {
        this.send(this.requestPanel.getMessage());
    }

    @Override
    protected void postSend() {
        super.postSend();
        this.switchToTab(1);
        this.setFooterStatus((HttpMessage)this.getResponsePanel().getMessage());
    }

    protected JToolBar getFooterStatusBar() {
        if (this.footerToolbar == null) {
            this.footerToolbar = new JToolBar();
            this.footerToolbar.setEnabled(true);
            this.footerToolbar.setFloatable(false);
            this.footerToolbar.setRollover(true);
            this.footerToolbar.setName("Footer Toolbar Left");
            this.footerToolbar.setBorder(BorderFactory.createEtchedBorder());
        }
        return this.footerToolbar;
    }

    private void setFooterStatus(HttpMessage msg) {
        if (msg != null) {
            long contentLength = msg.getResponseBody().length();
            long totalLength = (long)msg.getResponseHeader().toString().length() + contentLength;
            long timeLapse = msg.getTimeElapsedMillis();
            this.getLabelTimeLapse().setText(Constant.messages.getString("manReq.label.timeLapse") + String.valueOf(timeLapse) + " ms");
            this.getLabelContentLength().setText(Constant.messages.getString("manReq.label.contentLength") + String.valueOf(contentLength) + " " + Constant.messages.getString("manReq.label.totalLengthBytes"));
            this.getLabelTotalLength().setText(Constant.messages.getString("manReq.label.totalLength") + String.valueOf(totalLength) + " " + Constant.messages.getString("manReq.label.totalLengthBytes"));
        } else {
            this.getLabelTimeLapse().setText(Constant.messages.getString("manReq.label.timeLapse"));
            this.getLabelContentLength().setText(Constant.messages.getString("manReq.label.contentLength"));
            this.getLabelTotalLength().setText(Constant.messages.getString("manReq.label.totalLength"));
        }
    }

    private void switchToTab(int i) {
        if (this.requestResponsePanel != null) {
            this.requestResponsePanel.switchToTab(i);
        }
    }

    @Override
    protected void saveConfig() {
        this.requestResponsePanel.saveConfig();
    }

    @Override
    public ZapMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new ZapMenuItem("menu.tools.manReq", View.getSingleton().getMenuShortcutKeyStroke(77, 0, false));
            this.menuItem.setIcon(ExtensionManualRequestEditor.getIcon());
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Message message = ManualHttpRequestEditorDialog.this.getMessage();
                    if (message == null) {
                        ManualHttpRequestEditorDialog.this.setDefaultMessage();
                    } else if (message instanceof HttpMessage && ((HttpMessage)message).getRequestHeader().isEmpty()) {
                        ManualHttpRequestEditorDialog.this.setDefaultMessage();
                    }
                    ManualHttpRequestEditorDialog.this.setVisible(true);
                }
            });
        }
        return this.menuItem;
    }

    @Override
    public void clear() {
        super.clear();
        this.getResponsePanel().clearView();
    }

    @Override
    public void setDefaultMessage() {
        HttpMessage msg = new HttpMessage();
        try {
            URI uri = new URI("http://www.any_domain_name.org/path", true);
            msg.setRequestHeader(new HttpRequestHeader("GET", uri, "HTTP/1.1"));
            this.setMessage(msg);
        }
        catch (HttpMalformedHeaderException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (URIException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private JLabel getLabelTimeLapse() {
        if (this.labelTimeElapse == null) {
            this.labelTimeElapse = new JLabel("", 10);
        }
        return this.labelTimeElapse;
    }

    private JLabel getLabelContentLength() {
        if (this.labelContentLength == null) {
            this.labelContentLength = new JLabel("", 10);
        }
        return this.labelContentLength;
    }

    private JLabel getLabelTotalLength() {
        if (this.labelTotalLength == null) {
            this.labelTotalLength = new JLabel("", 10);
        }
        return this.labelTotalLength;
    }

    public void addPersistentConnectionListener(PersistentConnectionListener listener) {
        this.getMessageSender().addPersistentConnectionListener(listener);
    }

    public void removePersistentConnectionListener(PersistentConnectionListener listener) {
        this.getMessageSender().removePersistentConnectionListener(listener);
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        this.getMessageSender().updateButtonTrackingSessionState();
    }

    private static final class RequestResponsePanel
    extends JPanel {
        private static final String REQUEST_CAPTION = Constant.messages.getString("manReq.tab.request");
        private static final String RESPONSE_CAPTION = Constant.messages.getString("manReq.tab.response");
        private static final String TABS_VIEW_TOOL_TIP = Constant.messages.getString("manReq.display.tabs");
        private static final String ABOVE_VIEW_TOOL_TIP = Constant.messages.getString("manReq.display.above");
        private static final String SIDE_BY_SIDE_VIEW_TOOL_TIP = Constant.messages.getString("manReq.display.sidebyside");
        private static final String SELECTEDLAYOUT_CONFIG_KEY = "selectedlayout";
        private static final String HORIZONTAL_DIVIDER_LOCATION_CONFIG_KEY = "horizontalDividerLocation";
        private static final String VERTICAL_DIVIDER_LOCATION_CONFIG_KEY = "verticalDividerLocation";
        private static final long serialVersionUID = -3335708932021769432L;
        private static final int TABS_VIEW = 0;
        private static final int ABOVE_VIEW = 1;
        private static final int SIDE_BY_SIDE_VIEW = 2;
        private final HttpPanelRequest requestPanel;
        private final HttpPanelResponse responsePanel;
        private int currentView;
        private JComponent currentViewPanel;
        private JToggleButton currentButtonView;
        private JToggleButton tabsButtonView;
        private JToggleButton aboveButtonView;
        private JToggleButton sideBySideButtonView;
        private String configurationKey;
        private int verticalDividerLocation;
        private int horizontalDividerLocation;
        private JButton responseSendButton;
        private Runnable sendAction;

        public RequestResponsePanel(String configurationKey, HttpPanelRequest request, HttpPanelResponse response, Runnable sendAction) throws IllegalArgumentException {
            super(new BorderLayout());
            if (request == null || response == null) {
                throw new IllegalArgumentException("The request and response panels cannot be null.");
            }
            this.configurationKey = configurationKey;
            this.requestPanel = request;
            this.responsePanel = response;
            this.sendAction = sendAction;
            this.currentView = -1;
            this.tabsButtonView = new JToggleButton(new ImageIcon(ManualRequestEditorDialog.class.getResource("/resource/icon/layout_tabbed.png")));
            this.tabsButtonView.setToolTipText(TABS_VIEW_TOOL_TIP);
            this.tabsButtonView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.changeView(0);
                }
            });
            this.addToolbarButton(this.tabsButtonView);
            this.aboveButtonView = new JToggleButton(new ImageIcon(ManualRequestEditorDialog.class.getResource("/resource/icon/layout_vertical_split.png")));
            this.aboveButtonView.setToolTipText(ABOVE_VIEW_TOOL_TIP);
            this.aboveButtonView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.changeView(1);
                }
            });
            this.addToolbarButton(this.aboveButtonView);
            this.sideBySideButtonView = new JToggleButton(new ImageIcon(ManualRequestEditorDialog.class.getResource("/resource/icon/layout_horizontal_split.png")));
            this.sideBySideButtonView.setToolTipText(SIDE_BY_SIDE_VIEW_TOOL_TIP);
            this.sideBySideButtonView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.changeView(2);
                }
            });
            this.addToolbarButton(this.sideBySideButtonView);
            this.responsePanel.addOptions(this.getResponseSendButton(), HttpPanel.OptionsLocation.END);
        }

        public void loadConfig() {
            this.verticalDividerLocation = Model.getSingleton().getOptionsParam().getConfig().getInt(this.configurationKey + VERTICAL_DIVIDER_LOCATION_CONFIG_KEY, -1);
            this.horizontalDividerLocation = Model.getSingleton().getOptionsParam().getConfig().getInt(this.configurationKey + HORIZONTAL_DIVIDER_LOCATION_CONFIG_KEY, -1);
            this.changeView(Model.getSingleton().getOptionsParam().getConfig().getInt(this.configurationKey + SELECTEDLAYOUT_CONFIG_KEY, 0));
            this.requestPanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
            this.responsePanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        }

        public void saveConfig() {
            switch (this.currentView) {
                case 1: {
                    this.verticalDividerLocation = ((JSplitPane)this.currentViewPanel).getDividerLocation();
                    break;
                }
                case 2: {
                    this.horizontalDividerLocation = ((JSplitPane)this.currentViewPanel).getDividerLocation();
                    break;
                }
            }
            Model.getSingleton().getOptionsParam().getConfig().setProperty(this.configurationKey + VERTICAL_DIVIDER_LOCATION_CONFIG_KEY, (Object)this.verticalDividerLocation);
            Model.getSingleton().getOptionsParam().getConfig().setProperty(this.configurationKey + HORIZONTAL_DIVIDER_LOCATION_CONFIG_KEY, (Object)this.horizontalDividerLocation);
            Model.getSingleton().getOptionsParam().getConfig().setProperty(this.configurationKey + SELECTEDLAYOUT_CONFIG_KEY, (Object)this.currentView);
            this.requestPanel.saveConfig(Model.getSingleton().getOptionsParam().getConfig());
            this.responsePanel.saveConfig(Model.getSingleton().getOptionsParam().getConfig());
        }

        public void addToolbarButton(JToggleButton button) {
            this.requestPanel.addOptions(button, HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        }

        public void addToolbarButton(JButton button) {
            this.requestPanel.addOptions(button, HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        }

        public void addSeparator() {
            this.requestPanel.addOptionsSeparator();
        }

        public void addEndButton(JButton button) {
            this.requestPanel.addOptions(button, HttpPanel.OptionsLocation.END);
        }

        public void switchToTab(int i) {
            if (this.currentView == 0) {
                ((JTabbedPane)this.currentViewPanel).setSelectedIndex(i);
            }
        }

        public void changeView(int newView) {
            if (newView != this.currentView) {
                int oldView = this.currentView;
                this.currentView = newView;
                if (oldView != -1) {
                    this.removeAll();
                    this.currentButtonView.setSelected(false);
                    switch (oldView) {
                        case 1: {
                            this.verticalDividerLocation = ((JSplitPane)this.currentViewPanel).getDividerLocation();
                            break;
                        }
                        case 2: {
                            this.horizontalDividerLocation = ((JSplitPane)this.currentViewPanel).getDividerLocation();
                            break;
                        }
                    }
                }
                switch (newView) {
                    case 0: {
                        this.switchToTabsView();
                        break;
                    }
                    case 1: {
                        this.switchToAboveView();
                        break;
                    }
                    case 2: {
                        this.switchToSideBySideView();
                        break;
                    }
                    default: {
                        this.switchToTabsView();
                    }
                }
                this.currentButtonView.setSelected(true);
                this.add(this.currentViewPanel);
                this.validate();
                this.repaint();
            }
        }

        private void switchToTabsView() {
            this.currentView = 0;
            this.currentButtonView = this.tabsButtonView;
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab(REQUEST_CAPTION, null, this.requestPanel, null);
            tabbedPane.addTab(RESPONSE_CAPTION, null, this.responsePanel, null);
            tabbedPane.setSelectedIndex(0);
            this.getResponseSendButton().setVisible(true);
            this.currentViewPanel = tabbedPane;
        }

        private void switchToAboveView() {
            this.currentView = 1;
            this.currentButtonView = this.aboveButtonView;
            this.getResponseSendButton().setVisible(false);
            this.currentViewPanel = this.createSplitPane(0);
        }

        private void switchToSideBySideView() {
            this.currentView = 2;
            this.currentButtonView = this.sideBySideButtonView;
            this.getResponseSendButton().setVisible(false);
            this.currentViewPanel = this.createSplitPane(1);
        }

        private JSplitPane createSplitPane(int orientation) {
            JTabbedPane tabbedPaneRequest = new JTabbedPane();
            tabbedPaneRequest.addTab(REQUEST_CAPTION, null, this.requestPanel, null);
            JTabbedPane tabbedPaneResponse = new JTabbedPane();
            tabbedPaneResponse.addTab(RESPONSE_CAPTION, null, this.responsePanel, null);
            JSplitPane splitPane = new JSplitPane(orientation, tabbedPaneRequest, tabbedPaneResponse);
            splitPane.setDividerSize(3);
            splitPane.setResizeWeight(0.5);
            splitPane.setContinuousLayout(false);
            splitPane.setDoubleBuffered(true);
            int dividerLocation = orientation == 1 ? this.horizontalDividerLocation : this.verticalDividerLocation;
            splitPane.setDividerLocation(dividerLocation);
            return splitPane;
        }

        private JButton getResponseSendButton() {
            if (this.responseSendButton == null) {
                this.responseSendButton = new JButton(Constant.messages.getString("manReq.button.send"));
                this.responseSendButton.setMnemonic(10);
                this.responseSendButton.setToolTipText(ManualHttpRequestEditorDialog.getBtnSendTooltip());
                this.responseSendButton.addActionListener(e -> {
                    this.responseSendButton.setEnabled(false);
                    this.sendAction.run();
                    this.responseSendButton.setEnabled(true);
                });
            }
            return this.responseSendButton;
        }
    }
}

