/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.Desktop;
import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DesktopUtils {
    private static BrowserInvoker invoker = Desktop.isDesktopSupported() ? BrowserInvoker.desktop : BrowserInvoker.none;
    private static final Logger LOGGER = LogManager.getLogger(DesktopUtils.class);

    public static boolean openUrlInBrowser(URI uri) {
        try {
            if (invoker == BrowserInvoker.desktop) {
                Desktop.getDesktop().browse(uri);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            invoker = BrowserInvoker.none;
        }
        return false;
    }

    public static boolean openUrlInBrowser(String uri) {
        try {
            return DesktopUtils.openUrlInBrowser(new URI(uri));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            invoker = BrowserInvoker.none;
            return false;
        }
    }

    public static boolean openUrlInBrowser(org.apache.commons.httpclient.URI uri) {
        try {
            return DesktopUtils.openUrlInBrowser(uri.toString());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            invoker = BrowserInvoker.none;
            return false;
        }
    }

    public static boolean canOpenUrlInBrowser() {
        return invoker == BrowserInvoker.desktop;
    }

    private static enum BrowserInvoker {
        desktop,
        none;

    }
}

